/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.jps.incremental.groovy;

import com.intellij.compiler.instrumentation.FailSafeClassReader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.lang.JavaVersion;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.ModuleChunk;
import org.jetbrains.jps.ProjectPaths;
import org.jetbrains.jps.builders.BuildRootDescriptor;
import org.jetbrains.jps.builders.BuildTarget;
import org.jetbrains.jps.builders.DirtyFilesHolder;
import org.jetbrains.jps.builders.FileProcessor;
import org.jetbrains.jps.builders.java.JavaBuilderUtil;
import org.jetbrains.jps.builders.java.dependencyView.Callbacks;
import org.jetbrains.jps.builders.storage.SourceToOutputMapping;
import org.jetbrains.jps.incremental.Builder;
import org.jetbrains.jps.incremental.CompileContext;
import org.jetbrains.jps.incremental.ModuleLevelBuilder;
import org.jetbrains.jps.incremental.ProjectBuildException;
import org.jetbrains.jps.incremental.StopBuildException;
import org.jetbrains.jps.incremental.Utils;
import org.jetbrains.jps.incremental.groovy.ForkedGroovyc;
import org.jetbrains.jps.incremental.groovy.GroovyBuilder;
import org.jetbrains.jps.incremental.groovy.GroovyBuilderExtension;
import org.jetbrains.jps.incremental.groovy.GroovyOutputConsumer;
import org.jetbrains.jps.incremental.groovy.GroovycContinuation;
import org.jetbrains.jps.incremental.groovy.GroovycFlavor;
import org.jetbrains.jps.incremental.groovy.GroovycOutputParser;
import org.jetbrains.jps.incremental.groovy.InProcessGroovyc;
import org.jetbrains.jps.incremental.groovy.JpsGroovySettings;
import org.jetbrains.jps.incremental.java.JavaBuilder;
import org.jetbrains.jps.incremental.messages.BuildMessage;
import org.jetbrains.jps.incremental.messages.CompilerMessage;
import org.jetbrains.jps.model.JpsDummyElement;
import org.jetbrains.jps.model.java.JpsJavaExtensionService;
import org.jetbrains.jps.model.java.JpsJavaSdkType;
import org.jetbrains.jps.model.java.compiler.JpsJavaCompilerConfiguration;
import org.jetbrains.jps.model.library.sdk.JpsSdk;
import org.jetbrains.jps.service.JpsServiceManager;
import org.jetbrains.org.objectweb.asm.ClassReader;

public abstract class JpsGroovycRunner<R extends BuildRootDescriptor, T extends BuildTarget<R>> {
    private static final int ourOptimizeThreshold = Integer.parseInt(System.getProperty("groovyc.optimized.class.loading.threshold", "10"));
    private static final Logger LOG = Logger.getInstance((String)"#org.jetbrains.jps.incremental.groovy.JpsGroovycRunner");
    private static final Key<Boolean> CHUNK_REBUILD_ORDERED = Key.create((String)"CHUNK_REBUILD_ORDERED");
    private static final Key<Map<ModuleChunk, GroovycContinuation>> CONTINUATIONS = Key.create((String)"CONTINUATIONS");
    public static final String GROOVYC_IN_PROCESS = "groovyc.in.process";
    final boolean myForStubs;

    public JpsGroovycRunner(boolean forStubs) {
        this.myForStubs = forStubs;
    }

    @NotNull
    ModuleLevelBuilder.ExitCode doBuild(CompileContext context, ModuleChunk chunk, DirtyFilesHolder<R, T> dirtyFilesHolder, Builder builder, GroovyOutputConsumer outputConsumer) throws ProjectBuildException {
        List<CompilerMessage> messages;
        long start = 0L;
        try {
            Map<T, String> finalOutputs;
            Ref hasStubExcludes = Ref.create((Object)false);
            List<File> toCompile = this.collectChangedFiles(context, dirtyFilesHolder, this.myForStubs, (Ref<Boolean>)hasStubExcludes);
            if (toCompile.isEmpty()) {
                ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.NOTHING_DONE;
                return exitCode;
            }
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("forStubs=" + this.myForStubs);
            }
            if ((finalOutputs = this.getCanonicalOutputs(context, chunk, builder)) == null) {
                ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.ABORT;
                return exitCode;
            }
            start = System.currentTimeMillis();
            Map<T, String> generationOutputs = this.getGenerationOutputs(context, chunk, finalOutputs);
            String compilerOutput = generationOutputs.get(this.representativeTarget(generationOutputs));
            GroovycOutputParser parser = this.runGroovycOrContinuation(context, chunk, finalOutputs, compilerOutput, toCompile, (Boolean)hasStubExcludes.get());
            MultiMap<T, GroovycOutputParser.OutputItem> compiled = this.processCompiledFiles(context, chunk, generationOutputs, compilerOutput, parser.getSuccessfullyCompiled());
            if (this.checkChunkRebuildNeeded(context, parser)) {
                JpsGroovycRunner.clearContinuation(context, chunk);
                ModuleLevelBuilder.ExitCode exitCode = ModuleLevelBuilder.ExitCode.CHUNK_REBUILD_REQUIRED;
                return exitCode;
            }
            messages = parser.getCompilerMessages();
            for (CompilerMessage message2 : messages) {
                context.processMessage((BuildMessage)message2);
            }
            if (this.myForStubs) {
                this.stubsGenerated(context, generationOutputs, compiled);
            } else {
                this.updateDependencies(context, toCompile, compiled, outputConsumer, builder);
            }
        }
        catch (Exception e) {
            throw new ProjectBuildException((Throwable)e);
        }
        finally {
            if (start > 0L && LOG.isDebugEnabled()) {
                LOG.debug(builder.getPresentableName() + " took " + (System.currentTimeMillis() - start) + " on " + chunk.getName());
            }
        }
        if (ContainerUtil.exists(messages, message -> message.getKind() == BuildMessage.Kind.ERROR)) {
            throw new StopBuildException();
        }
        return ModuleLevelBuilder.ExitCode.OK;
    }

    protected void stubsGenerated(CompileContext context, Map<T, String> generationOutputs, MultiMap<T, GroovycOutputParser.OutputItem> compiled) {
    }

    protected Map<T, String> getGenerationOutputs(CompileContext context, ModuleChunk chunk, Map<T, String> finalOutputs) throws IOException {
        return finalOutputs;
    }

    protected abstract Map<T, String> getCanonicalOutputs(CompileContext var1, ModuleChunk var2, Builder var3);

    @NotNull
    private GroovycOutputParser runGroovycOrContinuation(CompileContext context, ModuleChunk chunk, Map<T, String> finalOutputs, String compilerOutput, List<File> toCompile, boolean hasStubExcludes) throws Exception {
        GroovycContinuation continuation;
        if (this.myForStubs) {
            JpsGroovycRunner.clearContinuation(context, chunk);
        }
        if ((continuation = JpsGroovycRunner.takeContinuation(context, chunk)) != null) {
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("using continuation for " + chunk);
            }
            return continuation.continueCompilation();
        }
        Set<String> toCompilePaths = JpsGroovycRunner.getPathsToCompile(toCompile);
        JpsSdk<JpsDummyElement> jdk = GroovyBuilder.getJdk(chunk);
        int version = jdk != null ? JpsJavaSdkType.getJavaVersion(jdk) : JavaVersion.current().feature;
        boolean inProcess = JpsGroovycRunner.shouldRunGroovycInProcess(version);
        boolean mayDependOnUtilJar = version >= 6;
        boolean optimizeClassLoading = !inProcess && mayDependOnUtilJar && ourOptimizeThreshold != 0 && toCompilePaths.size() >= ourOptimizeThreshold;
        Map<String, String> class2Src = this.buildClassToSourceMap(chunk, context, toCompilePaths, finalOutputs);
        String encoding = context.getProjectDescriptor().getEncodingConfiguration().getPreferredModuleChunkEncoding(chunk);
        ArrayList<String> patchers = new ArrayList<String>();
        for (GroovyBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(GroovyBuilderExtension.class)) {
            patchers.addAll(extension.getCompilationUnitPatchers(context, chunk));
        }
        Collection<String> classpath = this.generateClasspath(context, chunk);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Optimized class loading: " + optimizeClassLoading);
            LOG.debug("Groovyc classpath: " + classpath);
        }
        File tempFile = GroovycOutputParser.fillFileWithGroovycParameters(compilerOutput, toCompilePaths, finalOutputs.values(), class2Src, encoding, patchers, optimizeClassLoading ? StringUtil.join(classpath, (String)File.pathSeparator) : "");
        GroovycFlavor groovyc = inProcess ? new InProcessGroovyc(finalOutputs.values(), hasStubExcludes) : new ForkedGroovyc(optimizeClassLoading, chunk);
        GroovycOutputParser parser = new GroovycOutputParser(chunk, context);
        continuation = groovyc.runGroovyc(classpath, this.myForStubs, context, tempFile, parser, JpsGroovycRunner.getBytecodeTarget(context, chunk));
        JpsGroovycRunner.setContinuation(context, chunk, continuation);
        return parser;
    }

    @Nullable
    static String getBytecodeTarget(CompileContext context, ModuleChunk chunk) {
        String explicit = System.getProperty("groovy.target.bytecode");
        if (explicit != null) {
            return explicit;
        }
        int bytecodeTarget = JavaBuilder.getModuleBytecodeTarget((CompileContext)context, (ModuleChunk)chunk, (JpsJavaCompilerConfiguration)JpsGroovycRunner.getJavaCompilerSettings(context));
        return bytecodeTarget == 0 ? null : (bytecodeTarget >= 9 ? String.valueOf(bytecodeTarget) : "1." + bytecodeTarget);
    }

    private static boolean shouldRunGroovycInProcess(int jdkVersion) {
        String explicitProperty = System.getProperty(GROOVYC_IN_PROCESS);
        return explicitProperty != null ? "true".equals(explicitProperty) : jdkVersion == JavaVersion.current().feature || jdkVersion < 5;
    }

    static void clearContinuation(CompileContext context, ModuleChunk chunk) {
        GroovycContinuation continuation = JpsGroovycRunner.takeContinuation(context, chunk);
        if (continuation != null) {
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("clearing continuation for " + chunk);
            }
            continuation.buildAborted();
        }
    }

    @Nullable
    private static GroovycContinuation takeContinuation(CompileContext context, ModuleChunk chunk) {
        Map map = (Map)CONTINUATIONS.get((UserDataHolder)context);
        return map == null ? null : (GroovycContinuation)map.remove(chunk);
    }

    private static void setContinuation(CompileContext context, ModuleChunk chunk, @Nullable GroovycContinuation continuation) {
        JpsGroovycRunner.clearContinuation(context, chunk);
        if (continuation != null) {
            Map map;
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("registering continuation for " + chunk);
            }
            if ((map = (Map)CONTINUATIONS.get((UserDataHolder)context)) == null) {
                map = ContainerUtil.newConcurrentMap();
                CONTINUATIONS.set((UserDataHolder)context, (Object)map);
            }
            map.put(chunk, continuation);
        }
    }

    private static Set<String> getPathsToCompile(List<File> toCompile) {
        LinkedHashSet<String> toCompilePaths = new LinkedHashSet<String>();
        for (File file : toCompile) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Path to compile: " + file.getPath());
            }
            toCompilePaths.add(FileUtil.toSystemIndependentName((String)file.getPath()));
        }
        return toCompilePaths;
    }

    protected boolean checkChunkRebuildNeeded(CompileContext context, GroovycOutputParser parser) {
        if (CHUNK_REBUILD_ORDERED.get((UserDataHolder)context) != null) {
            if (!this.myForStubs) {
                CHUNK_REBUILD_ORDERED.set((UserDataHolder)context, null);
            }
            return false;
        }
        if (JavaBuilderUtil.isForcedRecompilationAllJavaModules((CompileContext)context) || !parser.shouldRetry()) {
            return false;
        }
        CHUNK_REBUILD_ORDERED.set((UserDataHolder)context, (Object)Boolean.TRUE);
        LOG.info("Order chunk rebuild");
        return true;
    }

    protected abstract R findRoot(CompileContext var1, File var2);

    MultiMap<T, GroovycOutputParser.OutputItem> processCompiledFiles(CompileContext context, ModuleChunk chunk, Map<T, String> generationOutputs, String compilerOutput, List<GroovycOutputParser.OutputItem> successfullyCompiled) throws IOException {
        MultiMap compiled = MultiMap.createSet();
        for (GroovycOutputParser.OutputItem item : successfullyCompiled) {
            R rd;
            if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                LOG.info("compiled=" + item);
            }
            if ((rd = this.findRoot(context, new File(item.sourcePath))) != null) {
                BuildTarget target = rd.getTarget();
                String outputPath = this.ensureCorrectOutput(chunk, item, generationOutputs, compilerOutput, target);
                compiled.putValue((Object)target, (Object)new GroovycOutputParser.OutputItem(outputPath, item.sourcePath));
                continue;
            }
            if (!Utils.IS_TEST_MODE && !LOG.isDebugEnabled()) continue;
            LOG.info("No java source root descriptor for the item found =" + item);
        }
        if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
            LOG.info("Chunk " + chunk + " compilation finished");
        }
        return compiled;
    }

    protected abstract Set<T> getTargets(ModuleChunk var1);

    private String ensureCorrectOutput(ModuleChunk chunk, GroovycOutputParser.OutputItem item, Map<T, String> generationOutputs, String compilerOutput, @NotNull T srcTarget) throws IOException {
        if (chunk.getModules().size() > 1 && !srcTarget.equals(this.representativeTarget(generationOutputs))) {
            File output = new File(item.outputPath);
            String srcTargetOutput = generationOutputs.get(srcTarget);
            if (srcTargetOutput == null) {
                LOG.info("No output for " + srcTarget + "; outputs=" + generationOutputs + "; targets = " + this.getTargets(chunk));
                return item.outputPath;
            }
            File correctRoot = new File(srcTargetOutput);
            File correctOutput = new File(correctRoot, (String)ObjectUtils.assertNotNull((Object)FileUtil.getRelativePath((File)new File(compilerOutput), (File)output)));
            FileUtil.rename((File)output, (File)correctOutput);
            return correctOutput.getPath();
        }
        return item.outputPath;
    }

    private T representativeTarget(Map<T, String> generationOutputs) {
        return (T)((BuildTarget)generationOutputs.keySet().iterator().next());
    }

    List<File> collectChangedFiles(CompileContext context, DirtyFilesHolder<R, T> dirtyFilesHolder, final boolean forStubs, final Ref<Boolean> hasExcludes) throws IOException {
        final JpsJavaCompilerConfiguration configuration = JpsGroovycRunner.getJavaCompilerSettings(context);
        final JpsGroovySettings settings = JpsGroovycRunner.getGroovyCompilerSettings(context);
        final ArrayList<File> toCompile = new ArrayList<File>();
        dirtyFilesHolder.processDirtyFiles(new FileProcessor<R, T>(){

            public boolean apply(T target, File file, R sourceRoot) {
                if (JpsGroovycRunner.this.shouldProcessSourceFile(file, sourceRoot, file.getPath(), configuration)) {
                    if (forStubs && settings.isExcludedFromStubGeneration(file)) {
                        hasExcludes.set((Object)true);
                        return true;
                    }
                    toCompile.add(file);
                }
                return true;
            }
        });
        return toCompile;
    }

    @NotNull
    static JpsGroovySettings getGroovyCompilerSettings(CompileContext context) {
        return JpsGroovySettings.getSettings(context.getProjectDescriptor().getProject());
    }

    @NotNull
    static JpsJavaCompilerConfiguration getJavaCompilerSettings(CompileContext context) {
        return Objects.requireNonNull(JpsJavaExtensionService.getInstance().getCompilerConfiguration(context.getProjectDescriptor().getProject()));
    }

    protected boolean shouldProcessSourceFile(File file, R sourceRoot, String path, JpsJavaCompilerConfiguration configuration) {
        return this.acceptsFileType(path) && !configuration.isResourceFile(file, sourceRoot.getRootFile());
    }

    protected boolean acceptsFileType(String path) {
        return GroovyBuilder.isGroovyFile(path);
    }

    void updateDependencies(CompileContext context, List<File> toCompile, MultiMap<T, GroovycOutputParser.OutputItem> successfullyCompiled, GroovyOutputConsumer outputConsumer, Builder builder) {
        JavaBuilderUtil.registerFilesToCompile((CompileContext)context, toCompile);
        if (!successfullyCompiled.isEmpty()) {
            Callbacks.Backend callback = JavaBuilderUtil.getDependenciesRegistrar((CompileContext)context);
            for (Map.Entry entry : successfullyCompiled.entrySet()) {
                BuildTarget target = (BuildTarget)entry.getKey();
                Collection compiled = (Collection)entry.getValue();
                for (GroovycOutputParser.OutputItem item : compiled) {
                    String sourcePath = FileUtil.toSystemIndependentName((String)item.sourcePath);
                    String outputPath = FileUtil.toSystemIndependentName((String)item.outputPath);
                    File outputFile = new File(outputPath);
                    File srcFile = new File(sourcePath);
                    try {
                        byte[] bytes = FileUtil.loadFileBytes((File)outputFile);
                        if (Utils.IS_TEST_MODE || LOG.isDebugEnabled()) {
                            LOG.info("registerCompiledClass " + outputFile + " from " + srcFile);
                        }
                        outputConsumer.registerCompiledClass(target, srcFile, outputFile, bytes);
                        callback.associate(outputPath, sourcePath, (ClassReader)new FailSafeClassReader(bytes));
                    }
                    catch (Throwable e) {
                        String message = "Class dependency information may be incomplete! Error parsing generated class " + item.outputPath;
                        LOG.info(message, e);
                        context.processMessage((BuildMessage)new CompilerMessage(builder.getPresentableName(), BuildMessage.Kind.WARNING, message + "\n" + CompilerMessage.getTextFromThrowable((Throwable)e), sourcePath));
                    }
                    JavaBuilderUtil.registerSuccessfullyCompiled((CompileContext)context, (File)srcFile);
                }
            }
        }
    }

    protected Collection<String> generateClasspath(CompileContext context, ModuleChunk chunk) {
        LinkedHashSet<String> cp = new LinkedHashSet<String>(GroovyBuilder.getGroovyRtRoots());
        for (File file : ProjectPaths.getCompilationClasspathFiles((ModuleChunk)chunk, (boolean)chunk.containsTests(), (boolean)false, (boolean)false)) {
            cp.add(FileUtil.toCanonicalPath((String)file.getPath()));
        }
        for (GroovyBuilderExtension extension : JpsServiceManager.getInstance().getExtensions(GroovyBuilderExtension.class)) {
            cp.addAll(extension.getCompilationClassPath(context, chunk));
        }
        return cp;
    }

    private Map<String, String> buildClassToSourceMap(ModuleChunk chunk, CompileContext context, Set<String> toCompilePaths, Map<T, String> finalOutputs) throws IOException {
        HashMap<String, String> class2Src = new HashMap<String, String>();
        JpsJavaCompilerConfiguration configuration = JpsJavaExtensionService.getInstance().getOrCreateCompilerConfiguration(context.getProjectDescriptor().getProject());
        for (BuildTarget target : this.getTargets(chunk)) {
            String moduleOutputPath = finalOutputs.get(target);
            SourceToOutputMapping srcToOut = context.getProjectDescriptor().dataManager.getSourceToOutputMap(target);
            for (String src : srcToOut.getSources()) {
                Collection outs;
                if (toCompilePaths.contains(src) || !GroovyBuilder.isGroovyFile(src) || configuration.getCompilerExcludes().isExcluded(new File(src)) || (outs = srcToOut.getOutputs(src)) == null) continue;
                for (String out : outs) {
                    if (!out.endsWith(".class") || !out.startsWith(moduleOutputPath)) continue;
                    String className = out.substring(moduleOutputPath.length(), out.length() - ".class".length()).replace('/', '.');
                    class2Src.put(className, src);
                }
            }
        }
        return class2Src;
    }
}

