/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.git4idea.nativessh;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.git4idea.GitExternalApp;
import org.jetbrains.git4idea.nativessh.GitNativeSshAskPassXmlRpcClient;

public class GitNativeSshAskPassApp
implements GitExternalApp {
    public static void main(String[] args) {
        try {
            String description = args.length > 0 ? args[0] : "";
            String token = GitNativeSshAskPassApp.getNotNull("INTELLIJ_SSH_ASKPASS_HANDLER");
            int xmlRpcPort = Integer.parseInt(GitNativeSshAskPassApp.getNotNull("INTELLIJ_SSH_ASKPASS_PORT"));
            String xmlRpcToken = GitNativeSshAskPassApp.getNotNull("GIT_ASKPASS_TOKEN");
            GitNativeSshAskPassXmlRpcClient xmlRpcClient = new GitNativeSshAskPassXmlRpcClient(xmlRpcPort, xmlRpcToken);
            String answer = GitNativeSshAskPassApp.adjustNull(xmlRpcClient.handleInput(token, description));
            if (answer == null) {
                System.exit(1);
            }
            System.out.println(answer);
        }
        catch (Throwable t) {
            System.err.println(t.getMessage());
            t.printStackTrace(System.err);
        }
    }

    @NotNull
    private static String getNotNull(@NotNull String env) {
        String value = System.getenv(env);
        if (value == null) {
            throw new IllegalStateException(env + " environment variable is not defined!");
        }
        return value;
    }

    @Nullable
    private static String adjustNull(String s) {
        return s.charAt(0) == '-' ? null : s.substring(1);
    }
}

