/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.ExecutionManager;
import com.intellij.execution.Executor;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.actions.CloseAction;
import com.intellij.ide.actions.ShowLogAction;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.terminal.JBTerminalSystemSettingsProviderBase;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.AppUIUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.update.UiNotifyConnector;
import com.jediterm.terminal.RequestOrigin;
import com.jediterm.terminal.Terminal;
import com.jediterm.terminal.TerminalStarter;
import com.jediterm.terminal.TtyConnector;
import com.jediterm.terminal.ui.JediTermWidget;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.util.concurrent.ExecutionException;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.JBTerminalSystemSettingsProvider;

public abstract class AbstractTerminalRunner<T extends Process> {
    private static final Logger LOG = Logger.getInstance(AbstractTerminalRunner.class);
    @NotNull
    protected final Project myProject;
    private final JBTerminalSystemSettingsProvider mySettingsProvider;

    public JBTerminalSystemSettingsProvider getSettingsProvider() {
        return this.mySettingsProvider;
    }

    public AbstractTerminalRunner(@NotNull Project project) {
        this.myProject = project;
        this.mySettingsProvider = new JBTerminalSystemSettingsProvider();
        Disposer.register((Disposable)project, (Disposable)this.mySettingsProvider);
    }

    public void run() {
        ProgressManager.getInstance().run((Task)new Task.Backgroundable(this.myProject, "Running the Terminal", false){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setText("Running the terminal...");
                try {
                    AbstractTerminalRunner.this.doRun();
                }
                catch (Exception e) {
                    LOG.warn("Error running terminal", (Throwable)e);
                    UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)AbstractTerminalRunner.this.getProject(), (String)e.getMessage(), (String)this.getTitle()));
                }
            }
        });
    }

    private void doRun() {
        try {
            T process = this.createProcess(null);
            UIUtil.invokeLaterIfNeeded(() -> this.initConsoleUI(process));
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    protected abstract T createProcess(@Nullable String var1) throws ExecutionException;

    @ApiStatus.Experimental
    protected T createProcess(@Nullable String directory, @Nullable String commandHistoryFilePath) throws ExecutionException {
        return this.createProcess(directory);
    }

    protected abstract ProcessHandler createProcessHandler(T var1);

    @NotNull
    public JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory) {
        return this.createTerminalWidget(parent, currentWorkingDirectory, true);
    }

    @NotNull
    protected JBTerminalWidget createTerminalWidget(@NotNull Disposable parent, @Nullable VirtualFile currentWorkingDirectory, boolean deferSessionUntilFirstShown) {
        JBTerminalWidget terminalWidget = new JBTerminalWidget(this.myProject, (JBTerminalSystemSettingsProviderBase)this.mySettingsProvider, parent);
        Runnable openSession = () -> this.openSessionForFile(terminalWidget, currentWorkingDirectory);
        if (deferSessionUntilFirstShown) {
            UiNotifyConnector.doWhenFirstShown((JComponent)terminalWidget, (Runnable)openSession);
        } else {
            openSession.run();
        }
        return terminalWidget;
    }

    private void initConsoleUI(T process) {
        Executor defaultExecutor = DefaultRunExecutor.getRunExecutorInstance();
        DefaultActionGroup toolbarActions = new DefaultActionGroup();
        ActionToolbar actionToolbar = ActionManager.getInstance().createActionToolbar("TerminalRunner", (ActionGroup)toolbarActions, false);
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)actionToolbar.getComponent(), "West");
        actionToolbar.setTargetComponent((JComponent)panel);
        ProcessHandler processHandler = this.createProcessHandler(process);
        RunContentDescriptor contentDescriptor = new RunContentDescriptor(null, processHandler, (JComponent)panel, this.getTerminalConnectionName(process));
        contentDescriptor.setAutoFocusContent(true);
        toolbarActions.add(this.createCloseAction(defaultExecutor, contentDescriptor));
        JBTerminalSystemSettingsProvider provider = new JBTerminalSystemSettingsProvider();
        JBTerminalWidget widget = new JBTerminalWidget(this.myProject, (JBTerminalSystemSettingsProviderBase)provider, (Disposable)contentDescriptor);
        AbstractTerminalRunner.createAndStartSession(widget, this.createTtyConnector(process));
        panel.add((Component)widget.getComponent(), "Center");
        this.showConsole(defaultExecutor, contentDescriptor, widget.getComponent());
        processHandler.startNotify();
    }

    public void openSession(@NotNull JBTerminalWidget terminal) {
        this.openSessionInDirectory(terminal, null);
    }

    public static void createAndStartSession(@NotNull JBTerminalWidget terminal, @NotNull TtyConnector ttyConnector) {
        JediTermWidget session = terminal.createTerminalSession(ttyConnector);
        session.start();
    }

    protected abstract String getTerminalConnectionName(T var1);

    protected abstract TtyConnector createTtyConnector(T var1);

    protected AnAction createCloseAction(Executor defaultExecutor, RunContentDescriptor myDescriptor) {
        return new CloseAction(defaultExecutor, myDescriptor, this.myProject);
    }

    protected void showConsole(Executor defaultExecutor, @NotNull RunContentDescriptor myDescriptor, Component toFocus) {
        ExecutionManager.getInstance((Project)this.myProject).getContentManager().showRunContent(defaultExecutor, myDescriptor);
        ToolWindow toolWindow = ToolWindowManager.getInstance((Project)this.myProject).getToolWindow(defaultExecutor.getId());
        if (toolWindow != null) {
            toolWindow.activate(() -> IdeFocusManager.getInstance((Project)this.myProject).requestFocus(toFocus, true));
        }
    }

    @NotNull
    protected Project getProject() {
        return this.myProject;
    }

    public abstract String runningTargetName();

    public void openSessionForFile(@NotNull JBTerminalWidget terminalWidget, @Nullable VirtualFile file) {
        this.openSessionInDirectory(terminalWidget, AbstractTerminalRunner.getParentDirectoryPath(file));
    }

    @Nullable
    private static String getParentDirectoryPath(@Nullable VirtualFile file) {
        VirtualFile dir = file != null && !file.isDirectory() ? file.getParent() : file;
        return dir != null ? dir.getPath() : null;
    }

    public void openSessionInDirectory(@NotNull JBTerminalWidget terminalWidget, @Nullable String directory) {
        ModalityState modalityState = ModalityState.stateForComponent((Component)terminalWidget.getComponent());
        Dimension size = terminalWidget.getTerminalPanel().getTerminalSizeFromComponent();
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                T process = this.createProcess(directory, terminalWidget.getCommandHistoryFilePath());
                TtyConnector connector = this.createTtyConnector(process);
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Initial resize to " + size);
                }
                if (size != null) {
                    try {
                        TerminalStarter.resizeTerminal((Terminal)terminalWidget.getTerminal(), (TtyConnector)connector, (Dimension)size, (RequestOrigin)RequestOrigin.User);
                    }
                    catch (Exception e) {
                        LOG.info("Cannot resize right after creation, process.isAlive: " + ((Process)process).isAlive(), (Throwable)e);
                    }
                }
                ApplicationManager.getApplication().invokeLater(() -> {
                    try {
                        terminalWidget.createTerminalSession(connector);
                    }
                    catch (Exception e) {
                        this.printError(terminalWidget, "Cannot create terminal session for " + this.runningTargetName(), e);
                    }
                    try {
                        terminalWidget.start();
                        terminalWidget.getComponent().revalidate();
                        terminalWidget.notifyStarted();
                    }
                    catch (RuntimeException e) {
                        this.printError(terminalWidget, "Cannot open " + this.runningTargetName(), e);
                    }
                }, modalityState);
            }
            catch (Exception e) {
                this.printError(terminalWidget, "Cannot open " + this.runningTargetName(), e);
            }
        });
    }

    private void printError(@NotNull JBTerminalWidget terminalWidget, @NotNull String errorMessage, @NotNull Exception e) {
        LOG.info(errorMessage, (Throwable)e);
        if (terminalWidget.getTerminal().getCursorX() > 1) {
            terminalWidget.getTerminal().newLine();
            terminalWidget.getTerminal().carriageReturn();
        }
        terminalWidget.getTerminal().writeCharacters(errorMessage);
        terminalWidget.getTerminal().newLine();
        terminalWidget.getTerminal().carriageReturn();
        terminalWidget.getTerminal().writeCharacters(e.getMessage());
        terminalWidget.getTerminal().newLine();
        terminalWidget.getTerminal().newLine();
        terminalWidget.getTerminal().carriageReturn();
        terminalWidget.getTerminal().writeCharacters("See your idea.log (Help | " + ShowLogAction.getActionName() + ") for the details.");
        AppUIUtil.invokeOnEdt(() -> {
            if (!Disposer.isDisposed((Disposable)terminalWidget)) {
                terminalWidget.getTerminalPanel().setCursorVisible(false);
            }
        }, (Condition)this.myProject.getDisposed());
    }
}

