/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.intellij.execution.TaskExecutor;
import com.intellij.execution.configuration.EnvironmentVariablesData;
import com.intellij.execution.process.ProcessAdapter;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessWaitFor;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PathMacroManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.ArrayUtil;
import com.intellij.util.EnvironmentUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.text.CaseInsensitiveStringHashingStrategy;
import com.jediterm.pty.PtyProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import com.pty4j.PtyProcess;
import gnu.trove.THashMap;
import gnu.trove.TObjectHashingStrategy;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.LocalTerminalCustomizer;
import org.jetbrains.plugins.terminal.TerminalOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalProjectOptionsProvider;
import org.jetbrains.plugins.terminal.TerminalSignalUtil;
import org.jetbrains.plugins.terminal.TerminalUsageTriggerCollector;

public class LocalTerminalDirectRunner
extends AbstractTerminalRunner<PtyProcess> {
    private static final Logger LOG = Logger.getInstance(LocalTerminalDirectRunner.class);
    private static final String JEDITERM_USER_RCFILE = "JEDITERM_USER_RCFILE";
    private static final String ZDOTDIR = "ZDOTDIR";
    private static final String XDG_CONFIG_HOME = "XDG_CONFIG_HOME";
    private static final String IJ_COMMAND_HISTORY_FILE_ENV = "__INTELLIJ_COMMAND_HISTFILE__";
    private static final String LOGIN_SHELL = "LOGIN_SHELL";
    private static final ImmutableList<String> LOGIN_CLI_OPTIONS = ImmutableList.of((Object)"--login", (Object)"-l");
    private static final String LOGIN_CLI_OPTION = (String)LOGIN_CLI_OPTIONS.get(0);
    private final Charset myDefaultCharset = CharsetToolkit.UTF8_CHARSET;

    public LocalTerminalDirectRunner(Project project) {
        super(project);
    }

    private static boolean hasLoginArgument(String name) {
        return name.equals("bash") || name.equals("sh") || name.equals("zsh");
    }

    private static String getShellName(@Nullable String path) {
        if (path == null) {
            return null;
        }
        return new File(path).getName();
    }

    @Nullable
    private static String findRCFile(@NotNull String shellName) {
        String rcfile = null;
        if ("bash".equals(shellName) || "sh".equals(shellName)) {
            rcfile = "jediterm-bash.in";
        } else if ("zsh".equals(shellName)) {
            rcfile = ".zshrc";
        } else if ("fish".equals(shellName)) {
            rcfile = "fish/config.fish";
        }
        if (rcfile != null) {
            try {
                return LocalTerminalDirectRunner.findAbsolutePath(rcfile);
            }
            catch (Exception e) {
                LOG.warn("Unable to find " + rcfile + " configuration file", (Throwable)e);
            }
        }
        return null;
    }

    @NotNull
    private static String findAbsolutePath(@NotNull String relativePath) throws IOException {
        File result;
        String jarPath = PathUtil.getJarPathForClass(LocalTerminalDirectRunner.class);
        if (jarPath.endsWith(".jar")) {
            File jarFile = new File(jarPath);
            if (!jarFile.isFile()) {
                throw new IOException("Broken installation: " + jarPath + " is not a file");
            }
            File pluginBaseDir = jarFile.getParentFile().getParentFile();
            result = new File(pluginBaseDir, relativePath);
        } else {
            String srcDir;
            if (ApplicationManager.getApplication().isInternal() && new File(srcDir = (jarPath = StringUtil.trimEnd((String)jarPath.replace('\\', '/'), (char)'/') + '/').replace("/out/classes/production/intellij.terminal/", "/community/plugins/terminal/resources/")).isDirectory()) {
                jarPath = srcDir;
            }
            result = new File(jarPath, relativePath);
        }
        if (!result.isFile()) {
            throw new IOException("Cannot find " + relativePath + ": " + result.getAbsolutePath() + " is not a file");
        }
        return result.getAbsolutePath();
    }

    @NotNull
    public static LocalTerminalDirectRunner createTerminalRunner(Project project) {
        return new LocalTerminalDirectRunner(project);
    }

    private Map<String, String> getTerminalEnvironment() {
        THashMap envs = new THashMap((TObjectHashingStrategy)(SystemInfo.isWindows ? CaseInsensitiveStringHashingStrategy.INSTANCE : ContainerUtil.canonicalStrategy()));
        EnvironmentVariablesData envData = TerminalOptionsProvider.getInstance().getEnvData();
        if (envData.isPassParentEnvs()) {
            envs.putAll(System.getenv());
        }
        if (!SystemInfo.isWindows) {
            envs.put("TERM", "xterm-256color");
        }
        envs.put("TERMINAL_EMULATOR", "JetBrains-JediTerm");
        if (SystemInfo.isMac) {
            EnvironmentUtil.setLocaleEnv((Map)envs, (Charset)this.myDefaultCharset);
        }
        PathMacroManager macroManager = PathMacroManager.getInstance((ComponentManager)this.myProject);
        for (Map.Entry env : envData.getEnvs().entrySet()) {
            envs.put(env.getKey(), macroManager.expandPath((String)env.getValue()));
        }
        return envs;
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory) throws ExecutionException {
        return this.createProcess(directory, null);
    }

    @Override
    protected PtyProcess createProcess(@Nullable String directory, @Nullable String commandHistoryFilePath) throws ExecutionException {
        Map<String, String> envs = this.getTerminalEnvironment();
        Object[] command = this.getCommand(envs);
        for (LocalTerminalCustomizer customizer : (LocalTerminalCustomizer[])LocalTerminalCustomizer.EP_NAME.getExtensions()) {
            try {
                command = customizer.customizeCommandAndEnvironment(this.myProject, (String[])command, envs);
            }
            catch (Exception e) {
                LOG.error("Exception during customization of the terminal session", (Throwable)e);
            }
        }
        if (commandHistoryFilePath != null) {
            envs.put(IJ_COMMAND_HISTORY_FILE_ENV, commandHistoryFilePath);
        }
        String workingDir = this.getWorkingDirectory(directory);
        TerminalUsageTriggerCollector.triggerLocalShellStarted(this.myProject, (String[])command);
        try {
            long startNano = System.nanoTime();
            Object[] finalCommand = command;
            PtyProcess process = (PtyProcess)TerminalSignalUtil.computeWithIgnoredSignalsResetToDefault(new int[]{UnixProcessManager.SIGINT, 3, TerminalSignalUtil.SIGPIPE}, () -> LocalTerminalDirectRunner.lambda$createProcess$0((String[])finalCommand, envs, workingDir));
            if (LOG.isDebugEnabled()) {
                LOG.debug("Started " + process.getClass().getName() + " from " + Arrays.toString(command) + " in " + workingDir + " (" + TimeoutUtil.getDurationMillis((long)startNano) + " ms)");
            }
            return process;
        }
        catch (IOException e) {
            throw new ExecutionException("Failed to start " + Arrays.toString(command) + " in " + workingDir, e);
        }
    }

    @Nullable
    private String getWorkingDirectory(@Nullable String directory) {
        if (directory != null) {
            return directory;
        }
        return TerminalProjectOptionsProvider.getInstance(this.myProject).getStartingDirectory();
    }

    @Override
    protected ProcessHandler createProcessHandler(PtyProcess process) {
        return new PtyProcessHandler(process, LocalTerminalDirectRunner.getShellPath());
    }

    @Override
    protected TtyConnector createTtyConnector(PtyProcess process) {
        return new PtyProcessTtyConnector(process, this.myDefaultCharset){

            protected void resizeImmediately() {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("resizeImmediately to " + this.getPendingTermSize());
                }
                super.resizeImmediately();
            }
        };
    }

    @Override
    public String runningTargetName() {
        return "Local Terminal";
    }

    @Override
    protected String getTerminalConnectionName(PtyProcess process) {
        return "Local Terminal";
    }

    public String[] getCommand(Map<String, String> envs) {
        String shellPath = LocalTerminalDirectRunner.getShellPath();
        return LocalTerminalDirectRunner.getCommand(shellPath, envs, TerminalOptionsProvider.getInstance().shellIntegration());
    }

    private static String getShellPath() {
        return TerminalOptionsProvider.getInstance().getShellPath();
    }

    @NotNull
    public static String[] getCommand(String shellPath, Map<String, String> envs, boolean shellIntegration) {
        if (SystemInfo.isUnix) {
            ArrayList command = Lists.newArrayList((Object[])shellPath.split(" "));
            String shellCommand = command.size() > 0 ? (String)command.get(0) : null;
            String shellName = LocalTerminalDirectRunner.getShellName(shellCommand);
            if (shellName != null) {
                command.remove(0);
                if (!LocalTerminalDirectRunner.loginOrInteractive(command)) {
                    if (LocalTerminalDirectRunner.hasLoginArgument(shellName) && SystemInfo.isMac) {
                        command.add(LOGIN_CLI_OPTION);
                    }
                    command.add("-i");
                }
                ArrayList result = Lists.newArrayList((Object[])new String[]{shellCommand});
                String rcFilePath = LocalTerminalDirectRunner.findRCFile(shellName);
                if (rcFilePath != null && shellIntegration) {
                    if (shellName.equals("bash") || SystemInfo.isMac && shellName.equals("sh")) {
                        LocalTerminalDirectRunner.addRcFileArgument(envs, command, result, rcFilePath, "--rcfile");
                        boolean loginShell = command.removeAll((Collection<?>)LOGIN_CLI_OPTIONS);
                        LocalTerminalDirectRunner.setLoginShellEnv(envs, loginShell);
                    } else if (shellName.equals("zsh")) {
                        String zdotdir = (String)EnvironmentUtil.getEnvironmentMap().get(ZDOTDIR);
                        if (StringUtil.isNotEmpty((String)zdotdir)) {
                            envs.put("_OLD_ZDOTDIR", zdotdir);
                            File zshRc = new File(FileUtil.expandUserHome((String)zdotdir), ".zshrc");
                            if (zshRc.exists()) {
                                envs.put(JEDITERM_USER_RCFILE, zshRc.getAbsolutePath());
                            }
                        }
                        envs.put(ZDOTDIR, new File(rcFilePath).getParent());
                    } else if (shellName.equals("fish")) {
                        String xdgConfig = (String)EnvironmentUtil.getEnvironmentMap().get(XDG_CONFIG_HOME);
                        if (StringUtil.isNotEmpty((String)xdgConfig)) {
                            File fishConfig = new File(new File(FileUtil.expandUserHome((String)xdgConfig), "fish"), "config.fish");
                            if (fishConfig.exists()) {
                                envs.put(JEDITERM_USER_RCFILE, fishConfig.getAbsolutePath());
                            }
                            envs.put("OLD_XDG_CONFIG_HOME", xdgConfig);
                        }
                        envs.put(XDG_CONFIG_HOME, new File(rcFilePath).getParentFile().getParent());
                    }
                }
                LocalTerminalDirectRunner.setLoginShellEnv(envs, LocalTerminalDirectRunner.isLogin(command));
                result.addAll(command);
                return ArrayUtil.toStringArray((Collection)result);
            }
            return ArrayUtil.toStringArray((Collection)command);
        }
        return new String[]{shellPath};
    }

    private static void setLoginShellEnv(@NotNull Map<String, String> envs, boolean loginShell) {
        if (loginShell) {
            envs.put(LOGIN_SHELL, "1");
        }
    }

    private static void addRcFileArgument(Map<String, String> envs, List<String> command, List<String> result, String rcFilePath, String rcfileOption) {
        result.add(rcfileOption);
        result.add(rcFilePath);
        int idx = command.indexOf(rcfileOption);
        if (idx >= 0) {
            command.remove(idx);
            if (idx < command.size()) {
                envs.put(JEDITERM_USER_RCFILE, FileUtil.expandUserHome((String)command.get(idx)));
                command.remove(idx);
            }
        }
    }

    private static boolean loginOrInteractive(List<String> command) {
        return command.contains("-i") || LocalTerminalDirectRunner.isLogin(command);
    }

    private static boolean isLogin(@NotNull List<String> command) {
        return command.stream().anyMatch(s -> LOGIN_CLI_OPTIONS.contains(s));
    }

    private static /* synthetic */ PtyProcess lambda$createProcess$0(String[] finalCommand, Map envs, String workingDir) throws IOException {
        return PtyProcess.exec((String[])finalCommand, (Map)envs, (String)workingDir);
    }

    private static class PtyProcessHandler
    extends ProcessHandler
    implements TaskExecutor {
        private final PtyProcess myProcess;
        private final ProcessWaitFor myWaitFor;

        PtyProcessHandler(PtyProcess process, @NotNull String presentableName) {
            this.myProcess = process;
            this.myWaitFor = new ProcessWaitFor((Process)process, (TaskExecutor)this, presentableName);
        }

        public void startNotify() {
            this.addProcessListener((ProcessListener)new ProcessAdapter(){

                public void startNotified(@NotNull ProcessEvent event) {
                    try {
                        myWaitFor.setTerminationCallback(integer -> this.notifyProcessTerminated(integer));
                    }
                    finally {
                        this.removeProcessListener((ProcessListener)this);
                    }
                }
            });
            super.startNotify();
        }

        protected void destroyProcessImpl() {
            this.myProcess.destroy();
        }

        protected void detachProcessImpl() {
            this.destroyProcessImpl();
        }

        public boolean detachIsDefault() {
            return false;
        }

        public boolean isSilentlyDestroyOnClose() {
            return true;
        }

        @Nullable
        public OutputStream getProcessInput() {
            return this.myProcess.getOutputStream();
        }

        @NotNull
        public Future<?> executeTask(@NotNull Runnable task) {
            return AppExecutorUtil.getAppExecutorService().submit(task);
        }
    }
}

