/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.process.UnixProcessManager;
import com.intellij.jna.JnaLoader;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.util.containers.ContainerUtil;
import com.sun.jna.Library;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.Pointer;
import java.util.ArrayList;
import java.util.Iterator;
import org.jetbrains.annotations.NotNull;

public class TerminalSignalUtil {
    public static final int SIGQUIT = 3;
    public static final int SIGPIPE = UnixProcessManager.getSignalNumber((String)"PIPE");
    private static final Logger LOG = Logger.getInstance(TerminalSignalUtil.class);

    private TerminalSignalUtil() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T, E extends Exception> T computeWithIgnoredSignalsResetToDefault(int[] signals, @NotNull ThrowableComputable<T, E> callback) throws E {
        if (!SystemInfo.isUnix || !JnaLoader.isLoaded()) {
            return (T)callback.compute();
        }
        ArrayList ignored = ContainerUtil.newArrayList();
        LibC lib = null;
        try {
            lib = (LibC)Native.loadLibrary((String)"c", LibC.class);
            for (int signal : signals) {
                long handler;
                Memory oldAction = TerminalSignalUtil.allocSigactionStructMemory();
                if (signal < 0 || lib.sigaction(signal, null, (Pointer)oldAction) != 0) continue;
                long l = handler = Native.POINTER_SIZE == 8 ? oldAction.getLong(0L) : (long)oldAction.getInt(0L);
                if (handler != 1L || !TerminalSignalUtil.setSignalHandler(lib, signal, 0L)) continue;
                ignored.add(signal);
            }
        }
        catch (Throwable t) {
            LOG.warn("Cannot set ignored signals to default", t);
        }
        try {
            Object object = callback.compute();
            return (T)object;
        }
        catch (Throwable e) {
            Throwable exception = e;
            return (T)exception;
        }
        finally {
            if (lib != null) {
                Iterator iterator = ignored.iterator();
                while (iterator.hasNext()) {
                    int signal;
                    signal = (Integer)iterator.next();
                    try {
                        TerminalSignalUtil.setSignalHandler(lib, signal, 1L);
                    }
                    catch (Throwable t) {
                        LOG.warn("Cannot restore ignored handler for signal " + signal, t);
                    }
                }
            }
        }
    }

    @NotNull
    private static Memory allocSigactionStructMemory() {
        return new Memory(1024L);
    }

    private static boolean setSignalHandler(@NotNull LibC lib, int signal, long SIG_DFL_or_IGN) {
        boolean ok;
        Memory action = TerminalSignalUtil.allocSigactionStructMemory();
        if (Native.POINTER_SIZE == 8) {
            action.setLong(0L, SIG_DFL_or_IGN);
        } else {
            action.setInt(0L, (int)SIG_DFL_or_IGN);
        }
        boolean bl = ok = lib.sigaction(signal, (Pointer)action, null) == 0;
        if (!ok) {
            LOG.warn("Cannot set signal disposition for signal " + signal + " to " + (SIG_DFL_or_IGN == 1L ? "ignored" : "default"));
        }
        return ok;
    }

    private static interface LibC
    extends Library {
        public static final long SIG_DFL = 0L;
        public static final long SIG_IGN = 1L;

        public int sigaction(int var1, Pointer var2, Pointer var3);
    }
}

