/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.TerminateRemoteProcessDialog;
import com.intellij.execution.process.NopProcessHandler;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.ui.BaseContentCloseListener;
import com.intellij.execution.ui.RunContentManagerImpl;
import com.intellij.ide.GeneralSettings;
import com.intellij.openapi.project.Project;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.jediterm.terminal.ProcessTtyConnector;
import com.jediterm.terminal.TtyConnector;
import kotlin.Metadata;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.plugins.terminal.TerminalTabCloseListenerKt;
import org.jetbrains.plugins.terminal.TerminalUtil;
import org.jetbrains.plugins.terminal.TerminalView;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0004\u001a\u00020\u0005H\u0016J\u0018\u0010\r\u001a\u00020\f2\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\fH\u0014J\u0010\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0002\u001a\u00020\u0003H\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0011"}, d2={"Lorg/jetbrains/plugins/terminal/TerminalTabCloseListener;", "Lcom/intellij/execution/ui/BaseContentCloseListener;", "content", "Lcom/intellij/ui/content/Content;", "project", "Lcom/intellij/openapi/project/Project;", "(Lcom/intellij/ui/content/Content;Lcom/intellij/openapi/project/Project;)V", "getContent", "()Lcom/intellij/ui/content/Content;", "getProject", "()Lcom/intellij/openapi/project/Project;", "canClose", "", "closeQuery", "projectClosing", "disposeContent", "", "intellij.terminal"})
public final class TerminalTabCloseListener
extends BaseContentCloseListener {
    @NotNull
    private final Content content;
    @NotNull
    private final Project project;

    protected void disposeContent(@NotNull Content content) {
    }

    protected boolean closeQuery(@NotNull Content content, boolean projectClosing) {
        NopProcessHandler nopProcessHandler;
        if (projectClosing) {
            return true;
        }
        JBTerminalWidget widget = TerminalView.getWidgetByContent(content);
        if (widget == null || !widget.isSessionRunning()) {
            return true;
        }
        TtyConnector ttyConnector = widget.getTtyConnector();
        if (!(ttyConnector instanceof ProcessTtyConnector)) {
            ttyConnector = null;
        }
        ProcessTtyConnector connector = (ProcessTtyConnector)ttyConnector;
        try {
            if (connector != null && !TerminalUtil.hasRunningCommands(connector)) {
                return true;
            }
        }
        catch (Exception e) {
            TerminalTabCloseListenerKt.access$getLOG$p().error((Throwable)e);
        }
        NopProcessHandler $receiver = nopProcessHandler = new NopProcessHandler();
        boolean bl = false;
        $receiver.startNotify();
        NopProcessHandler proxy = nopProcessHandler;
        proxy.putUserData(RunContentManagerImpl.ALWAYS_USE_DEFAULT_STOPPING_BEHAVIOUR_KEY, (Object)true);
        GeneralSettings.ProcessCloseConfirmation result = TerminateRemoteProcessDialog.show((Project)this.project, (String)("Terminal " + content.getDisplayName()), (ProcessHandler)((ProcessHandler)proxy));
        return result != null;
    }

    public boolean canClose(@NotNull Project project) {
        return project == this.project && this.closeQuery(this.content, true);
    }

    @NotNull
    public final Content getContent() {
        return this.content;
    }

    @NotNull
    public final Project getProject() {
        return this.project;
    }

    public TerminalTabCloseListener(@NotNull Content content, @NotNull Project project) {
        super(content, project);
        this.content = content;
        this.project = project;
    }
}

