/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal;

import com.intellij.execution.process.OSProcessUtil;
import com.intellij.execution.process.UnixProcessManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.remote.RemoteSshProcess;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.util.Processor;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.MultiMap;
import com.intellij.util.execution.ParametersListUtil;
import com.jediterm.terminal.ProcessTtyConnector;
import com.pty4j.unix.UnixPtyProcess;
import com.pty4j.windows.WinPtyProcess;
import java.io.IOException;
import java.util.List;
import java.util.StringTokenizer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.AbstractTerminalRunner;
import org.jetbrains.plugins.terminal.TerminalTabState;
import org.jvnet.winp.WinProcess;
import org.jvnet.winp.WinpException;

public class TerminalUtil {
    private static final Logger LOG = Logger.getInstance(TerminalUtil.class);

    private TerminalUtil() {
    }

    @NotNull
    public static JBTerminalWidget createTerminal(@NotNull AbstractTerminalRunner terminalRunner, @Nullable TerminalTabState tabState, @Nullable Disposable parentDisposable) {
        VirtualFile currentWorkingDir = TerminalUtil.getCurrentWorkingDir(tabState);
        if (parentDisposable == null) {
            parentDisposable = Disposer.newDisposable();
        }
        return terminalRunner.createTerminalWidget(parentDisposable, currentWorkingDir);
    }

    @Nullable
    private static VirtualFile getCurrentWorkingDir(@Nullable TerminalTabState tabState) {
        String dir = tabState != null ? tabState.myWorkingDirectory : null;
        VirtualFile result = null;
        if (dir != null) {
            result = LocalFileSystem.getInstance().findFileByPath(dir);
        }
        return result;
    }

    public static boolean hasRunningCommands(@NotNull ProcessTtyConnector connector) throws IllegalStateException {
        Process process = connector.getProcess();
        if (!process.isAlive()) {
            return false;
        }
        if (process instanceof RemoteSshProcess) {
            return true;
        }
        if (SystemInfo.isUnix && process instanceof UnixPtyProcess) {
            int shellPid = OSProcessUtil.getProcessID((Process)process);
            final MultiMap pidToChildPidsMap = MultiMap.create();
            UnixProcessManager.processPSOutput((String[])UnixProcessManager.getPSCmd((boolean)false, (boolean)false), (Processor)new Processor<String>(){

                public boolean process(String s) {
                    StringTokenizer st = new StringTokenizer(s, " ");
                    int parentPid = Integer.parseInt(st.nextToken());
                    int pid = Integer.parseInt(st.nextToken());
                    pidToChildPidsMap.putValue((Object)parentPid, (Object)pid);
                    return false;
                }
            });
            return !pidToChildPidsMap.get((Object)shellPid).isEmpty();
        }
        if (SystemInfo.isWindows && process instanceof WinPtyProcess) {
            WinPtyProcess winPty = (WinPtyProcess)process;
            try {
                String executable = FileUtil.toSystemIndependentName((String)StringUtil.notNullize((String)TerminalUtil.getExecutable(winPty.getChildProcessId())));
                int consoleProcessCount = winPty.getConsoleProcessCount();
                if (executable.endsWith("/Git/bin/bash.exe")) {
                    return consoleProcessCount > 3;
                }
                return consoleProcessCount > 2;
            }
            catch (IOException e) {
                throw new IllegalStateException(e);
            }
        }
        throw new IllegalStateException("Cannot determine if there are running processes: " + SystemInfo.OS_NAME + ", " + process.getClass().getName());
    }

    @Nullable
    private static String getExecutable(int pid) {
        String commandLine;
        WinProcess winProcess = new WinProcess(pid);
        try {
            commandLine = winProcess.getCommandLine();
        }
        catch (WinpException e) {
            LOG.error((Throwable)e);
            return null;
        }
        return (String)ContainerUtil.getFirstItem((List)ParametersListUtil.parse((String)commandLine));
    }
}

