/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.arrangement;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.terminal.JBTerminalWidget;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentManagerAdapter;
import com.intellij.ui.content.ContentManagerEvent;
import com.intellij.ui.content.ContentManagerListener;
import com.intellij.util.Alarm;
import com.intellij.util.ObjectUtils;
import com.intellij.util.TimeoutUtil;
import com.intellij.util.containers.ContainerUtil;
import com.jediterm.terminal.ProcessTtyConnector;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.TerminalView;
import org.jetbrains.plugins.terminal.arrangement.ProcessInfoUtil;
import org.jetbrains.plugins.terminal.arrangement.TerminalArrangementManager;

public class TerminalWorkingDirectoryManager {
    private static final Logger LOG = Logger.getInstance(TerminalWorkingDirectoryManager.class);
    private static final int MERGE_WAIT_MILLIS = 500;
    private static final int FETCH_WAIT_MILLIS = 2000;
    private static final Key<String> INITIAL_CWD_KEY = Key.create((String)"initial cwd");
    private final Map<Content, Data> myDataByContentMap = ContainerUtil.newHashMap();

    TerminalWorkingDirectoryManager() {
    }

    @Nullable
    String getWorkingDirectory(@NotNull Content content) {
        Data data = this.getData(content);
        return data != null ? data.myWorkingDirectory : null;
    }

    void init(@NotNull ToolWindow terminalToolWindow) {
        ContentManager contentManager = terminalToolWindow.getContentManager();
        for (Content content : contentManager.getContents()) {
            this.watchTab(content);
        }
        contentManager.addContentManagerListener((ContentManagerListener)new ContentManagerAdapter(){

            public void contentAdded(@NotNull ContentManagerEvent event) {
                TerminalWorkingDirectoryManager.this.watchTab(event.getContent());
            }

            public void contentRemoved(@NotNull ContentManagerEvent event) {
                TerminalWorkingDirectoryManager.this.unwatchTab(event.getContent());
            }
        });
    }

    private void watchTab(final @NotNull Content content) {
        final Alarm alarm = new Alarm(Alarm.ThreadToUse.POOLED_THREAD, (Disposable)content);
        final AtomicReference<Data> dataRef = new AtomicReference<Data>();
        final KeyAdapter listener = new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10 && TerminalArrangementManager.isAvailable()) {
                    alarm.cancelAllRequests();
                    if (!alarm.isDisposed()) {
                        alarm.addRequest(() -> TerminalWorkingDirectoryManager.updateWorkingDirectory(content, (Data)dataRef.get()), 500);
                    }
                }
            }
        };
        Data data = new Data(listener, content.getDisplayName());
        data.myWorkingDirectory = (String)content.getUserData(TerminalWorkingDirectoryManager.INITIAL_CWD_KEY);
        content.putUserData(INITIAL_CWD_KEY, null);
        dataRef.set(data);
        final JBTerminalWidget widget = Objects.requireNonNull(TerminalView.getWidgetByContent(content));
        widget.getTerminalPanel().addCustomKeyListener((KeyListener)listener);
        Disposer.register((Disposable)content, (Disposable)new Disposable(){

            public void dispose() {
                widget.getTerminalPanel().removeCustomKeyListener((KeyListener)listener);
            }
        });
        this.myDataByContentMap.put(content, data);
    }

    private static void updateWorkingDirectory(@NotNull Content content, @NotNull Data data) {
        JBTerminalWidget widget = TerminalView.getWidgetByContent(content);
        if (widget != null) {
            data.myWorkingDirectory = TerminalWorkingDirectoryManager.getWorkingDirectory(widget, data.myContentName);
        }
    }

    @Nullable
    public static String getWorkingDirectory(@NotNull JBTerminalWidget widget, @Nullable String name) {
        ProcessTtyConnector connector = (ProcessTtyConnector)ObjectUtils.tryCast((Object)widget.getTtyConnector(), ProcessTtyConnector.class);
        if (connector == null) {
            return null;
        }
        try {
            long startNano = System.nanoTime();
            Future<String> cwd = ProcessInfoUtil.getCurrentWorkingDirectory(connector.getProcess());
            String result = cwd.get(2000L, TimeUnit.MILLISECONDS);
            if (LOG.isDebugEnabled()) {
                LOG.debug("Cwd (" + result + ") fetched in " + TimeoutUtil.getDurationMillis((long)startNano) + " ms");
            }
            return result;
        }
        catch (InterruptedException startNano) {
        }
        catch (ExecutionException e) {
            String message = "Failed to fetch cwd for " + name;
            if (LOG.isDebugEnabled()) {
                LOG.warn(message, (Throwable)e);
            } else {
                LOG.warn(message + ": " + e.getCause().getMessage());
            }
        }
        catch (TimeoutException e) {
            LOG.warn("Timeout fetching cwd for " + name, (Throwable)e);
        }
        return null;
    }

    private void unwatchTab(@NotNull Content content) {
        Data data = this.getData(content);
        if (data != null) {
            this.myDataByContentMap.remove(content);
            JBTerminalWidget widget = TerminalView.getWidgetByContent(content);
            if (widget != null) {
                widget.getTerminalPanel().removeCustomKeyListener(data.myKeyListener);
            }
        }
    }

    @Nullable
    private Data getData(@NotNull Content content) {
        Data data = this.myDataByContentMap.get(content);
        if (data == null) {
            LOG.error("No associated data");
        }
        return data;
    }

    public static void setInitialWorkingDirectory(@NotNull Content content, @Nullable VirtualFile fileOrDir) {
        VirtualFile dir = fileOrDir != null && !fileOrDir.isDirectory() ? fileOrDir.getParent() : fileOrDir;
        content.putUserData(INITIAL_CWD_KEY, dir != null ? FileUtil.toSystemDependentName((String)dir.getPath()) : null);
    }

    private static class Data {
        private final KeyListener myKeyListener;
        private final String myContentName;
        private volatile String myWorkingDirectory;

        private Data(@NotNull KeyListener keyListener, @Nullable String contentName) {
            this.myKeyListener = keyListener;
            this.myContentName = contentName;
        }

        public String toString() {
            return this.myContentName + ", cwd: " + this.myWorkingDirectory;
        }
    }
}

