/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.plugins.terminal.vfs;

import com.google.common.collect.Lists;
import com.intellij.codeHighlighting.BackgroundEditorHighlighter;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.fileEditor.FileEditor;
import com.intellij.openapi.fileEditor.FileEditorLocation;
import com.intellij.openapi.fileEditor.FileEditorState;
import com.intellij.openapi.fileEditor.ex.FileEditorManagerEx;
import com.intellij.openapi.fileEditor.impl.FileEditorManagerImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ConcurrencyUtil;
import com.jediterm.terminal.TtyConnectorWaitFor;
import com.jediterm.terminal.ui.TerminalAction;
import com.jediterm.terminal.ui.TerminalActionProvider;
import com.jediterm.terminal.ui.TerminalActionProviderBase;
import com.jediterm.terminal.ui.settings.TabbedSettingsProvider;
import java.beans.PropertyChangeListener;
import java.util.List;
import java.util.concurrent.ExecutorService;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.plugins.terminal.vfs.TerminalSessionVirtualFileImpl;

public class TerminalSessionEditor
extends UserDataHolderBase
implements FileEditor {
    private final Project myProject;
    private final TerminalSessionVirtualFileImpl myFile;
    private final TtyConnectorWaitFor myWaitFor;

    public TerminalSessionEditor(Project project, @NotNull TerminalSessionVirtualFileImpl terminalFile) {
        this.myProject = project;
        this.myFile = terminalFile;
        final TabbedSettingsProvider settings = this.myFile.getSettingsProvider();
        this.myFile.getTerminalWidget().setNextProvider((TerminalActionProvider)new TerminalActionProviderBase(){

            public List<TerminalAction> getActions() {
                return Lists.newArrayList((Object[])new TerminalAction[]{new TerminalAction("Close Session", settings.getCloseSessionKeyStrokes(), input -> {
                    TerminalSessionEditor.this.handleCloseSession();
                    return true;
                }).withMnemonicKey(Integer.valueOf(83))});
            }
        });
        this.myWaitFor = new TtyConnectorWaitFor(this.myFile.getTerminalWidget().getTtyConnector(), (ExecutorService)ConcurrencyUtil.newSingleThreadExecutor((String)"Terminal session"));
        this.myWaitFor.setTerminationCallback(integer -> {
            ApplicationManager.getApplication().invokeLater(() -> FileEditorManagerEx.getInstanceEx((Project)this.myProject).closeFile((VirtualFile)this.myFile));
            return true;
        });
    }

    private void handleCloseSession() {
        this.myFile.getTerminalWidget().close();
    }

    @NotNull
    public JComponent getComponent() {
        return this.myFile.getTerminalWidget();
    }

    @Nullable
    public JComponent getPreferredFocusedComponent() {
        return this.myFile.getTerminalWidget();
    }

    @NotNull
    public String getName() {
        return this.myFile.getName();
    }

    public void setState(@NotNull FileEditorState state) {
    }

    public boolean isModified() {
        return false;
    }

    public boolean isValid() {
        return true;
    }

    public void selectNotify() {
    }

    public void deselectNotify() {
    }

    public void addPropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    public void removePropertyChangeListener(@NotNull PropertyChangeListener listener) {
    }

    @Nullable
    public BackgroundEditorHighlighter getBackgroundHighlighter() {
        return null;
    }

    @Nullable
    public FileEditorLocation getCurrentLocation() {
        return null;
    }

    public void dispose() {
        Boolean closingToReopen = (Boolean)this.myFile.getUserData(FileEditorManagerImpl.CLOSING_TO_REOPEN);
        this.myWaitFor.detach();
        if (closingToReopen == null || !closingToReopen.booleanValue()) {
            this.myFile.getTerminalWidget().close();
        }
    }
}

