/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathMacros;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.ServiceKt;
import com.intellij.openapi.components.impl.stores.IComponentStore;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.ProjectJdkTable;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.impl.JavaAwareProjectJdkTableImpl;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.testFramework.EdtTestUtil;
import com.intellij.util.SmartList;
import org.jetbrains.annotations.NotNull;

public class CompilerTestUtil {
    private CompilerTestUtil() {
    }

    public static void setupJavacForTests(Project project) {
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance(project);
        compilerConfiguration.setDefaultCompiler((BackendCompiler)compilerConfiguration.getJavacCompiler());
    }

    public static void saveApplicationSettings() {
        IComponentStore store = CompilerTestUtil.getApplicationStore();
        store.saveComponent((PersistentStateComponent)ProjectJdkTable.getInstance());
        store.saveComponent((PersistentStateComponent)FileTypeManager.getInstance());
        store.saveComponent((PersistentStateComponent)PathMacros.getInstance());
    }

    @NotNull
    public static IComponentStore getApplicationStore() {
        return ServiceKt.getStateStore((ComponentManager)ApplicationManager.getApplication());
    }

    public static void saveApplicationComponent(@NotNull PersistentStateComponent<?> appComponent) {
        EdtTestUtil.runInEdtAndWait(() -> CompilerTestUtil.getApplicationStore().saveComponent(appComponent));
    }

    public static void enableExternalCompiler() {
        JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
        WriteAction.runAndWait(() -> table.addJdk(table.getInternalJdk()));
    }

    public static void disableExternalCompiler(@NotNull Project project) {
        EdtTestUtil.runInEdtAndWait(() -> {
            JavaAwareProjectJdkTableImpl table = JavaAwareProjectJdkTableImpl.getInstanceEx();
            ApplicationManager.getApplication().runWriteAction(() -> {
                Sdk internalJdk = table.getInternalJdk();
                SmartList modulesToRestore = new SmartList();
                for (Module module : ModuleManager.getInstance((Project)project).getModules()) {
                    Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
                    if (sdk == null || !sdk.equals(internalJdk)) continue;
                    modulesToRestore.add(module);
                }
                for (Module module : modulesToRestore) {
                    ModuleRootModificationUtil.setModuleSdk((Module)module, (Sdk)internalJdk);
                }
                table.removeJdk(internalJdk);
                BuildManager.getInstance().clearState(project);
            });
        });
    }
}

