/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.FileObject;
import javax.tools.ForwardingJavaFileManager;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import javax.tools.StandardJavaFileManager;
import javax.tools.StandardLocation;
import javax.tools.ToolProvider;
import org.intellij.lang.annotations.Language;

public class JavaInMemoryCompiler {
    private final JavaMemFileManager myFileManager = new JavaMemFileManager();
    private final JavaCompiler myCompiler = ToolProvider.getSystemJavaCompiler();

    public JavaInMemoryCompiler(File ... classpath) {
        try {
            this.myFileManager.setLocation(StandardLocation.CLASS_PATH, Arrays.asList(classpath));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public Map<String, byte[]> compile(String className, @Language(value="JAVA") String code) {
        DiagnosticCollector diagnostics = new DiagnosticCollector();
        List<JavaSourceFromString> compilationUnits = Collections.singletonList(new JavaSourceFromString(className, code));
        OutputStreamWriter out = new OutputStreamWriter(System.err);
        List<String> options = Arrays.asList("-g");
        Boolean success = this.myCompiler.getTask(out, this.myFileManager, diagnostics, options, null, compilationUnits).call();
        if (!success.booleanValue()) {
            StringWriter writer = new StringWriter();
            for (Diagnostic diagnostic : diagnostics.getDiagnostics()) {
                writer.write(diagnostic.getMessage(Locale.ENGLISH));
                writer.write(" on line " + diagnostic.getLineNumber());
                writer.write("\n");
            }
            throw new RuntimeException(writer.toString());
        }
        List<InMemoryClassFile> classFiles = this.myFileManager.getClassFiles();
        HashMap<String, byte[]> result = new HashMap<String, byte[]>(2);
        for (InMemoryClassFile classFile : classFiles) {
            result.put(classFile.getClassName(), classFile.getBytes());
        }
        return result;
    }

    public static class JavaMemFileManager
    extends ForwardingJavaFileManager<StandardJavaFileManager> {
        private final List<InMemoryClassFile> myClassFiles = new ArrayList<InMemoryClassFile>(2);

        public JavaMemFileManager() {
            super(ToolProvider.getSystemJavaCompiler().getStandardFileManager(null, null, null));
        }

        @Override
        public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
            if (StandardLocation.CLASS_OUTPUT == location && JavaFileObject.Kind.CLASS == kind) {
                InMemoryClassFile file = new InMemoryClassFile(className);
                this.myClassFiles.add(file);
                return file;
            }
            return super.getJavaFileForOutput(location, className, kind, sibling);
        }

        public void setLocation(JavaFileManager.Location location, Iterable<? extends File> path) throws IOException {
            ((StandardJavaFileManager)this.fileManager).setLocation(location, path);
        }

        public List<InMemoryClassFile> getClassFiles() {
            return this.myClassFiles;
        }

        @Override
        public ClassLoader getClassLoader(JavaFileManager.Location location) {
            return null;
        }
    }

    public static class InMemoryClassFile
    extends SimpleJavaFileObject {
        private final String myClassName;
        ByteArrayOutputStream myOutputStream = new ByteArrayOutputStream();

        public InMemoryClassFile(String className) {
            super(URI.create("class:///" + className.replace('.', '/') + ".class"), JavaFileObject.Kind.CLASS);
            this.myClassName = className;
        }

        public String getClassName() {
            return this.myClassName;
        }

        public byte[] getBytes() {
            return this.myOutputStream.toByteArray();
        }

        @Override
        public OutputStream openOutputStream() {
            this.myOutputStream.reset();
            return this.myOutputStream;
        }
    }

    public static class JavaSourceFromString
    extends SimpleJavaFileObject {
        final String myCode;

        JavaSourceFromString(String className, String code) {
            super(URI.create("string:///" + className.replace('.', '/') + JavaFileObject.Kind.SOURCE.extension), JavaFileObject.Kind.SOURCE);
            this.myCode = code;
        }

        @Override
        public CharSequence getCharContent(boolean ignoreEncodingErrors) {
            return this.myCode;
        }
    }
}

