/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.Location;
import com.intellij.execution.PsiLocation;
import com.intellij.execution.configurations.JavaRunConfigurationModule;
import com.intellij.execution.util.ExecutionErrorDialog;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.io.FileUtilRt;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassOwner;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.PsiTreeUtil;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaExecutionUtil {
    private static final Logger LOG = Logger.getInstance(JavaExecutionUtil.class);

    private JavaExecutionUtil() {
    }

    public static Module findModule(Module contextModule, Set<String> patterns, Project project, Condition<? super PsiClass> isTestMethod) {
        Module nextModule;
        HashSet<Module> modules = new HashSet<Module>();
        for (String className : patterns) {
            PsiClass psiClass = JavaExecutionUtil.findMainClass(project, className.contains(",") ? className.substring(0, className.indexOf(44)) : className, GlobalSearchScope.allScope((Project)project));
            if (psiClass == null || !isTestMethod.value((Object)psiClass)) continue;
            modules.add(ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass));
        }
        if (modules.size() == 1 && (nextModule = (Module)modules.iterator().next()) != null) {
            return nextModule;
        }
        if (contextModule != null && modules.size() > 1) {
            HashSet moduleDependencies = new HashSet();
            ModuleUtilCore.getDependencies((Module)contextModule, moduleDependencies);
            if (moduleDependencies.containsAll(modules)) {
                return contextModule;
            }
            return null;
        }
        return contextModule;
    }

    @Nullable
    public static String getRuntimeQualifiedName(@NotNull PsiClass aClass) {
        return ClassUtil.getJVMClassName((PsiClass)aClass);
    }

    @Nullable
    public static String getPresentableClassName(@Nullable String rtClassName) {
        return JavaExecutionUtil.getPresentableClassName(rtClassName, null);
    }

    @Deprecated
    @Nullable
    public static String getPresentableClassName(@Nullable String rtClassName, JavaRunConfigurationModule configurationModule) {
        if (StringUtil.isEmpty((String)rtClassName)) {
            return null;
        }
        int lastDot = rtClassName.lastIndexOf(46);
        return lastDot == -1 || lastDot == rtClassName.length() - 1 ? rtClassName : rtClassName.substring(lastDot + 1);
    }

    public static Module findModule(@NotNull PsiClass psiClass) {
        return ModuleUtilCore.findModuleForPsiElement((PsiElement)psiClass.getContainingFile());
    }

    @Nullable
    public static PsiClass findMainClass(Module module, String mainClassName) {
        return JavaExecutionUtil.findMainClass(module.getProject(), mainClassName, module.getModuleRuntimeScope(true));
    }

    @Nullable
    public static PsiClass findMainClass(Project project, String mainClassName, GlobalSearchScope scope) {
        if (project.isDefault() || DumbService.isDumb((Project)project) && !DumbService.getInstance((Project)project).isAlternativeResolveEnabled()) {
            return null;
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        String shortName = StringUtil.getShortName((String)mainClassName);
        String packageName = StringUtil.getPackageName((String)mainClassName);
        JavaPsiFacade psiFacade = JavaPsiFacade.getInstance((Project)psiManager.getProject());
        PsiClass psiClass = psiFacade.findClass(StringUtil.getQualifiedName((String)packageName, (String)shortName.replace('$', '.')), scope);
        return psiClass == null ? psiFacade.findClass(mainClassName, scope) : psiClass;
    }

    public static boolean isNewName(String name) {
        return name == null || name.startsWith(ExecutionBundle.message((String)"run.configuration.unnamed.name.prefix", (Object[])new Object[0]));
    }

    public static Location stepIntoSingleClass(@NotNull Location location) {
        PsiClassOwner psiFile;
        PsiClass[] classes;
        PsiElement element = location.getPsiElement();
        if (!(element instanceof PsiClassOwner)) {
            if (PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class) != null) {
                return location;
            }
            if ((element = PsiTreeUtil.getParentOfType((PsiElement)element, PsiClassOwner.class)) == null) {
                return location;
            }
        }
        if ((classes = (psiFile = (PsiClassOwner)element).getClasses()).length != 1) {
            return location;
        }
        if (classes[0].getTextRange() == null) {
            return location;
        }
        return PsiLocation.fromPsiElement((PsiElement)classes[0]);
    }

    public static String getShortClassName(@Nullable String fqName) {
        return fqName == null ? "" : StringUtil.getShortName((String)fqName);
    }

    public static void showExecutionErrorMessage(ExecutionException e, String title, Project project) {
        ExecutionErrorDialog.show((ExecutionException)e, (String)title, (Project)project);
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath, @NotNull String copyDirName, @Nullable String agentPathPropertyKey) {
        return JavaExecutionUtil.handleSpacesInAgentPath(agentPath, copyDirName, agentPathPropertyKey, null);
    }

    @Nullable
    public static String handleSpacesInAgentPath(@NotNull String agentPath, @NotNull String copyDirName, @Nullable String agentPathPropertyKey, @Nullable FileFilter fileFilter) {
        String agentName = new File(agentPath).getName();
        String containingDir = JavaExecutionUtil.handleSpacesInContainingDir(agentPath, copyDirName, agentPathPropertyKey, fileFilter);
        return containingDir == null ? null : FileUtil.join((String[])new String[]{containingDir, agentName});
    }

    @Nullable
    private static String handleSpacesInContainingDir(@NotNull String agentPath, @NotNull String copyDirName, @Nullable String agentPathPropertyKey, @Nullable FileFilter fileFilter) {
        String userDefined = agentPathPropertyKey == null ? null : System.getProperty(agentPathPropertyKey);
        String agentContainingDir = userDefined != null && new File(userDefined).exists() ? userDefined : new File(agentPath).getParent();
        if (agentContainingDir.contains(" ")) {
            String res = JavaExecutionUtil.tryCopy(agentContainingDir, new File(PathManager.getSystemPath(), copyDirName), fileFilter);
            if (res == null) {
                try {
                    res = JavaExecutionUtil.tryCopy(agentContainingDir, FileUtil.createTempDirectory((String)copyDirName, (String)"jars"), fileFilter);
                    if (res == null) {
                        String message = "agent not used since the agent path contains spaces: " + agentContainingDir;
                        if (agentPathPropertyKey != null) {
                            message = message + "\nOne can move the agent libraries to a directory with no spaces in path and specify its path in idea.properties as " + agentPathPropertyKey + "=<path>";
                        }
                        LOG.info(message);
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            return res;
        }
        return agentContainingDir;
    }

    @Nullable
    private static String tryCopy(@NotNull String agentDir, @NotNull File targetDir, @Nullable FileFilter fileFilter) {
        if (targetDir.getAbsolutePath().contains(" ")) {
            return null;
        }
        try {
            LOG.info("Agent jars were copied to " + targetDir.getPath());
            if (fileFilter == null) {
                fileFilter = pathname -> FileUtilRt.extensionEquals((String)pathname.getPath(), (String)"jar");
            }
            FileUtil.copyDir((File)new File(agentDir), (File)targetDir, (FileFilter)fileFilter);
            return targetDir.getPath();
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }
}

