/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import java.io.File;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.jps.model.java.compiler.AnnotationProcessingConfiguration;

public class CompilerPaths {
    private static final Logger LOG = Logger.getInstance(CompilerPaths.class);

    public static File getGeneratedDataDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".generated");
    }

    public static File getCacheStoreDirectory(Project project) {
        return new File(CompilerPaths.getCompilerSystemDirectory(project), ".caches");
    }

    @NotNull
    public static File getCompilerSystemDirectory(@NotNull Project project) {
        return ProjectUtil.getProjectCachePath((Project)project, (String)"compiler").toFile();
    }

    @Nullable
    public static VirtualFile getModuleOutputDirectory(@NotNull Module module, boolean forTestClasses) {
        VirtualFile path;
        CompilerModuleExtension compilerModuleExtension = CompilerModuleExtension.getInstance((Module)module);
        if (compilerModuleExtension == null) {
            return null;
        }
        VirtualFile outPath = forTestClasses ? ((path = compilerModuleExtension.getCompilerOutputPathForTests()) != null ? path : compilerModuleExtension.getCompilerOutputPath()) : compilerModuleExtension.getCompilerOutputPath();
        if (outPath == null) {
            return null;
        }
        if (!outPath.isValid()) {
            LOG.info("Requested output path for module " + module.getName() + " is not valid");
            return null;
        }
        return outPath;
    }

    @Nullable
    public static String getModuleOutputPath(Module module, boolean forTestClasses) {
        String url;
        CompilerModuleExtension extension = CompilerModuleExtension.getInstance((Module)module);
        if (extension == null) {
            return null;
        }
        Application application = ApplicationManager.getApplication();
        String outPathUrl = forTestClasses ? (application.isDispatchThread() ? ((url = extension.getCompilerOutputUrlForTests()) != null ? url : extension.getCompilerOutputUrl()) : (String)ReadAction.compute(() -> {
            String url = extension.getCompilerOutputUrlForTests();
            return url != null ? url : extension.getCompilerOutputUrl();
        })) : (application.isDispatchThread() ? extension.getCompilerOutputUrl() : (String)ReadAction.compute(() -> extension.getCompilerOutputUrl()));
        return outPathUrl != null ? VirtualFileManager.extractPath((String)outPathUrl) : null;
    }

    @Nullable
    public static String getAnnotationProcessorsGenerationPath(Module module, boolean forTests) {
        AnnotationProcessingConfiguration config = CompilerConfiguration.getInstance(module.getProject()).getAnnotationProcessingConfiguration(module);
        String sourceDirName = config.getGeneratedSourcesDirectoryName(forTests);
        if (config.isOutputRelativeToContentRoot()) {
            Object[] roots = ModuleRootManager.getInstance((Module)module).getContentRootUrls();
            if (roots.length == 0) {
                return null;
            }
            if (roots.length > 1) {
                Arrays.sort(roots);
            }
            return StringUtil.isEmpty((String)sourceDirName) ? VirtualFileManager.extractPath((String)roots[0]) : VirtualFileManager.extractPath((String)roots[0]) + "/" + sourceDirName;
        }
        String path = CompilerPaths.getModuleOutputPath(module, forTests);
        if (path == null) {
            return null;
        }
        return StringUtil.isEmpty((String)sourceDirName) ? path : path + "/" + sourceDirName;
    }
}

