/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.ex;

import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ModuleRootModel;
import com.intellij.openapi.roots.OrderEnumerationHandler;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.util.ArrayUtil;
import com.intellij.util.SmartList;
import com.intellij.util.containers.OrderedSet;
import java.io.File;
import java.util.Collection;
import org.jetbrains.annotations.NotNull;

public class CompilerPathsEx
extends CompilerPaths {
    @NotNull
    public static String[] getOutputPaths(@NotNull Module[] modules) {
        OrderedSet outputPaths = new OrderedSet();
        for (Module module : modules) {
            String outputPathForTestsUrl;
            CompilerModuleExtension compilerModuleExtension;
            CompilerModuleExtension compilerModuleExtension2 = compilerModuleExtension = !module.isDisposed() ? CompilerModuleExtension.getInstance((Module)module) : null;
            if (compilerModuleExtension == null) continue;
            String outputPathUrl = compilerModuleExtension.getCompilerOutputUrl();
            if (outputPathUrl != null) {
                outputPaths.add(VirtualFileManager.extractPath((String)outputPathUrl).replace('/', File.separatorChar));
            }
            if ((outputPathForTestsUrl = compilerModuleExtension.getCompilerOutputUrlForTests()) != null) {
                outputPaths.add(VirtualFileManager.extractPath((String)outputPathForTestsUrl).replace('/', File.separatorChar));
            }
            ModuleRootManager moduleRootManager = ModuleRootManager.getInstance((Module)module);
            for (OrderEnumerationHandler.Factory handlerFactory : (OrderEnumerationHandler.Factory[])OrderEnumerationHandler.EP_NAME.getExtensions()) {
                if (!handlerFactory.isApplicable(module)) continue;
                OrderEnumerationHandler handler = handlerFactory.createHandler(module);
                SmartList outputUrls = new SmartList();
                handler.addCustomModuleRoots(OrderRootType.CLASSES, (ModuleRootModel)moduleRootManager, (Collection)outputUrls, true, true);
                for (String outputUrl : outputUrls) {
                    outputPaths.add(VirtualFileManager.extractPath((String)outputUrl).replace('/', File.separatorChar));
                }
            }
        }
        return ArrayUtil.toStringArray((Collection)outputPaths);
    }
}

