/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.compiler.options;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.compiler.options.ExcludeEntryDescription;
import com.intellij.openapi.compiler.options.ExcludedEntriesListener;
import com.intellij.openapi.compiler.options.ExcludesConfiguration;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.JDOMExternalizable;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ExcludedEntriesConfiguration
implements PersistentStateComponent<ExcludedEntriesConfiguration>,
JDOMExternalizable,
Disposable,
ExcludesConfiguration {
    @NonNls
    private static final String FILE = "file";
    @NonNls
    private static final String DIRECTORY = "directory";
    @NonNls
    private static final String URL = "url";
    @NonNls
    private static final String INCLUDE_SUBDIRECTORIES = "includeSubdirectories";
    private final Collection<ExcludeEntryDescription> myExcludeEntryDescriptions = new LinkedHashSet<ExcludeEntryDescription>();
    @Nullable
    private final ExcludedEntriesListener myEventPublisher;
    private ExcludeEntryDescription[] myCachedDescriptions = null;

    public ExcludedEntriesConfiguration() {
        this(null);
    }

    public ExcludedEntriesConfiguration(@Nullable ExcludedEntriesListener eventPublisher) {
        this.myEventPublisher = eventPublisher;
    }

    @Override
    public synchronized ExcludeEntryDescription[] getExcludeEntryDescriptions() {
        if (this.myCachedDescriptions == null) {
            this.myCachedDescriptions = this.myExcludeEntryDescriptions.toArray(new ExcludeEntryDescription[0]);
        }
        return this.myCachedDescriptions;
    }

    @Override
    public synchronized void addExcludeEntryDescription(ExcludeEntryDescription description) {
        if (this.myExcludeEntryDescriptions.add(description) && this.myEventPublisher != null) {
            this.myEventPublisher.onEntryAdded(description);
        }
        this.myCachedDescriptions = null;
    }

    @Override
    public synchronized void removeExcludeEntryDescription(ExcludeEntryDescription description) {
        if (this.myExcludeEntryDescriptions.remove(description) && this.myEventPublisher != null) {
            this.myEventPublisher.onEntryRemoved(description);
        }
        this.myCachedDescriptions = null;
    }

    @Override
    public synchronized void removeAllExcludeEntryDescriptions() {
        ExcludeEntryDescription[] oldDescriptions = this.getExcludeEntryDescriptions();
        this.myExcludeEntryDescriptions.clear();
        if (this.myEventPublisher != null) {
            for (ExcludeEntryDescription description : oldDescriptions) {
                this.myEventPublisher.onEntryRemoved(description);
            }
        }
        this.myCachedDescriptions = null;
    }

    @Override
    public synchronized boolean containsExcludeEntryDescription(ExcludeEntryDescription description) {
        return this.myExcludeEntryDescriptions.contains(description);
    }

    public void readExternal(Element node) {
        this.removeAllExcludeEntryDescriptions();
        for (Element element : node.getChildren()) {
            String url = element.getAttributeValue(URL);
            if (url == null) continue;
            if (FILE.equals(element.getName())) {
                ExcludeEntryDescription excludeEntryDescription = new ExcludeEntryDescription(url, false, true, (Disposable)this);
                this.addExcludeEntryDescription(excludeEntryDescription);
            }
            if (!DIRECTORY.equals(element.getName())) continue;
            boolean includeSubdirectories = Boolean.parseBoolean(element.getAttributeValue(INCLUDE_SUBDIRECTORIES));
            ExcludeEntryDescription excludeEntryDescription = new ExcludeEntryDescription(url, includeSubdirectories, false, (Disposable)this);
            this.addExcludeEntryDescription(excludeEntryDescription);
        }
    }

    public void writeExternal(Element element) {
        for (ExcludeEntryDescription description : this.getExcludeEntryDescriptions()) {
            Element entry;
            if (description.isFile()) {
                entry = new Element(FILE);
                entry.setAttribute(URL, description.getUrl());
                element.addContent(entry);
                continue;
            }
            entry = new Element(DIRECTORY);
            entry.setAttribute(URL, description.getUrl());
            entry.setAttribute(INCLUDE_SUBDIRECTORIES, Boolean.toString(description.isIncludeSubdirectories()));
            element.addContent(entry);
        }
    }

    @Override
    public boolean isExcluded(VirtualFile virtualFile) {
        for (ExcludeEntryDescription entryDescription : this.getExcludeEntryDescriptions()) {
            VirtualFile descriptionFile = entryDescription.getVirtualFile();
            if (descriptionFile == null || !(entryDescription.isFile() ? descriptionFile.equals(virtualFile) : (entryDescription.isIncludeSubdirectories() ? VfsUtilCore.isAncestor((VirtualFile)descriptionFile, (VirtualFile)virtualFile, (boolean)false) : !virtualFile.isDirectory() && descriptionFile.equals(virtualFile.getParent())))) continue;
            return true;
        }
        return false;
    }

    public void dispose() {
        for (ExcludeEntryDescription description : this.myExcludeEntryDescriptions) {
            Disposer.dispose((Disposable)description);
        }
    }

    public ExcludedEntriesConfiguration getState() {
        return this;
    }

    public void loadState(@NotNull ExcludedEntriesConfiguration state) {
        for (ExcludeEntryDescription description : state.getExcludeEntryDescriptions()) {
            this.addExcludeEntryDescription(description.copy(this));
        }
        Disposer.dispose((Disposable)state);
    }
}

