/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdk;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.projectRoots.JdkUtil;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.projectRoots.SdkModificator;
import com.intellij.openapi.projectRoots.impl.JavaSdkImpl;
import com.intellij.openapi.roots.LanguageLevelModuleExtensionImpl;
import com.intellij.openapi.roots.LanguageLevelProjectExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderRootType;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.testFramework.PlatformTestUtil;
import com.intellij.testFramework.Timings;
import com.intellij.testFramework.VfsTestUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.PathUtil;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.lang.JavaVersion;
import com.sun.tools.javac.Main;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.codehaus.groovy.tools.FileSystemCompiler;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;
import org.junit.Assume;

public class IdeaTestUtil
extends PlatformTestUtil {
    private static final String MOCK_JDK_DIR_NAME_PREFIX = "mockJDK-";

    public static void printDetectedPerformanceTimings() {
        System.out.println(Timings.getStatistics());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void withLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Runnable r) {
        LanguageLevelProjectExtension projectExt = LanguageLevelProjectExtension.getInstance((Project)module.getProject());
        LanguageLevel projectLevel = projectExt.getLanguageLevel();
        LanguageLevel moduleLevel = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        try {
            projectExt.setLanguageLevel(level);
            IdeaTestUtil.setModuleLanguageLevel(module, level);
            r.run();
        }
        finally {
            IdeaTestUtil.setModuleLanguageLevel(module, moduleLevel);
            projectExt.setLanguageLevel(projectLevel);
        }
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @Nullable LanguageLevel level) {
        LanguageLevelModuleExtensionImpl modifiable = (LanguageLevelModuleExtensionImpl)LanguageLevelModuleExtensionImpl.getInstance((Module)module).getModifiableModel(true);
        modifiable.setLanguageLevel(level);
        modifiable.commit();
    }

    public static void setModuleLanguageLevel(@NotNull Module module, @NotNull LanguageLevel level, @NotNull Disposable parentDisposable) {
        LanguageLevel prev = LanguageLevelModuleExtensionImpl.getInstance((Module)module).getLanguageLevel();
        IdeaTestUtil.setModuleLanguageLevel(module, level);
        Disposer.register((Disposable)parentDisposable, () -> IdeaTestUtil.setModuleLanguageLevel(module, prev));
    }

    @NotNull
    public static Sdk getMockJdk(@NotNull JavaVersion version) {
        int mockJdk = version.feature >= 11 ? 11 : (version.feature >= 9 ? 9 : (version.feature >= 7 ? version.feature : (version.feature >= 5 ? 7 : 4)));
        String path = IdeaTestUtil.getPathForJdkNamed(MOCK_JDK_DIR_NAME_PREFIX + (mockJdk < 11 ? "1." : "") + mockJdk).getPath();
        return IdeaTestUtil.createMockJdk("java " + version, path);
    }

    @NotNull
    private static Sdk createMockJdk(@NotNull String name, @NotNull String path) {
        return ((JavaSdkImpl)JavaSdk.getInstance()).createMockJdk(name, path, false);
    }

    @NotNull
    public static Sdk getMockJdk14() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)4));
    }

    @NotNull
    public static Sdk getMockJdk17() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)7));
    }

    @NotNull
    public static Sdk getMockJdk17(@NotNull String name) {
        return IdeaTestUtil.createMockJdk(name, IdeaTestUtil.getMockJdk17Path().getPath());
    }

    @NotNull
    public static Sdk getMockJdk18() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)8));
    }

    @NotNull
    public static Sdk getMockJdk9() {
        return IdeaTestUtil.getMockJdk(JavaVersion.compose((int)9));
    }

    @NotNull
    public static File getMockJdk14Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.4");
    }

    @NotNull
    public static File getMockJdk17Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.7");
    }

    @NotNull
    public static File getMockJdk18Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.8");
    }

    @NotNull
    public static File getMockJdk9Path() {
        return IdeaTestUtil.getPathForJdkNamed("mockJDK-1.9");
    }

    public static String getMockJdkVersion(@NotNull String path) {
        String name = PathUtil.getFileName((String)path);
        if (name.startsWith(MOCK_JDK_DIR_NAME_PREFIX)) {
            return "java " + StringUtil.trimStart((String)name, (String)MOCK_JDK_DIR_NAME_PREFIX);
        }
        return null;
    }

    @NotNull
    private static File getPathForJdkNamed(@NotNull String name) {
        return new File(PathManager.getCommunityHomePath(), "java/" + name);
    }

    @NotNull
    public static Sdk getWebMockJdk17() {
        Sdk jdk = IdeaTestUtil.getMockJdk17();
        jdk = IdeaTestUtil.addWebJarsTo(jdk);
        return jdk;
    }

    @NotNull
    @Contract(pure=true)
    public static Sdk addWebJarsTo(@NotNull Sdk jdk) {
        try {
            jdk = (Sdk)jdk.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        SdkModificator sdkModificator = jdk.getSdkModificator();
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/jsp-api.jar"), OrderRootType.CLASSES);
        sdkModificator.addRoot(IdeaTestUtil.findJar("lib/servlet-api.jar"), OrderRootType.CLASSES);
        sdkModificator.commitChanges();
        return jdk;
    }

    @NotNull
    private static VirtualFile findJar(@NotNull String name) {
        String path = PathManager.getHomePath() + '/' + name;
        VirtualFile file = VfsTestUtil.findFileByCaseSensitivePath((String)path);
        VirtualFile jar = JarFileSystem.getInstance().getJarRootForLocalFile(file);
        assert (jar != null) : "no .jar for: " + path;
        return jar;
    }

    public static void setTestVersion(@NotNull JavaSdkVersion testVersion, @NotNull Module module, @NotNull Disposable parentDisposable) {
        Sdk sdk = ModuleRootManager.getInstance((Module)module).getSdk();
        Assert.assertNotNull((Object)sdk);
        String oldVersionString = sdk.getVersionString();
        ((SdkModificator)sdk).setVersionString(testVersion.getDescription());
        Assert.assertSame((Object)testVersion, (Object)JavaSdk.getInstance().getVersion(sdk));
        Disposer.register((Disposable)parentDisposable, () -> ((SdkModificator)sdk).setVersionString(oldVersionString));
    }

    @NotNull
    public static String requireRealJdkHome() {
        String javaHome = SystemProperties.getJavaHome();
        List paths = ContainerUtil.packNullables((Object[])new String[]{javaHome, new File(javaHome).getParent(), System.getenv("JDK_16_x64"), System.getenv("JDK_16")});
        for (String path : paths) {
            if (!JdkUtil.checkForJdk((String)path)) continue;
            return path;
        }
        Assume.assumeTrue((String)("Cannot find JDK, checked paths: " + paths), (boolean)false);
        return null;
    }

    @NotNull
    public static File findSourceFile(@NotNull String basePath) {
        File testFile = new File(basePath + ".java");
        if (!testFile.exists()) {
            testFile = new File(basePath + ".groovy");
        }
        if (!testFile.exists()) {
            throw new IllegalArgumentException("No test source for " + basePath);
        }
        return testFile;
    }

    public static void compileFile(@NotNull File source, @NotNull File out, String ... options) {
        Assert.assertTrue((String)("source does not exist: " + source.getPath()), (boolean)source.isFile());
        ArrayList<String> args = new ArrayList<String>();
        args.add("-d");
        args.add(out.getAbsolutePath());
        ContainerUtil.addAll(args, (Object[])options);
        args.add(source.getAbsolutePath());
        if (source.getName().endsWith(".groovy")) {
            try {
                FileSystemCompiler.commandLineCompile((String[])ArrayUtil.toStringArray(args));
            }
            catch (Exception e) {
                throw new IllegalStateException(e);
            }
        } else {
            int result = Main.compile(ArrayUtil.toStringArray(args));
            if (result != 0) {
                throw new IllegalStateException("javac failed with exit code " + result);
            }
        }
    }
}

