/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspectionBase;
import com.intellij.codeInspection.deadCode.UnusedDeclarationPresentation;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.codeInspection.reference.EntryPoint;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.openapi.application.ex.PathManagerEx;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ContentEntry;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.testFramework.InspectionTestUtil;
import com.intellij.testFramework.InspectionsKt;
import com.intellij.testFramework.LightProjectDescriptor;
import com.intellij.testFramework.LightTestMigration;
import com.intellij.testFramework.fixtures.DefaultLightProjectDescriptor;
import com.intellij.testFramework.fixtures.LightCodeInsightFixtureTestCase;
import com.intellij.testFramework.fixtures.impl.GlobalInspectionContextForTests;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public abstract class InspectionTestCase
extends LightCodeInsightFixtureTestCase {
    private static final boolean MIGRATE_TEST = false;
    private static final DefaultLightProjectDescriptor ourDescriptor = new DefaultLightProjectDescriptor(){

        @Override
        public void configureModule(@NotNull Module module, @NotNull ModifiableRootModel model, @NotNull ContentEntry contentEntry) {
            super.configureModule(module, model, contentEntry);
            contentEntry.addSourceFolder(contentEntry.getUrl() + "/ext_src", false);
            contentEntry.addSourceFolder(contentEntry.getUrl() + "/test_src", true);
        }
    };
    private EntryPoint myUnusedCodeExtension;
    private VirtualFile ext_src;
    private LightTestMigration myMigration;

    public static GlobalInspectionToolWrapper getUnusedDeclarationWrapper() {
        InspectionEP ep = new InspectionEP();
        ep.presentation = UnusedDeclarationPresentation.class.getName();
        ep.implementationClass = UnusedDeclarationInspection.class.getName();
        ep.shortName = "unused";
        ep.displayName = UnusedDeclarationInspectionBase.DISPLAY_NAME;
        return new GlobalInspectionToolWrapper(ep);
    }

    public InspectionManagerEx getManager() {
        return (InspectionManagerEx)InspectionManager.getInstance((Project)this.getProject());
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull LocalInspectionTool tool) {
        this.doTest(folderName, (InspectionToolWrapper)new LocalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull GlobalInspectionTool tool) {
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool));
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull GlobalInspectionTool tool, boolean checkRange) {
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool), checkRange);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull GlobalInspectionTool tool, boolean checkRange, boolean runDeadCodeFirst) {
        this.doTest(folderName, (InspectionToolWrapper)new GlobalInspectionToolWrapper(tool), checkRange, runDeadCodeFirst, new InspectionToolWrapper[0]);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper tool) {
        this.doTest(folderName, tool, false);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper tool, boolean checkRange) {
        this.doTest(folderName, tool, checkRange, false, new InspectionToolWrapper[0]);
    }

    public void doTest(@NonNls @NotNull String folderName, @NotNull InspectionToolWrapper toolWrapper, boolean checkRange, boolean runDeadCodeFirst, InspectionToolWrapper ... additional) {
        String testDir = this.getTestDataPath() + "/" + folderName;
        List<InspectionToolWrapper<?, ?>> tools = InspectionTestCase.getTools(runDeadCodeFirst, toolWrapper, additional);
        GlobalInspectionContextImpl context = this.runTool(folderName, toolWrapper, tools);
        InspectionTestUtil.compareToolResults((GlobalInspectionContextImpl)context, (boolean)checkRange, (String)testDir, (Collection)ContainerUtil.append(Collections.singletonList(toolWrapper), (Object[])additional));
    }

    protected GlobalInspectionContextImpl runTool(@NotNull String testName, @NotNull InspectionToolWrapper toolWrapper, List<? extends InspectionToolWrapper<?, ?>> tools) {
        VirtualFile projectDir = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(new File(this.getTestDataPath(), testName));
        InspectionTestCase.assertNotNull((Object)projectDir);
        VirtualFile srcDir = projectDir.findChild("src") != null ? this.myFixture.copyDirectoryToProject(testName + "/src", "") : this.myFixture.copyDirectoryToProject(testName, "");
        if (projectDir.findChild("ext_src") != null) {
            this.ext_src = this.myFixture.copyDirectoryToProject(testName + "/ext_src", "ext_src");
        }
        if (projectDir.findChild("test_src") != null) {
            this.myFixture.copyDirectoryToProject(testName + "/test_src", "test_src");
        }
        AnalysisScope scope = this.createAnalysisScope(srcDir);
        GlobalInspectionContextForTests globalContext = InspectionsKt.createGlobalContextForTool((AnalysisScope)scope, (Project)this.getProject(), tools);
        InspectionTestUtil.runTool((InspectionToolWrapper)toolWrapper, (AnalysisScope)scope, (GlobalInspectionContextForTests)globalContext);
        return globalContext;
    }

    @NotNull
    private static List<InspectionToolWrapper<?, ?>> getTools(boolean runDeadCodeFirst, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolWrapper[] additional) {
        ArrayList toolWrappers = new ArrayList();
        if (runDeadCodeFirst) {
            toolWrappers.add((InspectionToolWrapper<?, ?>)InspectionTestCase.getUnusedDeclarationWrapper());
        }
        toolWrappers.add(toolWrapper);
        ContainerUtil.addAll(toolWrappers, (Object[])additional);
        return toolWrappers;
    }

    @NotNull
    protected AnalysisScope createAnalysisScope(VirtualFile sourceDir) {
        PsiManager psiManager = PsiManager.getInstance((Project)this.getProject());
        return new AnalysisScope(psiManager.findDirectory(sourceDir));
    }

    @Override
    @NotNull
    protected LightProjectDescriptor getProjectDescriptor() {
        return ourDescriptor;
    }

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myUnusedCodeExtension = new EntryPoint(){

            @NotNull
            public String getDisplayName() {
                return "duh";
            }

            public boolean isEntryPoint(@NotNull RefElement refElement, @NotNull PsiElement psiElement) {
                return this.isEntryPoint(psiElement);
            }

            public boolean isEntryPoint(@NotNull PsiElement psiElement) {
                return InspectionTestCase.this.ext_src != null && VfsUtilCore.isAncestor((VirtualFile)InspectionTestCase.this.ext_src, (VirtualFile)PsiUtilCore.getVirtualFile((PsiElement)psiElement), (boolean)false);
            }

            public boolean isSelected() {
                return true;
            }

            public void setSelected(boolean selected) {
            }

            public void readExternal(Element element) {
            }

            public void writeExternal(Element element) {
            }
        };
        Extensions.getRootArea().getExtensionPoint("com.intellij.deadCode").registerExtension((Object)this.myUnusedCodeExtension, this.getTestRootDisposable());
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            this.myUnusedCodeExtension = null;
            this.ext_src = null;
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            super.tearDown();
        }
        if (this.myMigration != null) {
            this.myMigration.tryMigrate();
        }
    }

    @Override
    @NonNls
    protected String getTestDataPath() {
        return PathManagerEx.getTestDataPath() + "/inspection/";
    }
}

