/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteAction;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.ModuleType;
import com.intellij.openapi.module.StdModuleTypes;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.testFramework.IdeaTestCase;
import com.intellij.testFramework.PsiTestUtil;
import com.intellij.util.Consumer;
import com.intellij.util.SmartList;
import com.intellij.util.lang.CompoundRuntimeException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class ModuleTestCase
extends IdeaTestCase {
    protected final Collection<Module> myModulesToDispose = new ArrayList<Module>();

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.myModulesToDispose.clear();
    }

    @Override
    protected void tearDown() throws Exception {
        try {
            if (!this.myModulesToDispose.isEmpty()) {
                SmartList errors = new SmartList();
                WriteAction.run(() -> this.lambda$tearDown$0((List)errors));
                CompoundRuntimeException.throwIfNotEmpty((List)errors);
            }
        }
        catch (Throwable e) {
            this.addSuppressedException(e);
        }
        finally {
            this.myModulesToDispose.clear();
            super.tearDown();
        }
    }

    @NotNull
    protected Module createModule(@NotNull File moduleFile) {
        return this.createModule(moduleFile, StdModuleTypes.JAVA);
    }

    @NotNull
    protected Module createModule(@NotNull File moduleFile, @NotNull ModuleType moduleType) {
        String path = moduleFile.getAbsolutePath();
        return this.createModule(path, moduleType);
    }

    @NotNull
    protected Module createModule(@NotNull String path, @NotNull ModuleType moduleType) {
        Module module = (Module)WriteAction.compute(() -> ModuleManager.getInstance((Project)this.myProject).newModule(path, moduleType.getId()));
        this.myModulesToDispose.add(module);
        return module;
    }

    @NotNull
    protected Module loadModule(@NotNull VirtualFile file) {
        return this.loadModule(file.getPath());
    }

    @NotNull
    protected Module loadModule(@NotNull String modulePath) {
        Module module;
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        try {
            module = (Module)ApplicationManager.getApplication().runWriteAction(() -> moduleManager.loadModule(FileUtil.toSystemIndependentName((String)modulePath)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        this.myModulesToDispose.add(module);
        return module;
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir) {
        return this.loadAllModulesUnder(rootDir, null);
    }

    @Nullable
    protected Module loadAllModulesUnder(@NotNull VirtualFile rootDir, final @Nullable Consumer<? super Module> moduleConsumer) {
        final Ref result = Ref.create();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)rootDir, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                if (!file.isDirectory() && file.getName().endsWith(".iml")) {
                    Module module = ModuleTestCase.this.loadModule(file);
                    if (moduleConsumer != null) {
                        moduleConsumer.consume((Object)module);
                    }
                    result.setIfNull((Object)module);
                }
                return true;
            }
        });
        return (Module)result.get();
    }

    @NotNull
    protected Module createModuleFromTestData(@NotNull String dirInTestData, @NotNull String newModuleFileName, @NotNull ModuleType moduleType, boolean addSourceRoot) throws IOException {
        File dirInTestDataFile = new File(dirInTestData);
        ModuleTestCase.assertTrue((boolean)dirInTestDataFile.isDirectory());
        File moduleDir = this.createTempDirectory();
        FileUtil.copyDir((File)dirInTestDataFile, (File)moduleDir);
        Module module = this.createModule(moduleDir + "/" + newModuleFileName, moduleType);
        VirtualFile root = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(moduleDir);
        ModuleTestCase.assertNotNull((Object)root);
        WriteCommandAction.writeCommandAction((Project)module.getProject()).run(() -> root.refresh(false, true));
        if (addSourceRoot) {
            PsiTestUtil.addSourceContentToRoots((Module)module, (VirtualFile)root);
        } else {
            PsiTestUtil.addContentRoot((Module)module, (VirtualFile)root);
        }
        return module;
    }

    private /* synthetic */ void lambda$tearDown$0(List errors) throws RuntimeException {
        ModuleManager moduleManager = ModuleManager.getInstance((Project)this.myProject);
        for (Module module : this.myModulesToDispose) {
            try {
                String moduleName = module.getName();
                if (moduleManager.findModuleByName(moduleName) == null) continue;
                moduleManager.disposeModule(module);
            }
            catch (Throwable e) {
                errors.add(e);
            }
        }
    }
}

