/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.testFramework.codeInsight.hierarchy;

import com.intellij.codeInsight.CodeInsightTestCase;
import com.intellij.ide.hierarchy.HierarchyTreeStructure;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.testFramework.codeInsight.hierarchy.HierarchyViewTestFixture;
import java.io.File;
import java.io.IOException;
import org.jetbrains.annotations.NotNull;

public abstract class HierarchyViewTestBase
extends CodeInsightTestCase {
    private final HierarchyViewTestFixture myFixture = new HierarchyViewTestFixture();

    protected abstract String getBasePath();

    protected void doHierarchyTest(@NotNull Computable<? extends HierarchyTreeStructure> treeStructureComputable, String ... fileNames) throws Exception {
        this.configure(fileNames);
        String expectedStructure = this.loadExpectedStructure();
        this.myFixture.doHierarchyTest((HierarchyTreeStructure)treeStructureComputable.compute(), expectedStructure);
    }

    private void configure(@NotNull String[] fileNames) {
        String[] relFilePaths = new String[fileNames.length];
        for (int i = 0; i < fileNames.length; ++i) {
            relFilePaths[i] = "/" + this.getBasePath() + "/" + fileNames[i];
        }
        this.configureByFiles(null, relFilePaths);
    }

    @NotNull
    private String loadExpectedStructure() throws IOException {
        String verificationFilePath = this.getTestDataPath() + "/" + this.getBasePath() + "/" + this.getTestName(false) + "_verification.xml";
        return FileUtil.loadFile((File)new File(verificationFilePath));
    }
}

