/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.util.Iconable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.xml.XmlDocument;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.util.ArrayUtil;
import com.intellij.util.ConstantFunction;
import com.intellij.util.NotNullFunction;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ConcurrentInstanceMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomReferenceInjector;
import com.intellij.util.xml.DomReflectionUtil;
import com.intellij.util.xml.DomService;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.Namespace;
import com.intellij.util.xml.Scope;
import com.intellij.util.xml.ScopeProvider;
import com.intellij.util.xml.TypeChooser;
import com.intellij.util.xml.TypeChooserManager;
import com.intellij.util.xml.XmlFileHeader;
import com.intellij.util.xml.highlighting.DomElementsAnnotator;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomFileDescription<T> {
    public static final ExtensionPointName<DomFileDescription> EP_NAME = ExtensionPointName.create((String)"com.intellij.dom.fileDescription");
    private final Map<Class<? extends ScopeProvider>, ScopeProvider> myScopeProviders = ConcurrentInstanceMap.create();
    protected final Class<T> myRootElementClass;
    protected final String myRootTagName;
    private final String[] myAllPossibleRootTagNamespaces;
    private volatile boolean myInitialized;
    private final Map<Class<? extends DomElement>, Class<? extends DomElement>> myImplementations = new HashMap<Class<? extends DomElement>, Class<? extends DomElement>>();
    private final TypeChooserManager myTypeChooserManager = new TypeChooserManager();
    private final List<DomReferenceInjector> myInjectors = new SmartList();
    private final Map<String, NotNullFunction<XmlTag, List<String>>> myNamespacePolicies = ContainerUtil.newConcurrentMap();

    public DomFileDescription(Class<T> rootElementClass, @NonNls String rootTagName, String ... allPossibleRootTagNamespaces) {
        this.myRootElementClass = rootElementClass;
        this.myRootTagName = rootTagName;
        this.myAllPossibleRootTagNamespaces = allPossibleRootTagNamespaces.length == 0 ? ArrayUtil.EMPTY_STRING_ARRAY : allPossibleRootTagNamespaces;
    }

    @NotNull
    public String[] getAllPossibleRootTagNamespaces() {
        return this.myAllPossibleRootTagNamespaces;
    }

    @Deprecated
    public final <T extends DomElement> void registerImplementation(Class<T> domElementClass, Class<? extends T> implementationClass) {
        this.myImplementations.put(domElementClass, implementationClass);
    }

    @Deprecated
    protected final void registerNamespacePolicy(String namespaceKey, NotNullFunction<XmlTag, List<String>> policy) {
        this.myNamespacePolicies.put(namespaceKey, policy);
    }

    public final void registerNamespacePolicy(String namespaceKey, String ... namespaces) {
        this.registerNamespacePolicy(namespaceKey, (NotNullFunction<XmlTag, List<String>>)new ConstantFunction(Arrays.asList(namespaces)));
    }

    @NotNull
    public List<String> getAllowedNamespaces(@NotNull String namespaceKey, @NotNull XmlFile file) {
        NotNullFunction<XmlTag, List<String>> function = this.myNamespacePolicies.get(namespaceKey);
        if (function instanceof ConstantFunction) {
            return (List)function.fun(null);
        }
        if (function != null) {
            XmlTag tag;
            XmlDocument document = file.getDocument();
            if (document != null && (tag = document.getRootTag()) != null) {
                return (List)function.fun((Object)tag);
            }
        } else {
            return Collections.singletonList(namespaceKey);
        }
        return Collections.emptyList();
    }

    @Deprecated
    public int getVersion() {
        return this.myRootTagName.hashCode();
    }

    protected final void registerTypeChooser(Type aClass, TypeChooser typeChooser) {
        this.myTypeChooserManager.registerTypeChooser(aClass, typeChooser);
    }

    public final TypeChooserManager getTypeChooserManager() {
        return this.myTypeChooserManager;
    }

    protected final void registerReferenceInjector(DomReferenceInjector injector) {
        this.myInjectors.add(injector);
    }

    public List<DomReferenceInjector> getReferenceInjectors() {
        return this.myInjectors;
    }

    public boolean isAutomaticHighlightingEnabled() {
        return true;
    }

    @Nullable
    public Icon getFileIcon(@Iconable.IconFlags int flags) {
        return null;
    }

    protected void initializeFileDescription() {
    }

    @Nullable
    public DomElementsAnnotator createAnnotator() {
        return null;
    }

    public final Map<Class<? extends DomElement>, Class<? extends DomElement>> getImplementations() {
        if (!this.myInitialized) {
            this.initializeFileDescription();
            this.myInitialized = true;
        }
        return this.myImplementations;
    }

    @NotNull
    public final Class<T> getRootElementClass() {
        return this.myRootElementClass;
    }

    public final String getRootTagName() {
        return this.myRootTagName;
    }

    public boolean isMyFile(@NotNull XmlFile file, @Nullable Module module) {
        Namespace namespace = DomReflectionUtil.findAnnotationDFS(this.myRootElementClass, Namespace.class);
        if (namespace != null) {
            String key = namespace.value();
            HashSet<String> allNs = new HashSet<String>(this.getAllowedNamespaces(key, file));
            if (allNs.isEmpty()) {
                return false;
            }
            XmlFileHeader header = DomService.getInstance().getXmlFileHeader(file);
            return allNs.contains(header.getPublicId()) || allNs.contains(header.getSystemId()) || allNs.contains(header.getRootTagNamespace());
        }
        return true;
    }

    public boolean acceptsOtherRootTagNames() {
        return false;
    }

    @NotNull
    public Set<?> getDependencyItems(XmlFile file) {
        return Collections.emptySet();
    }

    @NotNull
    public DomElement getResolveScope(GenericDomValue<?> reference) {
        DomElement annotation = this.getScopeFromAnnotation(reference);
        if (annotation != null) {
            return annotation;
        }
        return DomUtil.getRoot(reference);
    }

    @NotNull
    public DomElement getIdentityScope(DomElement element) {
        DomElement annotation = this.getScopeFromAnnotation(element);
        if (annotation != null) {
            return annotation;
        }
        return element.getParent();
    }

    @Nullable
    protected final DomElement getScopeFromAnnotation(DomElement element) {
        Scope scope = element.getAnnotation(Scope.class);
        if (scope != null) {
            return this.myScopeProviders.get(scope.value()).getScope(element);
        }
        return null;
    }

    @Deprecated
    public boolean hasStubs() {
        return false;
    }

    @Deprecated
    public int getStubVersion() {
        throw new UnsupportedOperationException("define \"stubVersion\" of \"com.intellij.dom.fileMetaData\" extension instead");
    }

    public String toString() {
        return this.getRootElementClass() + " <" + this.getRootTagName() + "> \n" + StringUtil.join((String[])this.getAllPossibleRootTagNamespaces());
    }
}

