/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.ide.TypePresentationService;
import com.intellij.openapi.project.Project;
import com.intellij.pom.references.PomService;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiTarget;
import com.intellij.psi.util.CachedValue;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PsiModificationTracker;
import com.intellij.util.containers.ConcurrentFactoryMap;
import com.intellij.util.containers.SoftFactoryMap;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomTarget;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.ElementPresentationManager;
import com.intellij.util.xml.GenericAttributeValue;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import com.intellij.util.xml.highlighting.ResolvingElementQuickFix;
import gnu.trove.THashMap;
import java.util.Collection;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomResolveConverter<T extends DomElement>
extends ResolvingConverter<T> {
    private static final Map<Class<? extends DomElement>, DomResolveConverter> ourCache = ConcurrentFactoryMap.createMap(key -> new DomResolveConverter(key));
    private final boolean myAttribute;
    private final SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>> myResolveCache = new SoftFactoryMap<DomElement, CachedValue<Map<String, DomElement>>>(){

        @NotNull
        protected CachedValue<Map<String, DomElement>> create(final DomElement scope) {
            DomManager domManager = scope.getManager();
            if (domManager == null) {
                throw new AssertionError((Object)("Null DomManager for " + scope.getClass()));
            }
            Project project = domManager.getProject();
            return CachedValuesManager.getManager((Project)project).createCachedValue((CachedValueProvider)new CachedValueProvider<Map<String, DomElement>>(){

                public CachedValueProvider.Result<Map<String, DomElement>> compute() {
                    THashMap map = new THashMap();
                    this.visitDomElement(scope, (Map<String, DomElement>)map);
                    return new CachedValueProvider.Result((Object)map, new Object[]{PsiModificationTracker.OUT_OF_CODE_BLOCK_MODIFICATION_COUNT});
                }

                private void visitDomElement(DomElement element, Map<String, DomElement> map) {
                    if (DomResolveConverter.this.myClass.isInstance(element)) {
                        String name = ElementPresentationManager.getElementName(element);
                        if (name != null && !map.containsKey(name)) {
                            map.put(name, element);
                        }
                    } else {
                        for (DomElement child : DomUtil.getDefinedChildren(element, true, DomResolveConverter.this.myAttribute)) {
                            this.visitDomElement(child, map);
                        }
                    }
                }
            }, false);
        }
    };
    private final Class<T> myClass;

    public DomResolveConverter(Class<T> aClass) {
        this.myClass = aClass;
        this.myAttribute = GenericAttributeValue.class.isAssignableFrom(this.myClass);
    }

    public static <T extends DomElement> DomResolveConverter<T> createConverter(Class<T> aClass) {
        return ourCache.get(aClass);
    }

    @Override
    public final T fromString(String s, ConvertContext context) {
        if (s == null) {
            return null;
        }
        return (T)((DomElement)((Map)((CachedValue)this.myResolveCache.get((Object)DomResolveConverter.getResolvingScope(context))).getValue()).get(s));
    }

    @Override
    public PsiElement getPsiElement(@Nullable T resolvedValue) {
        if (resolvedValue == null) {
            return null;
        }
        DomTarget target = DomTarget.getTarget(resolvedValue);
        return target == null ? super.getPsiElement(resolvedValue) : PomService.convertToPsi((PsiTarget)target);
    }

    @Override
    public boolean isReferenceTo(@NotNull PsiElement element, String stringValue, @Nullable T resolveResult, ConvertContext context) {
        return resolveResult != null && element.getManager().areElementsEquivalent(element, (PsiElement)resolveResult.getXmlElement());
    }

    private static DomElement getResolvingScope(ConvertContext context) {
        DomElement invocationElement = context.getInvocationElement();
        return invocationElement.getManager().getResolvingScope((GenericDomValue)invocationElement);
    }

    @Override
    public String getErrorMessage(String s, ConvertContext context) {
        return CodeInsightBundle.message((String)"error.cannot.resolve.0.1", (Object[])new Object[]{TypePresentationService.getService().getTypePresentableName(this.myClass), s});
    }

    @Override
    public final String toString(T t, ConvertContext context) {
        if (t == null) {
            return null;
        }
        return ElementPresentationManager.getElementName(t);
    }

    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        DomElement reference = context.getInvocationElement();
        DomElement scope = reference.getManager().getResolvingScope((GenericDomValue)reference);
        return ((Map)((CachedValue)this.myResolveCache.get((Object)scope)).getValue()).values();
    }

    @Override
    public LocalQuickFix[] getQuickFixes(ConvertContext context) {
        DomElement element = context.getInvocationElement();
        GenericDomValue value = (GenericDomValue)((GenericDomValue)element).createStableCopy();
        String newName = value.getStringValue();
        if (newName == null) {
            return LocalQuickFix.EMPTY_ARRAY;
        }
        DomElement scope = value.getManager().getResolvingScope(value);
        return ResolvingElementQuickFix.createFixes(newName, this.myClass, scope);
    }
}

