/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.converters;

import com.intellij.codeInsight.daemon.EmptyResolveMessageProvider;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.ElementManipulators;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPolyVariantReferenceBase;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.xml.ConvertContext;
import com.intellij.util.xml.CustomReferenceConverter;
import com.intellij.util.xml.DomBundle;
import com.intellij.util.xml.GenericDomValue;
import com.intellij.util.xml.ResolvingConverter;
import java.util.Collection;
import java.util.Collections;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class QuotedValueConverter<T>
extends ResolvingConverter<T>
implements CustomReferenceConverter<T> {
    public static final char[] QUOTE_SIGNS = new char[]{'\'', '\"', '`'};

    protected char[] getQuoteSigns() {
        return QUOTE_SIGNS;
    }

    protected char getQuoteSign(T t, ConvertContext context) {
        return '\u0000';
    }

    @Nullable
    protected abstract T convertString(@Nullable String var1, ConvertContext var2);

    @Nullable
    protected abstract String convertValue(@Nullable T var1, ConvertContext var2);

    protected abstract Object[] getReferenceVariants(ConvertContext var1, GenericDomValue<T> var2, TextRange var3);

    @NotNull
    protected abstract ResolveResult[] multiResolveReference(@Nullable T var1, ConvertContext var2);

    protected abstract String getUnresolvedMessage(String var1);

    @Override
    @NotNull
    public Collection<? extends T> getVariants(ConvertContext context) {
        return Collections.emptyList();
    }

    @Override
    public T fromString(String str, ConvertContext context) {
        return this.convertString(QuotedValueConverter.unquote(str, this.getQuoteSigns()), context);
    }

    @Override
    public String toString(T ts, ConvertContext context) {
        char delimiter = this.getQuoteSign(ts, context);
        String s = this.convertValue(ts, context);
        return delimiter > '\u0000' ? delimiter + s + delimiter : s;
    }

    @Override
    @NotNull
    public PsiReference[] createReferences(GenericDomValue<T> genericDomValue, PsiElement element, ConvertContext context) {
        String originalValue = genericDomValue.getStringValue();
        if (originalValue == null) {
            return PsiReference.EMPTY_ARRAY;
        }
        TextRange range = ElementManipulators.getValueTextRange((PsiElement)element);
        String unquotedValue = QuotedValueConverter.unquote(originalValue, this.getQuoteSigns());
        int valueOffset = range.substring(element.getText()).indexOf(unquotedValue);
        if (valueOffset < 0) {
            return PsiReference.EMPTY_ARRAY;
        }
        int start = range.getStartOffset() + valueOffset;
        int end = start + unquotedValue.length();
        boolean unclosedQuotation = valueOffset > 0 && end == range.getEndOffset();
        return new PsiReference[]{this.createPsiReference(element, start, end, true, context, genericDomValue, unclosedQuotation)};
    }

    @Nullable
    public static String unquote(String str) {
        return QuotedValueConverter.unquote(str, QUOTE_SIGNS);
    }

    @Contract(value="null, _ -> null")
    public static String unquote(String str, char[] quoteSigns) {
        if (str != null && str.length() > 2) {
            char c = str.charAt(0);
            for (char quote : quoteSigns) {
                if (quote != c) continue;
                return str.substring(1, c == str.charAt(str.length() - 1) ? str.length() - 1 : str.length());
            }
        }
        return str;
    }

    public static boolean quotationIsNotClosed(String str) {
        return StringUtil.isNotEmpty((String)str) && str.charAt(0) != str.charAt(str.length() - 1);
    }

    @NotNull
    protected PsiReference createPsiReference(PsiElement element, int start, int end, boolean isSoft, ConvertContext context, GenericDomValue<T> genericDomValue, boolean badQuotation) {
        return new MyPsiReference(element, new TextRange(start, end), isSoft, context, genericDomValue, badQuotation);
    }

    protected class MyPsiReference
    extends PsiPolyVariantReferenceBase<PsiElement>
    implements EmptyResolveMessageProvider {
        protected final ConvertContext myContext;
        protected final GenericDomValue<T> myGenericDomValue;
        private final boolean myBadQuotation;

        public MyPsiReference(PsiElement element, TextRange range, boolean isSoft, ConvertContext context, GenericDomValue<T> genericDomValue, boolean badQuotation) {
            super(element, range, isSoft);
            this.myContext = context;
            this.myGenericDomValue = genericDomValue;
            this.myBadQuotation = badQuotation;
        }

        @NotNull
        public ResolveResult[] multiResolve(boolean incompleteCode) {
            if (this.myBadQuotation) {
                return ResolveResult.EMPTY_ARRAY;
            }
            String value = this.getValue();
            return QuotedValueConverter.this.multiResolveReference(QuotedValueConverter.this.convertString(value, this.myContext), this.myContext);
        }

        @NotNull
        public Object[] getVariants() {
            return QuotedValueConverter.this.getReferenceVariants(this.myContext, this.myGenericDomValue, this.getRangeInElement());
        }

        @NotNull
        public String getUnresolvedMessagePattern() {
            return this.myBadQuotation ? DomBundle.message("message.invalid.value.quotation", new Object[0]) : QuotedValueConverter.this.getUnresolvedMessage(this.getValue());
        }
    }
}

