/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.xml.tree;

import com.intellij.ide.util.treeView.AbstractTreeBuilder;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.treeStructure.SimpleNode;
import com.intellij.ui.treeStructure.SimpleTree;
import com.intellij.ui.treeStructure.SimpleTreeStructure;
import com.intellij.ui.treeStructure.WeightBasedComparator;
import com.intellij.ui.treeStructure.actions.CollapseAllAction;
import com.intellij.ui.treeStructure.actions.ExpandAllAction;
import com.intellij.util.ui.tree.TreeUtil;
import com.intellij.util.xml.DomChangeAdapter;
import com.intellij.util.xml.DomElement;
import com.intellij.util.xml.DomFileElement;
import com.intellij.util.xml.DomManager;
import com.intellij.util.xml.DomUtil;
import com.intellij.util.xml.MergedObject;
import com.intellij.util.xml.highlighting.DomElementAnnotationsManager;
import com.intellij.util.xml.tree.AbstractDomElementNode;
import com.intellij.util.xml.tree.DomElementsGroupNode;
import com.intellij.util.xml.tree.DomModelTreeStructure;
import java.awt.Component;
import java.util.Comparator;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DomModelTreeView
extends Wrapper
implements DataProvider,
Disposable {
    public static final DataKey<DomModelTreeView> DATA_KEY = DataKey.create((String)"DOM_MODEL_TREE_VIEW_KEY");
    @NonNls
    public static String DOM_MODEL_TREE_VIEW_POPUP = "DOM_MODEL_TREE_VIEW_POPUP";
    private final SimpleTree myTree;
    private final AbstractTreeBuilder myBuilder;
    private final DomManager myDomManager;
    @Nullable
    private final DomElement myRootElement;

    public DomModelTreeView(@NotNull DomElement rootElement) {
        this(rootElement, rootElement.getManager(), new DomModelTreeStructure(rootElement));
    }

    protected DomModelTreeView(DomElement rootElement, DomManager manager, SimpleTreeStructure treeStructure) {
        this.myDomManager = manager;
        this.myRootElement = rootElement;
        this.myTree = new SimpleTree((TreeModel)new DefaultTreeModel(new DefaultMutableTreeNode()));
        this.myTree.setRootVisible(this.isRootVisible());
        this.myTree.setShowsRootHandles(true);
        this.myTree.getSelectionModel().setSelectionMode(1);
        ToolTipManager.sharedInstance().registerComponent((JComponent)this.myTree);
        TreeUtil.installActions((JTree)this.myTree);
        this.myBuilder = new AbstractTreeBuilder((JTree)this.myTree, (DefaultTreeModel)this.myTree.getModel(), (AbstractTreeStructure)treeStructure, (Comparator)WeightBasedComparator.INSTANCE, false){};
        Disposer.register((Disposable)this, (Disposable)this.myBuilder);
        this.myBuilder.setNodeDescriptorComparator(null);
        this.myBuilder.initRootNode();
        this.add((Component)this.myTree, "Center");
        this.myTree.addTreeExpansionListener(new TreeExpansionListener(){

            @Override
            public void treeExpanded(TreeExpansionEvent event) {
                SimpleNode simpleNode = DomModelTreeView.this.myTree.getNodeFor(event.getPath());
                if (simpleNode instanceof AbstractDomElementNode) {
                    ((AbstractDomElementNode)simpleNode).setExpanded(true);
                }
            }

            @Override
            public void treeCollapsed(TreeExpansionEvent event) {
                SimpleNode simpleNode = DomModelTreeView.this.myTree.getNodeFor(event.getPath());
                if (simpleNode instanceof AbstractDomElementNode) {
                    ((AbstractDomElementNode)simpleNode).setExpanded(false);
                    simpleNode.update();
                }
            }
        });
        this.myDomManager.addDomEventListener(new DomChangeAdapter(){

            @Override
            protected void elementChanged(DomElement element) {
                if (element.isValid()) {
                    DomModelTreeView.this.queueUpdate(DomUtil.getFile(element).getVirtualFile());
                } else if (element instanceof DomFileElement) {
                    XmlFile xmlFile = ((DomFileElement)element).getFile();
                    DomModelTreeView.this.queueUpdate(xmlFile.getVirtualFile());
                }
            }
        }, this);
        Project project = this.myDomManager.getProject();
        DomElementAnnotationsManager.getInstance(project).addHighlightingListener(new DomElementAnnotationsManager.DomHighlightingListener(){

            @Override
            public void highlightingFinished(@NotNull DomFileElement element) {
                if (element.isValid()) {
                    DomModelTreeView.this.queueUpdate(DomUtil.getFile(element).getVirtualFile());
                }
            }
        }, this);
        this.myTree.setPopupGroup(this.getPopupActions(), DOM_MODEL_TREE_VIEW_POPUP);
    }

    protected boolean isRightFile(VirtualFile file) {
        return this.myRootElement == null || this.myRootElement.isValid() && file.equals(DomUtil.getFile(this.myRootElement).getVirtualFile());
    }

    private void queueUpdate(VirtualFile file) {
        if (file == null) {
            return;
        }
        if (this.getProject().isDisposed()) {
            return;
        }
        ApplicationManager.getApplication().invokeLater(() -> {
            if (this.getProject().isDisposed()) {
                return;
            }
            if (!file.isValid() || this.isRightFile(file)) {
                this.myBuilder.updateFromRoot();
            }
        });
    }

    protected boolean isRootVisible() {
        return true;
    }

    public final void updateTree() {
        this.myBuilder.updateFromRoot();
    }

    public DomElement getRootElement() {
        return this.myRootElement;
    }

    protected final Project getProject() {
        return this.myDomManager.getProject();
    }

    public AbstractTreeBuilder getBuilder() {
        return this.myBuilder;
    }

    public void dispose() {
    }

    public SimpleTree getTree() {
        return this.myTree;
    }

    protected ActionGroup getPopupActions() {
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("DomElementsTreeView.TreePopup"));
        group.addSeparator();
        group.add((AnAction)new ExpandAllAction((JTree)this.myTree));
        group.add((AnAction)new CollapseAllAction((JTree)this.myTree));
        return group;
    }

    @Nullable
    public Object getData(@NotNull String dataId) {
        XmlElement tag;
        DomElement domElement;
        if (DATA_KEY.is(dataId)) {
            return this;
        }
        SimpleNode simpleNode = this.getTree().getSelectedNode();
        if (simpleNode instanceof AbstractDomElementNode && (domElement = ((AbstractDomElementNode)simpleNode).getDomElement()) != null && domElement.isValid() && CommonDataKeys.NAVIGATABLE.is(dataId) && (tag = domElement.getXmlElement()) instanceof Navigatable) {
            return tag;
        }
        return null;
    }

    public void setSelectedDomElement(DomElement domElement) {
        if (domElement == null) {
            return;
        }
        SimpleNode node = this.getNodeFor(domElement);
        if (node != null) {
            this.getTree().setSelectedNode(this.getBuilder(), node, true);
        }
    }

    @Nullable
    private SimpleNode getNodeFor(DomElement domElement) {
        return this.visit((SimpleNode)this.myBuilder.getTreeStructure().getRootElement(), domElement);
    }

    @Nullable
    private SimpleNode visit(SimpleNode simpleNode, DomElement domElement) {
        Object[] childElements;
        DomElement nodeElement;
        boolean validCandidate = false;
        if (simpleNode instanceof AbstractDomElementNode && (nodeElement = ((AbstractDomElementNode)simpleNode).getDomElement()) != null) {
            boolean bl = validCandidate = !(simpleNode instanceof DomElementsGroupNode);
            if (validCandidate && nodeElement.equals(domElement)) {
                return simpleNode;
            }
            if (!(nodeElement instanceof MergedObject) && !DomModelTreeView.isParent(nodeElement, domElement)) {
                return null;
            }
        }
        if ((childElements = this.myBuilder.getTreeStructure().getChildElements((Object)simpleNode)).length == 0 && validCandidate) {
            return simpleNode;
        }
        for (Object child : childElements) {
            SimpleNode result = this.visit((SimpleNode)child, domElement);
            if (result == null) continue;
            return result;
        }
        return validCandidate ? simpleNode : null;
    }

    private static boolean isParent(DomElement potentialParent, DomElement domElement) {
        for (DomElement currParent = domElement; currParent != null; currParent = currParent.getParent()) {
            if (!currParent.equals(potentialParent)) continue;
            return true;
        }
        return false;
    }
}

