/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.uast.test.common;

import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import java.util.ArrayList;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.uast.UElement;
import org.jetbrains.uast.UElementKt;
import org.jetbrains.uast.UFile;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010!\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\b\u0016\u0018\u00002\u00020\u0001B\u001b\u0012\u0014\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\u0002\u0010\u0006J\u001a\u0010\u0015\u001a\u00020\u00002\u0012\u0010\u0016\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u0003J\u0010\u0010\u0017\u001a\u00020\u00102\u0006\u0010\u0018\u001a\u00020\u0004H\u0014J\u0010\u0010\u0019\u001a\u00020\t2\u0006\u0010\u0018\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u00102\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R \u0010\u0007\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\t0\u00030\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\n\u001a\u00060\u000bj\u0002`\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u000f\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u001f\u0010\u0002\u001a\u0010\u0012\u0004\u0012\u00020\u0004\u0012\u0006\u0012\u0004\u0018\u00010\u00050\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006\u001d"}, d2={"Lorg/jetbrains/uast/test/common/UElementToParentMap;", "Lcom/intellij/psi/PsiElementVisitor;", "retriever", "Lkotlin/Function1;", "Lcom/intellij/psi/PsiElement;", "Lorg/jetbrains/uast/UElement;", "(Lkotlin/jvm/functions/Function1;)V", "additionalChecks", "", "", "builder", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "level", "", "result", "", "getResult", "()Ljava/lang/String;", "getRetriever", "()Lkotlin/jvm/functions/Function1;", "alsoCheck", "checker", "renderSource", "element", "visitElement", "visitUFileAndGetResult", "uFile", "Lorg/jetbrains/uast/UFile;", "intellij.platform.uast.tests"})
public class UElementToParentMap
extends PsiElementVisitor {
    private final StringBuilder builder;
    private int level;
    private final List<Function1<PsiElement, Unit>> additionalChecks;
    @NotNull
    private final Function1<PsiElement, UElement> retriever;

    public void visitElement(@NotNull PsiElement element) {
        int n;
        UElement uElement = (UElement)this.retriever.invoke((Object)element);
        if (uElement != null) {
            this.builder.append(StringsKt.repeat((CharSequence)"    ", (int)this.level));
            PsiElement psiElement = UElementKt.getSourcePsiElement((UElement)uElement);
            if (psiElement == null) {
                Intrinsics.throwNpe();
            }
            this.builder.append(psiElement.getText());
            this.builder.append(" -> ");
            UElement uElement2 = uElement.getUastParent();
            this.builder.append(uElement2 != null ? uElement2.asLogString() : null);
            this.builder.append(" from ");
            this.builder.append(this.renderSource(element));
            StringsKt.appendln((StringBuilder)this.builder);
        }
        if (element instanceof PsiCodeBlock) {
            n = this.level;
            this.level = n + 1;
        }
        element.acceptChildren((PsiElementVisitor)this);
        if (element instanceof PsiCodeBlock) {
            n = this.level;
            this.level = n + -1;
        }
    }

    @NotNull
    protected String renderSource(@NotNull PsiElement element) {
        return element.toString();
    }

    @NotNull
    public final UElementToParentMap alsoCheck(@NotNull Function1<? super PsiElement, Unit> checker) {
        this.additionalChecks.add(checker);
        return this;
    }

    @NotNull
    public final String getResult() {
        return this.builder.toString();
    }

    @NotNull
    public String visitUFileAndGetResult(@NotNull UFile uFile) {
        PsiElement psiElement = uFile.getSourcePsi();
        if (psiElement == null) {
            throw new TypeCastException("null cannot be cast to non-null type com.intellij.psi.PsiFile");
        }
        ((PsiFile)psiElement).accept((PsiElementVisitor)this);
        return this.getResult();
    }

    @NotNull
    public final Function1<PsiElement, UElement> getRetriever() {
        return this.retriever;
    }

    public UElementToParentMap(@NotNull Function1<? super PsiElement, ? extends UElement> retriever) {
        List list;
        this.retriever = retriever;
        this.builder = new StringBuilder();
        UElementToParentMap uElementToParentMap = this;
        uElementToParentMap.additionalChecks = list = (List)new ArrayList();
    }
}

