/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.google.api.client.repackaged.com.google.common.base.Strings;
import com.google.common.base.Charsets;
import com.google.common.collect.Sets;
import com.google.gct.login.GoogleLogin;
import com.google.services.firebase.DataSharingSetting;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.FirebaseConnectStateManager;
import com.google.services.firebase.config.AndroidClient;
import com.google.services.firebase.config.FirebaseConfig;
import com.google.services.firebase.config.FirebaseLocalConfig;
import com.google.services.firebase.mobilesdk.MobileSdkCommException;
import com.google.services.firebase.mobilesdk.MobileSdkUtil;
import com.google.services.firebase.mobilesdk.MobileSdkWrapper;
import com.google.services.firebase.mobilesdk.MobileSdkWrapperImpl;
import com.google.services.firebase.mobilesdk.OnlineProject;
import com.google.services.firebase.view.FirebaseUiUtils;
import com.google.wireless.android.sdk.stats.AndroidStudioEvent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConnectFirebaseTask
extends Task.Backgroundable {
    public static final String DEFAULT_ANDROID_DEBUG_BUILD_TYPE = "debug";
    private Module myAndroidModule;
    private Project myIdeaProject;
    private String myRegionCode;
    private int myTimeZoneId;
    private DataSharingSetting myDataSharingEnabledUpgradeSetting;
    private String myNewProjectDisplayName;
    private OnlineProject myOnlineProjectToUpdate;
    private ProgressIndicator myProgressIndicator;
    private FirebaseConfig myFirebaseConfig;

    public ConnectFirebaseTask(@NotNull Module androidModule, @NotNull FirebaseConfig config, @NotNull String newProjectDisplayName, @NotNull String regionCode, int timeZoneId, boolean acceptTos) {
        this(androidModule, config, newProjectDisplayName, null, regionCode, timeZoneId, acceptTos, DataSharingSetting.SET_SHARE);
    }

    public ConnectFirebaseTask(@NotNull Module androidModule, @NotNull FirebaseConfig config, @NotNull OnlineProject onlineProjectToUpdate, @NotNull String regionCode, int timeZoneId, boolean acceptTos, @NotNull DataSharingSetting dataSharingEnabledOnUpgrade) {
        this(androidModule, config, null, onlineProjectToUpdate, regionCode, timeZoneId, acceptTos, dataSharingEnabledOnUpgrade);
        if (dataSharingEnabledOnUpgrade == DataSharingSetting.UNSET && onlineProjectToUpdate.isRequiredFirebaseMigration()) {
            throw new IllegalArgumentException("Must specify a data sharing value when the project requires an upgrade to Firebase");
        }
    }

    private ConnectFirebaseTask(@NotNull Module androidModule, @NotNull FirebaseConfig config, @Nullable String newProjectDisplayName, @Nullable OnlineProject onlineProjectToUpdate, @NotNull String regionCode, int timeZoneId, boolean acceptTos, @NotNull DataSharingSetting dataSharingEnabledOnUpgrade) {
        super(androidModule.getProject(), FirebaseBundle.message("firebase.service.action.label.connect.action", new Object[0]));
        if (acceptTos && !ConnectFirebaseTask.acceptTos(androidModule.getProject())) {
            return;
        }
        ConnectFirebaseTask.validateRegionCodeAndTimeZoneId(regionCode, timeZoneId);
        if (newProjectDisplayName == null & onlineProjectToUpdate == null) {
            throw new IllegalStateException("Either a new project display name is specified or an existing project is updated.");
        }
        try {
            FirebaseUiUtils.checkGradleState(androidModule);
        }
        catch (FirebaseUiUtils.GradleStateException exception) {
            throw new IllegalStateException(FirebaseBundle.message("firebaseService.userError.gradleSyncNeeded", new Object[0]), exception);
        }
        this.myAndroidModule = androidModule;
        this.myIdeaProject = this.myAndroidModule.getProject();
        this.myOnlineProjectToUpdate = onlineProjectToUpdate;
        this.myRegionCode = regionCode;
        this.myTimeZoneId = timeZoneId;
        this.myNewProjectDisplayName = newProjectDisplayName;
        this.myFirebaseConfig = config;
        this.myDataSharingEnabledUpgradeSetting = dataSharingEnabledOnUpgrade;
    }

    private static Logger getLog() {
        return Logger.getInstance(ConnectFirebaseTask.class);
    }

    private static void downloadAndWriteAndroidConfig(@NotNull Module androidApplicationModule, @NotNull String projectNumber, @NotNull MobileSdkWrapper mobileSdkWrapper) throws MobileSdkCommException, IOException {
        String config = mobileSdkWrapper.getFirebaseConfigurationData(projectNumber);
        File moduleDir = new File(androidApplicationModule.getModuleFilePath());
        File jsonFile = new File(moduleDir.getParent(), "google-services.json");
        ConnectFirebaseTask.getLog().info("Firebase config to be written to: " + jsonFile.getAbsolutePath());
        try (FileOutputStream fos = new FileOutputStream(jsonFile);){
            fos.write(config.getBytes(Charsets.UTF_8));
        }
        catch (IOException exception) {
            ConnectFirebaseTask.getLog().error("Couldn't write downloaded Firebase configuration to file system", (Throwable)exception);
            throw new IOException(FirebaseBundle.message("firebaseConnectAction.userError.couldNotWriteConfig", jsonFile.getAbsolutePath()), exception);
        }
    }

    private static void validateRegionCodeAndTimeZoneId(String regionCode, int timeZoneId) {
        if (Strings.isNullOrEmpty((String)regionCode)) {
            throw new IllegalStateException(FirebaseBundle.message("firebaseService.internalError.invalidRegionCode", regionCode));
        }
        if (timeZoneId <= 0) {
            throw new IllegalStateException(FirebaseBundle.message("firebaseService.internalError.invalidTimeZoneId", timeZoneId));
        }
    }

    private void updateProgress(@NotNull String message, double progressPercentage) {
        this.myProgressIndicator.setFraction(progressPercentage);
        ConnectFirebaseTask.getLog().info(message);
        this.myProgressIndicator.setText(message);
    }

    public void run(@NotNull ProgressIndicator progressIndicator) {
        FirebaseConfig newFirebaseConfig;
        List<OnlineProject> existingProjects;
        MobileSdkWrapper apiStub;
        this.myProgressIndicator = progressIndicator;
        GoogleLogin googleLogin = GoogleLogin.getInstance();
        try {
            apiStub = MobileSdkUtil.getNewMobileSdkWrapper(googleLogin);
        }
        catch (MobileSdkCommException exception) {
            FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
            return;
        }
        if (this.myOnlineProjectToUpdate == null) {
            this.updateProgress("Starting project creation", 0.1);
            try {
                this.myOnlineProjectToUpdate = apiStub.createNewProject(this.myNewProjectDisplayName, this.myRegionCode, this.myTimeZoneId);
                new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_CREATED).withOnlineProject(this.myOnlineProjectToUpdate).withProject(this.myIdeaProject).log();
            }
            catch (MobileSdkCommException exception) {
                new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_CREATE_FAILED).withProject(this.myIdeaProject).log();
                String errorMessage = FirebaseBundle.message("firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]) + " " + FirebaseBundle.message("firebaseConnectAction.userError.incompleteProjectCreated", new Object[0]);
                FirebaseUiUtils.showErrorBalloon(this.myIdeaProject, errorMessage, exception);
                return;
            }
            this.updateProgress("Project created", 0.15);
        }
        if (this.myOnlineProjectToUpdate.isRequiredFirebaseMigration()) {
            this.updateProgress("Starting online project update", 0.2);
            try {
                this.myOnlineProjectToUpdate = apiStub.upgradeExistingProject(this.myOnlineProjectToUpdate, this.myRegionCode, this.myTimeZoneId, DataSharingSetting.SET_SHARE == this.myDataSharingEnabledUpgradeSetting);
                new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_UPGRADED).withOnlineProject(this.myOnlineProjectToUpdate).withProject(this.myIdeaProject).log();
            }
            catch (MobileSdkWrapperImpl.InsufficientPermissionsException exception) {
                new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_UPDATE_DENIED).withProject(this.myIdeaProject).log();
                FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, exception, "mobileSdkService.userError.insufficientPermissions403", new Object[0]);
                return;
            }
            catch (MobileSdkCommException exception) {
                new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_UPGRADE_FAILED).withProject(this.myIdeaProject).log();
                FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
                return;
            }
            this.updateProgress("Online project updated", 0.25);
        }
        this.updateProgress("Determining Android clients to create", 0.4);
        try {
            existingProjects = apiStub.getExistingProjects();
        }
        catch (MobileSdkCommException exception) {
            FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
            return;
        }
        try {
            newFirebaseConfig = new FirebaseConfig(this.myAndroidModule, existingProjects);
        }
        catch (FirebaseLocalConfig.InvalidLocalConfigException exception) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_CONFIG_CREATE_FAILED).withOnlineProject(this.myOnlineProjectToUpdate).withProject(this.myIdeaProject).log();
            FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, (Throwable)((Object)exception), "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
            return;
        }
        Set<AndroidClient> clientsDisplayedOnDialog = this.myFirebaseConfig.getRegisterableAndroidClients();
        HashSet clientsToCreate = Sets.newHashSet();
        clientsToCreate.addAll(newFirebaseConfig.getRegisterableAndroidClients());
        clientsToCreate.retainAll(clientsDisplayedOnDialog);
        ConnectFirebaseTask.getLog().info("Clients found to register: " + clientsToCreate.size());
        this.updateProgress("Determined Android clients", 0.45);
        this.updateProgress(FirebaseBundle.message("firebase.service.notification.connect.process.registering.clients", new Object[0]), 0.6);
        try {
            int currentClients = this.myOnlineProjectToUpdate.getNumAndroidOAuth2Clients();
            boolean disableDataSharingForClients = !this.myOnlineProjectToUpdate.isProjectDataSharingEnabled();
            this.myOnlineProjectToUpdate = apiStub.updateExistingProject(this.myOnlineProjectToUpdate.getProjectNumber(), disableDataSharingForClients, clientsToCreate);
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_UPDATED).withOnlineProject(this.myOnlineProjectToUpdate).withProject(this.myIdeaProject).log();
            if (newFirebaseConfig.getConnectedOnlineProjects().isEmpty() && this.myOnlineProjectToUpdate.getNumAndroidOAuth2Clients() == currentClients) {
                FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, null, "mobileSdkService.userError.noClientsCreated", String.join((CharSequence)"<br><br>", this.myOnlineProjectToUpdate.getWarningMessages()));
                return;
            }
        }
        catch (MobileSdkCommException exception) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_UPDATE_FAILED).withOnlineProject(this.myOnlineProjectToUpdate).withProject(this.myIdeaProject).log();
            FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
            return;
        }
        for (String warningMessage : this.myOnlineProjectToUpdate.getWarningMessages()) {
            FirebaseUiUtils.showWarningBalloon(this.myIdeaProject, warningMessage, null);
        }
        this.updateProgress(FirebaseBundle.message("firebase.service.notification.connect.process.downloading.config", new Object[0]), 0.8);
        try {
            ConnectFirebaseTask.downloadAndWriteAndroidConfig(this.myAndroidModule, this.myOnlineProjectToUpdate.getProjectNumber(), apiStub);
        }
        catch (MobileSdkCommException | IOException exception) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_PROJECT_CONFIG_WRITE_FAILED).withOnlineProject(this.myOnlineProjectToUpdate).withProject(this.myIdeaProject).log();
            FirebaseUiUtils.showTrackedErrorBalloon(this.myIdeaProject, exception, "firebaseConnectAction.userError.connectToFirebaseFailed", new Object[0]);
            return;
        }
        this.updateProgress(FirebaseBundle.message("firebase.service.notification.connect.process.downloading.config", new Object[0]), 0.85);
        String completeMessage = FirebaseBundle.message("firebase.service.notification.connect.process.complete", this.myAndroidModule.getName());
        this.updateProgress(completeMessage, 1.0);
        FirebaseUiUtils.showInfoBalloon(this.myIdeaProject, completeMessage, null);
        FirebaseConnectStateManager.setCompletableState(this.myAndroidModule, false);
    }

    private static boolean acceptTos(Project project) {
        try {
            MobileSdkWrapper mobileSdkWrapper = MobileSdkUtil.getNewMobileSdkWrapper(GoogleLogin.getInstance());
            mobileSdkWrapper.acceptTermsOfService("en-US");
        }
        catch (MobileSdkCommException exception) {
            new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_TOS_FAILED).withProject(project).log();
            FirebaseUiUtils.showTrackedErrorBalloon(project, exception, FirebaseBundle.message("firebaseConnectAction.userError.connectToFirebaseFailed.acceptTos", new Object[0]), new Object[0]);
            return false;
        }
        new FirebaseAnalyticsProvider.Logger(AndroidStudioEvent.EventKind.FIREBASE_ASSISTANT_TOS_ACCEPTED).withProject(project).log();
        return true;
    }
}

