/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.RecipeMetadata;
import com.android.tools.idea.assistant.RecipeUtils;
import com.android.tools.idea.assistant.datamodel.ActionData;
import com.android.tools.idea.assistant.view.UIUtils;
import com.android.tools.idea.gradle.dsl.api.GradleBuildModel;
import com.android.tools.idea.gradle.project.GradleProjectInfo;
import com.android.tools.idea.templates.recipe.Recipe;
import com.google.services.firebase.DependencyStateManager;
import com.google.services.firebase.FirebaseBundle;
import com.google.services.firebase.view.ModuleComboBox;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBPanel;
import com.intellij.util.ui.JBInsets;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DependencyDialog
extends DialogWrapper {
    private final ProjectChangesPanel myContentPanel;
    private Module mySelectedModule;
    private List<String> myDependenciesToBeApplied = new ArrayList<String>();

    DependencyDialog(@NotNull ActionData actionData, @NotNull Project project) {
        super(project, false);
        List modules = GradleProjectInfo.getInstance((Project)project).getAndroidModules();
        if (modules.size() == 1) {
            this.mySelectedModule = (Module)modules.iterator().next();
        } else {
            this.setOKActionEnabled(false);
        }
        this.myContentPanel = new ProjectChangesPanel(actionData, modules);
        this.myContentPanel.setLayout(new BoxLayout((Container)((Object)this.myContentPanel), 1));
        this.init();
        this.setTitle(actionData.getLabel());
        Action okAction = this.getOKAction();
        okAction.putValue("Name", "Accept Changes");
    }

    @NotNull
    public List<String> getDependenciesToBeApplied() {
        return Collections.unmodifiableList(this.myDependenciesToBeApplied);
    }

    @NotNull
    public Module getModule() {
        return this.mySelectedModule;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        return this.myContentPanel;
    }

    public class ProjectChangesPanel
    extends JBPanel {
        private Project myProject;
        private ComboBox myModuleBox;
        private JBPanel myProposedChangesPanel;
        private RecipeMetadata mySampleMetadata;
        private List<RecipeMetadata> myMetadataList;
        private RecipeMetadata mySelectedMetadata;

        public ProjectChangesPanel(@NotNull ActionData actionData, List<Module> modules) {
            if (actionData.getRecipe() == null) {
                this.getLog().error("Missing dependency configuration data for: " + actionData);
                return;
            }
            Module sampleModule = modules.iterator().next();
            this.myProject = sampleModule.getProject();
            this.myMetadataList = RecipeUtils.getRecipeMetadata((Recipe)actionData.getRecipe(), (Project)this.myProject);
            this.mySampleMetadata = this.myMetadataList.get(0);
            if (DependencyDialog.this.mySelectedModule == null) {
                JPanel moduleWrapper = new JPanel(new FlowLayout(0, 0, 5));
                moduleWrapper.setOpaque(false);
                JBLabel moduleLabel = new JBLabel(FirebaseBundle.message("dependencies.add.selectModule.label", new Object[0]));
                moduleLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
                moduleWrapper.add((Component)moduleLabel);
                ArrayList<Module> incompleteModules = new ArrayList<Module>();
                if (DependencyStateManager.getPendingClasspaths(this.myProject, this.mySampleMetadata).isEmpty()) {
                    for (RecipeMetadata metadata : this.myMetadataList) {
                        Module module = metadata.getModule();
                        if (!DependencyStateManager.getPendingPlugins(metadata).isEmpty()) {
                            incompleteModules.add(module);
                            continue;
                        }
                        if (DependencyStateManager.getPendingDependencies(metadata, GradleBuildModel.get((Module)module)).isEmpty()) continue;
                        incompleteModules.add(module);
                    }
                } else {
                    incompleteModules.addAll(modules);
                }
                this.myModuleBox = new ModuleComboBox(incompleteModules);
                moduleWrapper.add((Component)this.myModuleBox);
                moduleWrapper.setAlignmentX(0.0f);
                this.add(moduleWrapper);
                this.myModuleBox.addActionListener(this::selectModule);
            }
            this.updateMutableView();
        }

        private void updateMutableView() {
            List<String> pluginsToApply;
            if (this.myProposedChangesPanel != null) {
                this.remove((Component)this.myProposedChangesPanel);
                this.revalidate();
                this.repaint();
            }
            this.myProposedChangesPanel = new JBPanel();
            this.myProposedChangesPanel.setLayout((LayoutManager)new BoxLayout((Container)this.myProposedChangesPanel, 1));
            List<String> classpathEntriesToAdd = DependencyStateManager.getPendingClasspaths(this.myProject, this.mySampleMetadata);
            if (DependencyDialog.this.mySelectedModule != null) {
                for (RecipeMetadata metadata : this.myMetadataList) {
                    if (!metadata.getModule().equals(DependencyDialog.this.mySelectedModule)) continue;
                    this.mySelectedMetadata = metadata;
                }
            }
            GradleBuildModel gradleBuildModel = null;
            if (this.mySelectedMetadata == null) {
                pluginsToApply = this.mySampleMetadata.getPlugins();
                DependencyDialog.this.myDependenciesToBeApplied = this.mySampleMetadata.getDependencies();
            } else {
                pluginsToApply = DependencyStateManager.getPendingPlugins(this.mySelectedMetadata);
                gradleBuildModel = GradleBuildModel.get((Module)this.mySelectedMetadata.getModule());
                DependencyDialog.this.myDependenciesToBeApplied = DependencyStateManager.getPendingDependencies(this.mySelectedMetadata, gradleBuildModel);
            }
            JLabel summary = new JLabel();
            summary.setOpaque(false);
            summary.setBorder(BorderFactory.createEmptyBorder(0, 0, 10, 0));
            summary.setText(FirebaseBundle.message("dependencies.add.preface", new Object[0]));
            summary.setAlignmentX(0.0f);
            this.myProposedChangesPanel.add((Component)summary);
            StringBuilder detailsBuilder = new StringBuilder();
            String detailsCss = ".dependency { color: green; font-weight: bold; font-family: monospace; }\nbody {padding: 10px; }";
            String indent_1 = "    ";
            String indent_2 = "        ";
            if (!classpathEntriesToAdd.isEmpty()) {
                detailsBuilder.append("<pre><b>build.gradle (project-level)</b>\n\n").append(indent_1).append("Add Firebase Gradle buildscript dependency\n");
                for (String string : classpathEntriesToAdd) {
                    detailsBuilder.append(indent_2).append("classpath <font class=\"dependency\">'").append(string).append("'</font>\n");
                }
                detailsBuilder.append("</pre>");
                detailsBuilder.append("<div style=\"height: 1px; font-size: 0; background: #cccccc;\"></div><br>");
            }
            detailsBuilder.append("<pre><b>app/build.gradle</b>\n\n");
            if (!pluginsToApply.isEmpty()) {
                detailsBuilder.append(indent_1).append("Add Firebase plugin for Gradle\n");
                for (String string : pluginsToApply) {
                    detailsBuilder.append(indent_2).append("apply plugin: <font class=\"dependency\">'").append(string).append("'</font>\n");
                }
                detailsBuilder.append("\n");
            }
            boolean hasAnalytics = false;
            if (!DependencyDialog.this.myDependenciesToBeApplied.isEmpty()) {
                detailsBuilder.append(indent_1).append("<b>build.gradle</b> will include these new dependencies:\n");
                for (String dependency : DependencyDialog.this.myDependenciesToBeApplied) {
                    detailsBuilder.append(indent_2).append("compile <font class=\"dependency\">'").append(dependency).append("'</font>\n");
                    hasAnalytics |= dependency.contains("firebase-core");
                }
            }
            detailsBuilder.append("</pre>");
            JTextPane jTextPane = new JTextPane();
            UIUtils.setHtml((JEditorPane)jTextPane, (String)detailsBuilder.toString(), (String)detailsCss);
            jTextPane.setBackground(UIUtils.getBackgroundColor());
            jTextPane.setMargin((Insets)new JBInsets(10, 10, 10, 10));
            jTextPane.setBorder(BorderFactory.createMatteBorder(1, 1, 1, 1, UIUtils.getSeparatorColor()));
            jTextPane.setAlignmentX(0.0f);
            this.myProposedChangesPanel.add((Component)jTextPane);
            if (!hasAnalytics && gradleBuildModel != null) {
                hasAnalytics = DependencyStateManager.hasAnalytics(gradleBuildModel);
            }
            if (!hasAnalytics) {
                JTextPane analyticsWarning = new JTextPane();
                analyticsWarning.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
                UIUtils.setHtml((JEditorPane)analyticsWarning, (String)FirebaseBundle.message("dependencies.add.analyticsWarning", new Object[0]));
                analyticsWarning.setAlignmentX(0.0f);
                this.myProposedChangesPanel.add((Component)analyticsWarning);
            }
            this.add((Component)this.myProposedChangesPanel);
            DependencyDialog.this.pack();
        }

        void selectModule(ActionEvent e) {
            DependencyDialog.this.mySelectedModule = (Module)this.myModuleBox.getSelectedItem();
            this.updateMutableView();
            DependencyDialog.this.setOKActionEnabled(true);
        }

        private Logger getLog() {
            return Logger.getInstance(ProjectChangesPanel.class);
        }
    }
}

