/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.tools.idea.assistant.AssistantBundleCreator;
import com.android.tools.idea.assistant.DefaultTutorialBundle;
import com.android.tools.idea.assistant.datamodel.AnalyticsProvider;
import com.android.tools.idea.assistant.datamodel.TutorialBundleData;
import com.google.services.firebase.FirebaseAnalyticsProvider;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.bind.JAXBException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FirebaseBundleCreator
implements AssistantBundleCreator {
    private static final String TUTORIAL_CONFIG_FILENAME = "/firebase_tutorial_bundle.xml";
    private DefaultTutorialBundle myBundle = null;

    private static Logger getLog() {
        return Logger.getInstance(FirebaseBundleCreator.class);
    }

    @NotNull
    public String getBundleId() {
        return "DeveloperServices.Firebase";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public TutorialBundleData getBundle(@NotNull Project project) {
        if (this.myBundle != null) {
            return this.myBundle;
        }
        URL resource = this.getClass().getResource(TUTORIAL_CONFIG_FILENAME);
        if (resource == null) {
            throw new RuntimeException(String.format("Could not find service file %1$s", TUTORIAL_CONFIG_FILENAME));
        }
        InputStream inputStream = null;
        try {
            String replacementBundlePath = System.getProperty("firebase.tutorialbundle");
            if (replacementBundlePath != null) {
                File bundleFile = new File(replacementBundlePath);
                if (!bundleFile.exists()) {
                    throw new RuntimeException(String.format("Could not find service file replaced by properties %1$s", replacementBundlePath));
                }
                inputStream = new FileInputStream(bundleFile);
            }
            if (inputStream == null) {
                inputStream = resource.openStream();
            }
            this.myBundle = (DefaultTutorialBundle)DefaultTutorialBundle.parse((InputStream)inputStream, DefaultTutorialBundle.class);
        }
        catch (IOException | JAXBException e) {
            FirebaseBundleCreator.getLog().error("Unable to parse /firebase_tutorial_bundle.xml to read services configuration.", e);
        }
        finally {
            try {
                if (inputStream != null) {
                    inputStream.close();
                }
            }
            catch (Exception e) {
                FirebaseBundleCreator.getLog().warn((Throwable)e);
            }
        }
        return this.myBundle;
    }

    @Nullable
    public URL getConfig() {
        return null;
    }

    @NotNull
    public AnalyticsProvider getAnalyticsProvider() {
        return new FirebaseAnalyticsProvider();
    }
}

