/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase;

import com.android.ddmlib.ClientData;
import com.android.ddmlib.Log;
import com.android.tools.idea.logcat.AndroidLogcatFilter;
import com.android.tools.idea.logcat.LogcatFilterProvider;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class FirebaseLogcatFilterProvider
implements LogcatFilterProvider {
    private static final AndroidLogcatFilter FILTER = new FirebaseLogcatFilter();

    @NotNull
    public AndroidLogcatFilter getFilter(@Nullable ClientData client) {
        return FILTER;
    }

    private static class FirebaseLogcatFilter
    implements AndroidLogcatFilter {
        private static final Pattern TAG_PATTERN = Pattern.compile("FA|FirebaseRemoteConfig|StorageTask|NetworkRequest|Connection|PersistentConnection|WebSocket|RunLoop|Persistence|BackgroundTask|RepoOperation|Transaction|DataOperation|SyncTree|EventRaiser|FirebaseDatabase|ClassMapper|FirebaseMessaging|FirebaseInstanceId|AppInviteAgent|AppInstallOperation|AppInviteLogger|AppInviteAnalytics|AppInviteActivity|FirebaseAppIndex");

        private FirebaseLogcatFilter() {
        }

        @NotNull
        public String getName() {
            return "Firebase";
        }

        public boolean isApplicable(@NotNull String message, @NotNull String tag, @NotNull String pkg, int pid, @NotNull Log.LogLevel logLevel) {
            return TAG_PATTERN.matcher(tag).find();
        }
    }
}

