/*
 * Decompiled with CFR 0.152.
 */
package com.google.services.firebase.logs;

import com.android.ddmlib.IDevice;
import com.android.ddmlib.IShellOutputReceiver;
import com.android.ddmlib.NullOutputReceiver;
import com.android.ddmlib.logcat.LogCatMessage;
import com.android.tools.idea.logcat.AndroidLogcatService;
import com.android.tools.idea.run.ConsolePrinter;
import com.android.tools.idea.run.tasks.LaunchTask;
import com.android.tools.idea.run.util.LaunchStatus;
import com.google.common.collect.ImmutableList;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class FirebaseLogTask
implements LaunchTask {
    private static final String ID = "FIREBASE_LOG";
    private final FirebaseLogcatListener myLogLineListener = new FirebaseLogcatListener();
    private final String myApplicationId;
    public static final List<String> FIREBASE_TAGS = ImmutableList.of((Object)"FirebaseApp", (Object)"GoogleAuthUtil", (Object)"InstanceID/Store", (Object)"FirebaseRemoteConfig");

    FirebaseLogTask(@NotNull String applicationId) {
        this.myApplicationId = applicationId;
    }

    @NotNull
    public String getDescription() {
        return "Setting Firebase Log Properties on the device";
    }

    public int getDuration() {
        return 1;
    }

    public boolean perform(@NotNull IDevice device, @NotNull LaunchStatus launchStatus, @NotNull ConsolePrinter printer) {
        ApplicationManager.getApplication().executeOnPooledThread(() -> {
            try {
                NullOutputReceiver receiver = new NullOutputReceiver();
                device.executeShellCommand("setprop log.tag.FA VERBOSE", (IShellOutputReceiver)receiver);
                device.executeShellCommand("setprop log.tag.FA-SVC VERBOSE", (IShellOutputReceiver)receiver);
            }
            catch (Exception exception) {
                // empty catch block
            }
        });
        AndroidLogcatService.getInstance().addListener(device, (AndroidLogcatService.LogcatListener)this.myLogLineListener);
        return true;
    }

    @NotNull
    public String getId() {
        return ID;
    }

    private static Logger getLog() {
        return Logger.getInstance(FirebaseLogTask.class);
    }

    private static class FirebaseLogcatListener
    implements AndroidLogcatService.LogcatListener {
        private FirebaseLogcatListener() {
        }

        public void onLogLineReceived(@NotNull LogCatMessage line) {
            String tag = line.getTag();
            if (!FIREBASE_TAGS.contains(tag)) {
                return;
            }
            FirebaseLogTask.getLog().info("Processing Firebase log with tag " + tag);
        }
    }
}

