/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.actions.context;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.fileEditor.FileEditorManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.tasks.actions.BaseTaskAction;
import com.intellij.tasks.context.WorkingContextManager;
import org.jetbrains.annotations.NotNull;

public class SaveContextAction
extends BaseTaskAction {
    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = SaveContextAction.getProject(e);
        SaveContextAction.saveContext(project);
    }

    public static void saveContext(Project project) {
        String comment;
        PsiFile file;
        String initial = null;
        Editor textEditor = FileEditorManager.getInstance((Project)project).getSelectedTextEditor();
        if (textEditor != null && (file = PsiDocumentManager.getInstance((Project)project).getPsiFile(textEditor.getDocument())) != null) {
            initial = file.getName();
        }
        if ((comment = Messages.showInputDialog((Project)project, (String)"Enter comment (optional):", (String)"Save Context", null, initial, null)) != null) {
            WorkingContextManager.getInstance((Project)project).saveContext(null, StringUtil.isEmpty((String)comment) ? null : comment);
        }
    }
}

