/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.config;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.SearchableConfigurable;
import com.intellij.openapi.options.binding.BindControl;
import com.intellij.openapi.options.binding.BindableConfigurable;
import com.intellij.openapi.options.binding.ControlBinder;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.ui.popup.ListPopupStep;
import com.intellij.openapi.ui.popup.PopupStep;
import com.intellij.openapi.ui.popup.util.BaseListPopupStep;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.tasks.CommitPlaceholderProvider;
import com.intellij.tasks.TaskManager;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.config.TaskRepositoriesConfigurable;
import com.intellij.tasks.config.TaskSettings;
import com.intellij.tasks.impl.BaseRepositoryImpl;
import com.intellij.tasks.impl.TaskManagerImpl;
import com.intellij.ui.EditorTextField;
import com.intellij.ui.ExtendableEditorSupport;
import com.intellij.ui.GuiUtils;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.fields.ExtendableTextComponent;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.ArrayUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.HashSet;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TaskConfigurable
extends BindableConfigurable
implements SearchableConfigurable.Parent,
Configurable.NoScroll {
    private JPanel myPanel;
    @BindControl(value="updateEnabled")
    private JCheckBox myUpdateCheckBox;
    @BindControl(value="updateIssuesCount")
    private JTextField myUpdateCount;
    @BindControl(value="updateInterval")
    private JTextField myUpdateInterval;
    @BindControl(value="taskHistoryLength")
    private JTextField myHistoryLength;
    private JPanel myCacheSettings;
    @BindControl(value="saveContextOnCommit")
    private JCheckBox mySaveContextOnCommit;
    @BindControl(value="changelistNameFormat")
    private EditorTextField myChangelistNameFormat;
    private JBCheckBox myAlwaysDisplayTaskCombo;
    private JTextField myConnectionTimeout;
    @BindControl(value="branchNameFormat")
    private EditorTextField myBranchNameFormat;
    private JCheckBox myLowerCase;
    private final Project myProject;
    private Configurable[] myConfigurables;
    private final NotNullLazyValue<ControlBinder> myControlBinder;

    public TaskConfigurable(Project project) {
        this.$$$setupUI$$$();
        this.myControlBinder = new NotNullLazyValue<ControlBinder>(){

            @NotNull
            protected ControlBinder compute() {
                return new ControlBinder((Object)TaskConfigurable.this.getConfig());
            }
        };
        this.myProject = project;
        this.myUpdateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TaskConfigurable.this.enableCachePanel();
            }
        });
    }

    private TaskManagerImpl.Config getConfig() {
        return ((TaskManagerImpl)TaskManager.getManager((Project)this.myProject)).getState();
    }

    protected ControlBinder getBinder() {
        return (ControlBinder)this.myControlBinder.getValue();
    }

    private void enableCachePanel() {
        GuiUtils.enableChildren((Component)this.myCacheSettings, (boolean)this.myUpdateCheckBox.isSelected(), (JComponent[])new JComponent[0]);
    }

    public void reset() {
        super.reset();
        this.enableCachePanel();
        this.myAlwaysDisplayTaskCombo.setSelected(TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO);
        this.myConnectionTimeout.setText(Integer.toString(TaskSettings.getInstance().CONNECTION_TIMEOUT));
        this.myLowerCase.setSelected(TaskSettings.getInstance().LOWER_CASE_BRANCH);
    }

    public void apply() throws ConfigurationException {
        if (this.myChangelistNameFormat.getText().trim().isEmpty()) {
            throw new ConfigurationException("Change list name format should not be empty");
        }
        if (this.myBranchNameFormat.getText().trim().isEmpty()) {
            throw new ConfigurationException("Branch name format should not be empty");
        }
        boolean oldUpdateEnabled = this.getConfig().updateEnabled;
        super.apply();
        TaskManager manager = TaskManager.getManager((Project)this.myProject);
        if (this.getConfig().updateEnabled && !oldUpdateEnabled) {
            manager.updateIssues(null);
        }
        TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO = this.myAlwaysDisplayTaskCombo.isSelected();
        int oldConnectionTimeout = TaskSettings.getInstance().CONNECTION_TIMEOUT;
        Integer connectionTimeout = Integer.valueOf(this.myConnectionTimeout.getText());
        TaskSettings.getInstance().CONNECTION_TIMEOUT = connectionTimeout;
        TaskSettings.getInstance().LOWER_CASE_BRANCH = this.myLowerCase.isSelected();
        if (connectionTimeout != oldConnectionTimeout) {
            for (TaskRepository repository : manager.getAllRepositories()) {
                if (!(repository instanceof BaseRepositoryImpl)) continue;
                ((BaseRepositoryImpl)repository).reconfigureClient();
            }
        }
    }

    public boolean isModified() {
        return super.isModified() || TaskSettings.getInstance().ALWAYS_DISPLAY_COMBO != this.myAlwaysDisplayTaskCombo.isSelected() || TaskSettings.getInstance().CONNECTION_TIMEOUT != Integer.valueOf(this.myConnectionTimeout.getText()) || TaskSettings.getInstance().LOWER_CASE_BRANCH != this.myLowerCase.isSelected();
    }

    @Nls
    public String getDisplayName() {
        return "Tasks";
    }

    public String getHelpTopic() {
        return "reference.settings.project.tasks";
    }

    public JComponent createComponent() {
        this.bindAnnotations();
        return this.myPanel;
    }

    @NotNull
    public String getId() {
        return "tasks";
    }

    public boolean hasOwnContent() {
        return true;
    }

    @NotNull
    public Configurable[] getConfigurables() {
        if (this.myConfigurables == null) {
            this.myConfigurables = new Configurable[]{new TaskRepositoriesConfigurable(this.myProject)};
        }
        return this.myConfigurables;
    }

    private void createUIComponents() {
        FileType fileType = FileTypeManager.getInstance().findFileTypeByName("VTL");
        if (fileType == null) {
            fileType = PlainTextFileType.INSTANCE;
        }
        Project project = ProjectManager.getInstance().getDefaultProject();
        this.myBranchNameFormat = new EditorTextField(project, fileType);
        this.setupAddAction(this.myBranchNameFormat);
        this.myChangelistNameFormat = new EditorTextField(project, fileType);
        this.setupAddAction(this.myChangelistNameFormat);
    }

    private void setupAddAction(EditorTextField field) {
        field.addSettingsProvider(editor -> {
            ExtendableTextComponent.Extension extension = ExtendableTextComponent.Extension.create((Icon)AllIcons.General.InlineAdd, (Icon)AllIcons.General.InlineAddHover, (String)"Add placeholder", () -> {
                HashSet<String> placeholders = new HashSet<String>();
                for (CommitPlaceholderProvider provider : CommitPlaceholderProvider.EXTENSION_POINT_NAME.getExtensionList()) {
                    placeholders.addAll(Arrays.asList(provider.getPlaceholders(null)));
                }
                JBPopupFactory.getInstance().createListPopup((ListPopupStep)new BaseListPopupStep<String>("Placeholders", ArrayUtil.toStringArray(placeholders)){

                    public PopupStep onChosen(String selectedValue, boolean finalChoice) {
                        WriteCommandAction.runWriteCommandAction((Project)TaskConfigurable.this.myProject, () -> editor.getDocument().insertString(editor.getCaretModel().getOffset(), (CharSequence)("${" + selectedValue + "}")));
                        return FINAL_CHOICE;
                    }
                }).showInBestPositionFor((Editor)editor);
            });
            ExtendableEditorSupport.setupExtension((EditorEx)editor, (Color)field.getBackground(), (ExtendableTextComponent.Extension)extension);
        });
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JCheckBox jCheckBox;
        JTextField jTextField;
        JTextField jTextField2;
        JCheckBox jCheckBox2;
        JPanel jPanel;
        JTextField jTextField3;
        JBCheckBox jBCheckBox;
        JCheckBox jCheckBox3;
        JTextField jTextField4;
        JPanel jPanel2;
        this.createUIComponents();
        this.myPanel = jPanel2 = new JPanel();
        jPanel2.setLayout((LayoutManager)new GridLayoutManager(9, 3, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myHistoryLength = jTextField4 = new JTextField();
        jTextField4.setText("11");
        jPanel2.add((Component)jTextField4, new GridConstraints(3, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null));
        JLabel jLabel = new JLabel();
        jLabel.setText("Task history length:");
        jLabel.setDisplayedMnemonic('L');
        jLabel.setDisplayedMnemonicIndex(13);
        jPanel2.add((Component)jLabel, new GridConstraints(3, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        Spacer spacer = new Spacer();
        jPanel2.add((Component)spacer, new GridConstraints(8, 1, 1, 2, 0, 2, 1, 6, null, null, null));
        this.mySaveContextOnCommit = jCheckBox3 = new JCheckBox();
        jCheckBox3.setText("Save context on commit");
        jCheckBox3.setMnemonic('S');
        jCheckBox3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jCheckBox3, new GridConstraints(6, 0, 1, 3, 8, 0, 3, 0, null, null, null));
        JBLabel jBLabel = new JBLabel();
        jBLabel.setText("Changelist name format:");
        jBLabel.setDisplayedMnemonic('F');
        jBLabel.setDisplayedMnemonicIndex(16);
        jPanel2.add((Component)jBLabel, new GridConstraints(0, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField = this.myChangelistNameFormat;
        jPanel2.add((Component)editorTextField, new GridConstraints(0, 1, 1, 2, 8, 1, 6, 0, null, null, null));
        this.myAlwaysDisplayTaskCombo = jBCheckBox = new JBCheckBox();
        jBCheckBox.setText("Always display task combo in toolbar");
        jBCheckBox.setMnemonic('D');
        jBCheckBox.setDisplayedMnemonicIndex(7);
        jPanel2.add((Component)jBCheckBox, new GridConstraints(5, 0, 1, 3, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel2 = new JBLabel();
        jBLabel2.setText("Connection timeout:");
        jBLabel2.setDisplayedMnemonic('T');
        jBLabel2.setDisplayedMnemonicIndex(11);
        jPanel2.add((Component)jBLabel2, new GridConstraints(4, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        this.myConnectionTimeout = jTextField3 = new JTextField();
        jTextField3.setText("3000");
        jPanel2.add((Component)jTextField3, new GridConstraints(4, 1, 1, 1, 0, 1, 0, 0, null, new Dimension(30, -1), null));
        JLabel jLabel2 = new JLabel();
        jLabel2.setText("milliseconds");
        jPanel2.add((Component)jLabel2, new GridConstraints(4, 2, 1, 1, 8, 0, 4, 0, null, null, null));
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout((LayoutManager)new GridLayoutManager(1, 1, new Insets(10, 0, 0, 0), -1, -1, false, false));
        jPanel2.add((Component)jPanel3, new GridConstraints(7, 0, 1, 3, 0, 3, 3, 3, null, new Dimension(511, 58), null));
        this.myCacheSettings = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(1, 7, new Insets(0, 0, 0, 0), -1, -1, false, false));
        jPanel.putClientProperty("BorderFactoryClass", "com.intellij.ui.IdeBorderFactory$PlainSmallWithIndent");
        jPanel3.add((Component)jPanel, new GridConstraints(0, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        jPanel.setBorder(IdeBorderFactory.PlainSmallWithIndent.createTitledBorder((Border)BorderFactory.createEtchedBorder(), (String)"Issue cache", (int)0, (int)0, null, null));
        this.myUpdateCheckBox = jCheckBox2 = new JCheckBox();
        jCheckBox2.setText("Enable cache");
        jCheckBox2.setMnemonic('C');
        jCheckBox2.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jCheckBox2, new GridConstraints(0, 0, 1, 1, 8, 0, 3, 0, null, null, null));
        Spacer spacer2 = new Spacer();
        jPanel.add((Component)spacer2, new GridConstraints(0, 6, 1, 1, 0, 1, 6, 1, null, null, null));
        JLabel jLabel3 = new JLabel();
        jLabel3.setHorizontalAlignment(4);
        jLabel3.setText("       Update");
        jLabel3.setDisplayedMnemonic('U');
        jLabel3.setDisplayedMnemonicIndex(7);
        jPanel.add((Component)jLabel3, new GridConstraints(0, 1, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUpdateCount = jTextField2 = new JTextField();
        jTextField2.setText("11");
        jPanel.add((Component)jTextField2, new GridConstraints(0, 2, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel4 = new JLabel();
        jLabel4.setHorizontalAlignment(4);
        jLabel4.setText("issues every");
        jLabel4.setDisplayedMnemonic('V');
        jLabel4.setDisplayedMnemonicIndex(8);
        jPanel.add((Component)jLabel4, new GridConstraints(0, 3, 1, 1, 4, 0, 0, 0, null, null, null));
        this.myUpdateInterval = jTextField = new JTextField();
        jTextField.setText("11");
        jPanel.add((Component)jTextField, new GridConstraints(0, 4, 1, 1, 0, 1, 0, 0, null, new Dimension(50, -1), null));
        JLabel jLabel5 = new JLabel();
        jLabel5.setText("minutes");
        jPanel.add((Component)jLabel5, new GridConstraints(0, 5, 1, 1, 8, 0, 0, 0, null, null, null));
        JBLabel jBLabel3 = new JBLabel();
        jBLabel3.setText("Feature branch name format:");
        jBLabel3.setDisplayedMnemonic('F');
        jBLabel3.setDisplayedMnemonicIndex(0);
        jPanel2.add((Component)jBLabel3, new GridConstraints(1, 0, 1, 1, 8, 0, 0, 0, null, null, null));
        EditorTextField editorTextField2 = this.myBranchNameFormat;
        jPanel2.add((Component)editorTextField2, new GridConstraints(1, 1, 1, 2, 8, 1, 6, 0, null, null, null));
        this.myLowerCase = jCheckBox = new JCheckBox();
        jCheckBox.setText("Lowercased");
        jCheckBox.setMnemonic('W');
        jCheckBox.setDisplayedMnemonicIndex(2);
        jPanel2.add((Component)jCheckBox, new GridConstraints(2, 1, 1, 2, 8, 0, 3, 0, null, null, null));
        jLabel.setLabelFor(jTextField4);
        jBLabel.setLabelFor((Component)editorTextField);
        jBLabel2.setLabelFor(jTextField3);
        jLabel3.setLabelFor(jTextField2);
        jLabel4.setLabelFor(jTextField);
        jBLabel3.setLabelFor((Component)editorTextField2);
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myPanel;
    }
}

