/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.gitlab;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.tasks.config.BaseRepositoryEditor;
import com.intellij.tasks.gitlab.GitlabRepository;
import com.intellij.tasks.gitlab.model.GitlabProject;
import com.intellij.tasks.impl.BaseRepository;
import com.intellij.tasks.impl.TaskUiUtil;
import com.intellij.ui.components.JBLabel;
import com.intellij.util.Consumer;
import com.intellij.util.ui.FormBuilder;
import com.intellij.util.ui.UIUtil;
import java.awt.Component;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitlabRepositoryEditor
extends BaseRepositoryEditor<GitlabRepository> {
    private JBLabel myProjectLabel;
    private ComboBox myProjectComboBox;

    public GitlabRepositoryEditor(Project project, GitlabRepository repository, Consumer<? super GitlabRepository> changeListener) {
        super(project, (BaseRepository)repository, changeListener);
        this.myPasswordLabel.setText("Token:");
        this.myUsernameLabel.setVisible(false);
        this.myUserNameText.setVisible(false);
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
        this.installListener((JComboBox)this.myProjectComboBox);
        UIUtil.invokeLaterIfNeeded(() -> this.initialize());
    }

    private void initialize() {
        GitlabProject currentProject = ((GitlabRepository)this.myRepository).getCurrentProject();
        if (currentProject != null && ((GitlabRepository)this.myRepository).isConfigured()) {
            new FetchProjectsTask().queue();
        }
    }

    @Nullable
    protected JComponent createCustomPanel() {
        this.myProjectLabel = new JBLabel("Project:", 4);
        this.myProjectComboBox = new ComboBox(300);
        this.myProjectComboBox.setRenderer(new TaskUiUtil.SimpleComboBoxRenderer("Set server URL and token first"));
        this.myProjectLabel.setLabelFor((Component)this.myProjectComboBox);
        return new FormBuilder().addLabeledComponent((JComponent)this.myProjectLabel, (JComponent)this.myProjectComboBox).getPanel();
    }

    public void setAnchor(@Nullable JComponent anchor) {
        super.setAnchor(anchor);
        this.myProjectLabel.setAnchor(anchor);
    }

    protected void afterTestConnection(boolean connectionSuccessful) {
        if (connectionSuccessful) {
            new FetchProjectsTask().queue();
        }
    }

    public void apply() {
        super.apply();
        ((GitlabRepository)this.myRepository).setCurrentProject((GitlabProject)this.myProjectComboBox.getSelectedItem());
        this.myTestButton.setEnabled(((GitlabRepository)this.myRepository).isConfigured());
    }

    private class FetchProjectsTask
    extends TaskUiUtil.ComboBoxUpdater<GitlabProject> {
        private FetchProjectsTask() {
            super(GitlabRepositoryEditor.this.myProject, "Downloading Gitlab projects...", (JComboBox)GitlabRepositoryEditor.this.myProjectComboBox);
        }

        @Override
        public GitlabProject getExtraItem() {
            return GitlabRepository.UNSPECIFIED_PROJECT;
        }

        @Override
        @Nullable
        public GitlabProject getSelectedItem() {
            return ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).getCurrentProject();
        }

        @Override
        @NotNull
        protected List<GitlabProject> fetch(@NotNull ProgressIndicator indicator) throws Exception {
            return ((GitlabRepository)GitlabRepositoryEditor.this.myRepository).fetchProjects();
        }
    }
}

