/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.tasks.pivotal;

import com.intellij.openapi.util.IconLoader;
import com.intellij.tasks.Comment;
import com.intellij.tasks.Task;
import com.intellij.tasks.TaskRepository;
import com.intellij.tasks.TaskType;
import com.intellij.tasks.impl.TaskUtil;
import com.intellij.tasks.pivotal.PivotalTrackerRepository;
import com.intellij.tasks.pivotal.model.PivotalTrackerStory;
import com.intellij.util.ArrayUtil;
import java.util.Date;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PivotalTrackerTask
extends Task {
    @NotNull
    private final PivotalTrackerRepository myRepository;
    @NotNull
    private final PivotalTrackerStory myStory;

    public PivotalTrackerTask(@NotNull PivotalTrackerRepository repository, @NotNull PivotalTrackerStory story) {
        this.myRepository = repository;
        this.myStory = story;
    }

    @Nullable
    public TaskRepository getRepository() {
        return this.myRepository;
    }

    @NotNull
    public String getId() {
        return this.myStory.getProjectId() + "-" + this.myStory.getId();
    }

    @NotNull
    public String getPresentableId() {
        return "#" + this.myStory.getId();
    }

    @NotNull
    public String getNumber() {
        return this.myStory.getId();
    }

    @NotNull
    public String getSummary() {
        return this.myStory.getName();
    }

    @Nullable
    public String getDescription() {
        return this.myStory.getDescription();
    }

    @NotNull
    public Comment[] getComments() {
        return Comment.EMPTY_ARRAY;
    }

    @NotNull
    public Icon getIcon() {
        return IconLoader.getIcon((String)this.getCustomIcon(), PivotalTrackerRepository.class);
    }

    @NotNull
    public TaskType getType() {
        return TaskType.OTHER;
    }

    @Nullable
    public Date getUpdated() {
        return TaskUtil.parseDate((String)this.myStory.getUpdatedAt());
    }

    @Nullable
    public Date getCreated() {
        return TaskUtil.parseDate((String)this.myStory.getCreatedAt());
    }

    public boolean isClosed() {
        return ArrayUtil.contains((String)this.myStory.getCurrentState(), (String[])new String[]{"accepted", "delivered", "finished"});
    }

    public boolean isIssue() {
        return true;
    }

    @Nullable
    public String getIssueUrl() {
        return this.myRepository.getUrl() + "/story/show/" + this.myStory.getId();
    }

    @NotNull
    public String getCustomIcon() {
        return "/icons/pivotal/" + this.myStory.getStoryType() + ".png";
    }

    @NotNull
    public PivotalTrackerStory getStory() {
        return this.myStory;
    }
}

