/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.action;

import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.streams.diagnostic.ex.TraceCompilationException;
import com.intellij.debugger.streams.diagnostic.ex.TraceEvaluationException;
import com.intellij.debugger.streams.lib.LibrarySupport;
import com.intellij.debugger.streams.lib.LibrarySupportProvider;
import com.intellij.debugger.streams.psi.DebuggerPositionResolver;
import com.intellij.debugger.streams.psi.impl.DebuggerPositionResolverImpl;
import com.intellij.debugger.streams.trace.EvaluateExpressionTracer;
import com.intellij.debugger.streams.trace.ResolvedTracingResult;
import com.intellij.debugger.streams.trace.TraceExpressionBuilder;
import com.intellij.debugger.streams.trace.TracingCallback;
import com.intellij.debugger.streams.trace.TracingResult;
import com.intellij.debugger.streams.trace.impl.TraceResultInterpreterImpl;
import com.intellij.debugger.streams.ui.ChooserOption;
import com.intellij.debugger.streams.ui.impl.ElementChooserImpl;
import com.intellij.debugger.streams.ui.impl.EvaluationAwareTraceWindow;
import com.intellij.debugger.streams.wrapper.StreamChain;
import com.intellij.debugger.streams.wrapper.StreamChainBuilder;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.util.PsiEditorUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xdebugger.XDebugSession;
import com.intellij.xdebugger.XDebuggerManager;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceStreamAction
extends AnAction {
    private static final Logger LOG = Logger.getInstance(TraceStreamAction.class);
    private final DebuggerPositionResolver myPositionResolver = new DebuggerPositionResolverImpl();
    private final List<SupportedLibrary> mySupportedLibraries = ContainerUtil.map(LibrarySupportProvider.getList(), SupportedLibrary::new);
    private final Set<String> mySupportedLanguages = StreamEx.of(this.mySupportedLibraries).map(x -> x.languageId).toSet();
    private int myLastVisitedPsiElementHash;

    public void update(@NotNull AnActionEvent e) {
        XDebugSession session = TraceStreamAction.getCurrentSession(e);
        PsiElement element = session == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        Presentation presentation = e.getPresentation();
        if (element == null) {
            presentation.setVisible(true);
            presentation.setEnabled(false);
        } else {
            String languageId = element.getLanguage().getID();
            if (this.mySupportedLanguages.contains(languageId)) {
                presentation.setVisible(true);
                boolean chainExists = this.isChainExists(element);
                presentation.setEnabled(chainExists);
                int elementHash = System.identityHashCode(element);
                if (chainExists && this.myLastVisitedPsiElementHash != elementHash) {
                    this.myLastVisitedPsiElementHash = elementHash;
                }
            } else {
                presentation.setEnabledAndVisible(false);
            }
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        PsiElement element;
        XDebugSession session = TraceStreamAction.getCurrentSession(e);
        LibrarySupportProvider.EP_NAME.getExtensionList();
        PsiElement psiElement = element = session == null ? null : this.myPositionResolver.getNearestElementToBreakpoint(session);
        if (element != null) {
            List chains = this.mySupportedLibraries.stream().filter(library -> library.languageId.equals(element.getLanguage().getID())).filter(library -> library.builder.isChainExists(element)).flatMap(library -> library.builder.build(element).stream().map(x -> new StreamChainWithLibrary((StreamChain)x, (SupportedLibrary)library))).collect(Collectors.toList());
            if (chains.isEmpty()) {
                LOG.warn("stream chain is not built");
                return;
            }
            if (chains.size() == 1) {
                TraceStreamAction.runTrace(((StreamChainWithLibrary)chains.get((int)0)).chain, ((StreamChainWithLibrary)chains.get((int)0)).library, session);
            } else {
                Editor editor = PsiEditorUtil.Service.getInstance().findEditorByPsiElement(element);
                if (editor == null) {
                    throw new RuntimeException("editor not found");
                }
                new MyStreamChainChooser(editor).show(ContainerUtil.map(chains, StreamChainOption::new), provider -> TraceStreamAction.runTrace(provider.chain, provider.library, session));
            }
        } else {
            LOG.info("element at cursor not found");
        }
    }

    private boolean isChainExists(@NotNull PsiElement element) {
        for (SupportedLibrary library : this.mySupportedLibraries) {
            if (!element.getLanguage().getID().equals(library.languageId) || !library.builder.isChainExists(element)) continue;
            return true;
        }
        return false;
    }

    private static void runTrace(@NotNull StreamChain chain, final @NotNull SupportedLibrary library, @NotNull XDebugSession session) {
        final EvaluationAwareTraceWindow window = new EvaluationAwareTraceWindow(session, chain);
        ApplicationManager.getApplication().invokeLater(() -> ((EvaluationAwareTraceWindow)window).show());
        Project project = session.getProject();
        TraceExpressionBuilder expressionBuilder = library.createExpressionBuilder(project);
        TraceResultInterpreterImpl resultInterpreter = new TraceResultInterpreterImpl(library.librarySupport.getInterpreterFactory());
        EvaluateExpressionTracer tracer = new EvaluateExpressionTracer(session, expressionBuilder, resultInterpreter);
        tracer.trace(chain, new TracingCallback(){

            @Override
            public void evaluated(@NotNull TracingResult result, @NotNull EvaluationContextImpl context) {
                ResolvedTracingResult resolvedTrace = result.resolve(library.librarySupport.getResolverFactory());
                ApplicationManager.getApplication().invokeLater(() -> window.setTrace(resolvedTrace, context));
            }

            @Override
            public void evaluationFailed(@NotNull String traceExpression, @NotNull String message) {
                this.notifyUI(message);
                throw new TraceEvaluationException(message, traceExpression);
            }

            @Override
            public void compilationFailed(@NotNull String traceExpression, @NotNull String message) {
                this.notifyUI(message);
                throw new TraceCompilationException(message, traceExpression);
            }

            private void notifyUI(@NotNull String message) {
                ApplicationManager.getApplication().invokeLater(() -> window.setFailMessage(message));
            }
        });
    }

    @Nullable
    private static XDebugSession getCurrentSession(@NotNull AnActionEvent e) {
        Project project = e.getProject();
        return project == null ? null : XDebuggerManager.getInstance((Project)project).getCurrentSession();
    }

    private static class StreamChainOption
    implements ChooserOption {
        final StreamChain chain;
        final SupportedLibrary library;

        StreamChainOption(@NotNull StreamChainWithLibrary chain) {
            this.chain = chain.chain;
            this.library = chain.library;
        }

        @Override
        @NotNull
        public Stream<TextRange> rangeStream() {
            return Stream.of(new TextRange(this.chain.getQualifierExpression().getTextRange().getStartOffset(), this.chain.getTerminationCall().getTextRange().getEndOffset()));
        }

        @Override
        @NotNull
        public String getText() {
            return this.chain.getCompactText();
        }
    }

    private static class StreamChainWithLibrary {
        final StreamChain chain;
        final SupportedLibrary library;

        StreamChainWithLibrary(@NotNull StreamChain chain, @NotNull SupportedLibrary library) {
            this.chain = chain;
            this.library = library;
        }
    }

    private static class SupportedLibrary {
        final String languageId;
        final StreamChainBuilder builder;
        final LibrarySupport librarySupport;
        private final LibrarySupportProvider mySupportProvider;

        SupportedLibrary(@NotNull LibrarySupportProvider provider) {
            this.languageId = provider.getLanguageId();
            this.builder = provider.getChainBuilder();
            this.librarySupport = provider.getLibrarySupport();
            this.mySupportProvider = provider;
        }

        TraceExpressionBuilder createExpressionBuilder(@NotNull Project project) {
            return this.mySupportProvider.getExpressionBuilder(project);
        }
    }

    private static class MyStreamChainChooser
    extends ElementChooserImpl<StreamChainOption> {
        MyStreamChainChooser(@NotNull Editor editor) {
            super(editor);
        }
    }
}

