/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.resolve;

import com.intellij.debugger.streams.resolve.ValuesOrderResolver;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class AllToResultResolver
implements ValuesOrderResolver {
    @Override
    @NotNull
    public ValuesOrderResolver.Result resolve(@NotNull TraceInfo info) {
        Map<Integer, TraceElement> before = info.getValuesOrderBefore();
        Map<Integer, TraceElement> after = info.getValuesOrderAfter();
        assert (after.size() == 1);
        TraceElement resultElement = after.values().iterator().next();
        List<TraceElement> to = Collections.singletonList(resultElement);
        LinkedHashMap<TraceElement, List<TraceElement>> forward = new LinkedHashMap<TraceElement, List<TraceElement>>();
        for (TraceElement beforeElement : before.values()) {
            forward.put(beforeElement, to);
        }
        Map<TraceElement, List<TraceElement>> backward = Collections.singletonMap(resultElement, new ArrayList<TraceElement>(before.values()));
        return ValuesOrderResolver.Result.of(forward, backward);
    }
}

