/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.handler;

import com.intellij.debugger.streams.trace.impl.handler.type.GenericType;
import com.intellij.debugger.streams.wrapper.CallArgument;
import com.intellij.debugger.streams.wrapper.IntermediateStreamCall;
import com.intellij.debugger.streams.wrapper.StreamCallType;
import com.intellij.debugger.streams.wrapper.impl.CallArgumentImpl;
import com.intellij.openapi.util.TextRange;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PeekCall
implements IntermediateStreamCall {
    private final List<CallArgument> myLambda;
    private final GenericType myElementType;

    public PeekCall(@NotNull String lambda2, @NotNull GenericType elementType) {
        this.myLambda = Collections.singletonList(new CallArgumentImpl("java.lang.Object", lambda2));
        this.myElementType = elementType;
    }

    @Override
    @NotNull
    public String getName() {
        return "peek";
    }

    @Override
    @NotNull
    public List<CallArgument> getArguments() {
        return this.myLambda;
    }

    @Override
    @NotNull
    public TextRange getTextRange() {
        return TextRange.EMPTY_RANGE;
    }

    @Override
    @NotNull
    public StreamCallType getType() {
        return StreamCallType.INTERMEDIATE;
    }

    @Override
    @NotNull
    public GenericType getTypeAfter() {
        return this.myElementType;
    }

    @Override
    @NotNull
    public GenericType getTypeBefore() {
        return this.myElementType;
    }
}

