/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.SimplePeekCallTraceInterpreter;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedArrayLengthException;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueTypeException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.Value;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public abstract class MatchInterpreterBase
implements CallTraceInterpreter {
    private final CallTraceInterpreter myPeekResolver = new SimplePeekCallTraceInterpreter();

    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (value instanceof ArrayReference) {
            Map<Integer, TraceElement> traceAfter;
            Collection<TraceElement> traceAfterFilter;
            ArrayReference array2 = (ArrayReference)value;
            if (array2.length() != 2) {
                throw new UnexpectedArrayLengthException("trace array for *match call should contain two items. Actual = " + array2.length());
            }
            Value peeksResult = array2.getValue(0);
            Value streamResult2 = array2.getValue(1);
            TraceElement streamResultElement = TraceElementImpl.ofResultValue(((ArrayReference)streamResult2).getValue(0));
            TraceInfo peeksInfo = this.myPeekResolver.resolve(call2, peeksResult);
            Collection<TraceElement> traceBeforeFilter = peeksInfo.getValuesOrderBefore().values();
            boolean result = this.getResult(traceBeforeFilter, traceAfterFilter = (traceAfter = peeksInfo.getValuesOrderAfter()).values());
            Action action = this.getAction(result);
            Map<Integer, TraceElement> beforeTrace = Action.CONNECT_FILTERED.equals((Object)action) ? MatchInterpreterBase.onlyFiltered(traceAfterFilter) : MatchInterpreterBase.difference(traceBeforeFilter, traceAfter.keySet());
            return new ValuesOrderInfo(call2, beforeTrace, MatchInterpreterBase.makeIndexByTime(Stream.of(streamResultElement)));
        }
        throw new UnexpectedValueTypeException("value should be array reference, but given " + value.type().toString());
    }

    protected abstract boolean getResult(@NotNull Collection<TraceElement> var1, @NotNull Collection<TraceElement> var2);

    @NotNull
    protected abstract Action getAction(boolean var1);

    @NotNull
    private static Map<Integer, TraceElement> onlyFiltered(@NotNull Collection<TraceElement> afterFilter) {
        return MatchInterpreterBase.makeIndexByTime(afterFilter.stream());
    }

    @NotNull
    private static Map<Integer, TraceElement> difference(@NotNull Collection<TraceElement> before, @NotNull Set<Integer> timesAfter) {
        return MatchInterpreterBase.makeIndexByTime(before.stream().filter(x -> !timesAfter.contains(x.getTime())));
    }

    @NotNull
    private static Map<Integer, TraceElement> makeIndexByTime(@NotNull Stream<TraceElement> elementStream) {
        return elementStream.collect(Collectors.toMap(TraceElement::getTime, Function.identity()));
    }

    protected static enum Action {
        CONNECT_FILTERED,
        CONNECT_DIFFERENCE;

    }
}

