/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.trace.impl.interpret;

import com.intellij.debugger.streams.trace.CallTraceInterpreter;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.trace.TraceInfo;
import com.intellij.debugger.streams.trace.impl.TraceElementImpl;
import com.intellij.debugger.streams.trace.impl.interpret.ValuesOrderInfo;
import com.intellij.debugger.streams.trace.impl.interpret.ex.UnexpectedValueException;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.sun.jdi.ArrayReference;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.Value;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SimplePeekCallTraceInterpreter
implements CallTraceInterpreter {
    @Override
    @NotNull
    public TraceInfo resolve(@NotNull StreamCall call2, @NotNull Value value) {
        if (value instanceof ArrayReference) {
            ArrayReference trace = (ArrayReference)value;
            Value before = trace.getValue(0);
            Value after = trace.getValue(1);
            if (before instanceof ArrayReference && after instanceof ArrayReference) {
                Map<Integer, TraceElement> beforeTrace = SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)before);
                Map<Integer, TraceElement> afterTrace = SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)after);
                return new ValuesOrderInfo(call2, beforeTrace, afterTrace);
            }
        }
        throw new UnexpectedValueException("peek operation trace is wrong format");
    }

    @NotNull
    private static Map<Integer, TraceElement> resolveTrace(@NotNull ArrayReference mapArray) {
        Value keys = mapArray.getValue(0);
        Value values = mapArray.getValue(1);
        if (keys instanceof ArrayReference && values instanceof ArrayReference) {
            return SimplePeekCallTraceInterpreter.resolveTrace((ArrayReference)keys, (ArrayReference)values);
        }
        throw new UnexpectedValueException("keys and values must be stored in arrays in peek resolver");
    }

    @NotNull
    private static Map<Integer, TraceElement> resolveTrace(@NotNull ArrayReference keysArray, @NotNull ArrayReference valuesArray) {
        LinkedHashMap<Integer, TraceElement> result = new LinkedHashMap<Integer, TraceElement>();
        List<Value> keyMirrors = keysArray.getValues();
        List<Value> valueMirrors = valuesArray.getValues();
        if (keyMirrors.size() == valueMirrors.size()) {
            int size = keyMirrors.size();
            for (int i = 0; i < size; ++i) {
                TraceElement element = SimplePeekCallTraceInterpreter.resolveTraceElement(keyMirrors.get(i), valueMirrors.get(i));
                result.put(element.getTime(), element);
            }
            return result;
        }
        throw new UnexpectedValueException("keys and values arrays should be with the same sizes");
    }

    @NotNull
    private static TraceElement resolveTraceElement(@NotNull Value key, @Nullable Value value) {
        if (key instanceof IntegerValue) {
            return new TraceElementImpl(((IntegerValue)key).value(), value);
        }
        throw new UnexpectedValueException("key must be an integer value");
    }
}

