/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.engine.JavaValue;
import com.intellij.debugger.engine.evaluation.EvaluationContext;
import com.intellij.debugger.engine.evaluation.EvaluationContextImpl;
import com.intellij.debugger.engine.events.DebuggerCommandImpl;
import com.intellij.debugger.memory.utils.InstanceJavaValue;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.PaintingListener;
import com.intellij.debugger.streams.ui.TraceContainer;
import com.intellij.debugger.streams.ui.ValuesSelectionListener;
import com.intellij.debugger.streams.ui.impl.PrimitiveValueDescriptor;
import com.intellij.debugger.ui.impl.watch.DebuggerTreeNodeImpl;
import com.intellij.debugger.ui.impl.watch.MessageDescriptor;
import com.intellij.debugger.ui.impl.watch.NodeManagerImpl;
import com.intellij.debugger.ui.impl.watch.ValueDescriptorImpl;
import com.intellij.debugger.ui.tree.NodeDescriptor;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.ui.JBColor;
import com.intellij.util.EventDispatcher;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.UIUtil;
import com.intellij.xdebugger.evaluation.XDebuggerEditorsProvider;
import com.intellij.xdebugger.frame.XCompositeNode;
import com.intellij.xdebugger.frame.XNamedValue;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.frame.XValueChildrenList;
import com.intellij.xdebugger.frame.XValueContainer;
import com.intellij.xdebugger.frame.XValueNode;
import com.intellij.xdebugger.frame.XValuePlace;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTree;
import com.intellij.xdebugger.impl.ui.tree.XDebuggerTreeListener;
import com.intellij.xdebugger.impl.ui.tree.nodes.RestorableStateNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XDebuggerTreeNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueContainerNode;
import com.intellij.xdebugger.impl.ui.tree.nodes.XValueNodeImpl;
import com.sun.jdi.Value;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Arrays;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.tree.TreePath;
import one.util.streamex.StreamEx;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.java.debugger.JavaDebuggerEditorsProvider;

public class CollectionTree
extends XDebuggerTree
implements TraceContainer {
    private static final TreePath[] EMPTY_PATHS = new TreePath[0];
    private static final Map<Integer, Color> COLORS_CACHE = new HashMap<Integer, Color>();
    private static final Object NULL_MARKER = ObjectUtils.sentinel((String)"CollectionTree.NULL_MARKER");
    private final NodeManagerImpl myNodeManager;
    private final Project myProject;
    private final Map<TraceElement, TreePath> myValue2Path = new HashMap<TraceElement, TreePath>();
    private final Map<TreePath, TraceElement> myPath2Value = new HashMap<TreePath, TraceElement>();
    private final int myItemsCount;
    private Set<TreePath> myHighlighted = Collections.emptySet();
    private final EventDispatcher<ValuesSelectionListener> mySelectionDispatcher = EventDispatcher.create(ValuesSelectionListener.class);
    private final EventDispatcher<PaintingListener> myPaintingDispatcher = EventDispatcher.create(PaintingListener.class);
    private boolean myIgnoreInternalSelectionEvents = false;
    private boolean myIgnoreExternalSelectionEvents = false;

    CollectionTree(@NotNull List<Value> values, final @NotNull List<TraceElement> traceElements, final @NotNull EvaluationContextImpl evaluationContext) {
        super(evaluationContext.getProject(), (XDebuggerEditorsProvider)new JavaDebuggerEditorsProvider(), null, "XDebugger.Inspect.Tree.Popup", null);
        this.myProject = evaluationContext.getProject();
        this.myNodeManager = new MyNodeManager(this.myProject);
        this.myItemsCount = values.size();
        XValueNodeImpl root = new XValueNodeImpl((XDebuggerTree)this, null, "root", (XValue)new MyRootValue(values, evaluationContext));
        this.setRoot((XDebuggerTreeNode)root, false);
        root.setLeaf(false);
        final Map key2TraceElements = StreamEx.of(traceElements).groupingBy(CollectionTree::extractKey);
        final HashMap key2Index = new HashMap(key2TraceElements.size() + 1);
        this.addTreeListener(new XDebuggerTreeListener(){

            public void nodeLoaded(final @NotNull RestorableStateNode node, @NotNull String name) {
                XValueContainer container;
                final 1 listener = this;
                if (node instanceof XValueContainerNode && (container = ((XValueContainerNode)node).getValueContainer()) instanceof JavaValue) {
                    final ValueDescriptorImpl descriptor = ((JavaValue)container).getDescriptor();
                    evaluationContext.getDebugProcess().getManagerThread().schedule(new DebuggerCommandImpl(){

                        protected void action() {
                            Value value = descriptor.getValue();
                            ApplicationManager.getApplication().invokeLater(() -> {
                                Object key = value == null ? NULL_MARKER : value;
                                List elements2 = (List)key2TraceElements.get(key);
                                int nextIndex = key2Index.getOrDefault(key, -1) + 1;
                                if (elements2 != null && nextIndex < elements2.size()) {
                                    TraceElement element = (TraceElement)elements2.get(nextIndex);
                                    CollectionTree.this.myValue2Path.put(element, node.getPath());
                                    CollectionTree.this.myPath2Value.put(node.getPath(), element);
                                    key2Index.put(key, nextIndex);
                                }
                                if (CollectionTree.this.myPath2Value.size() == traceElements.size()) {
                                    CollectionTree.this.removeTreeListener(listener);
                                    ApplicationManager.getApplication().invokeLater(() -> CollectionTree.this.repaint());
                                }
                            });
                        }
                    });
                }
            }
        });
        this.addTreeSelectionListener(e -> {
            if (this.myIgnoreInternalSelectionEvents) {
                return;
            }
            TreePath[] selectedPaths = this.getSelectionPaths();
            TreePath[] paths = selectedPaths == null ? EMPTY_PATHS : selectedPaths;
            List<TraceElement> selectedItems = Arrays.stream(paths).map(this::getTopPath).map(this.myPath2Value::get).filter(Objects::nonNull).collect(Collectors.toList());
            this.fireSelectionChanged(selectedItems);
        });
        this.setSelectionRow(0);
        this.expandNodesOnLoad(node -> node == root);
    }

    CollectionTree(@NotNull List<TraceElement> traceElements, @NotNull EvaluationContextImpl evaluationContext) {
        this(ContainerUtil.map(traceElements, TraceElement::getValue), traceElements, evaluationContext);
    }

    public boolean isFileColorsEnabled() {
        return true;
    }

    @Nullable
    public Color getFileColorForPath(@NotNull TreePath path) {
        if (this.isPathHighlighted(path)) {
            Color background = UIUtil.getTreeSelectionBackground((boolean)true);
            return COLORS_CACHE.computeIfAbsent(background.getRGB(), rgb -> new JBColor(new Color(background.getRed(), background.getGreen(), background.getBlue(), 75), new Color(background.getRed(), background.getGreen(), background.getBlue(), 100)));
        }
        return UIUtil.getTreeBackground();
    }

    public void clearSelection() {
        this.myIgnoreInternalSelectionEvents = true;
        super.clearSelection();
        this.myIgnoreInternalSelectionEvents = false;
    }

    @Nullable
    public Rectangle getRectByValue(@NotNull TraceElement element) {
        TreePath path = this.myValue2Path.get(element);
        return path == null ? null : this.getPathBounds(path);
    }

    @Override
    public void highlight(@NotNull List<TraceElement> elements2) {
        this.clearSelection();
        this.highlightValues(elements2);
        this.tryScrollTo(elements2);
        this.updatePresentation();
    }

    @Override
    public void select(@NotNull List<TraceElement> elements2) {
        TreePath[] paths = (TreePath[])elements2.stream().map(this.myValue2Path::get).toArray(TreePath[]::new);
        this.select(paths);
        this.highlightValues(elements2);
        if (paths.length > 0) {
            this.scrollPathToVisible(paths[0]);
        }
        this.updatePresentation();
    }

    @Override
    public void addSelectionListener(@NotNull ValuesSelectionListener listener) {
        this.mySelectionDispatcher.addListener((EventListener)listener);
    }

    @Override
    public boolean highlightedExists() {
        return !this.isSelectionEmpty() || !this.myHighlighted.isEmpty();
    }

    public int getItemsCount() {
        return this.myItemsCount;
    }

    public void addPaintingListener(@NotNull PaintingListener listener) {
        this.myPaintingDispatcher.addListener((EventListener)listener);
    }

    protected void paintComponent(Graphics g) {
        super.paintComponent(g);
        ((PaintingListener)this.myPaintingDispatcher.getMulticaster()).componentPainted();
    }

    private void select(@NotNull TreePath[] paths) {
        if (this.myIgnoreExternalSelectionEvents) {
            return;
        }
        this.myIgnoreInternalSelectionEvents = true;
        this.getSelectionModel().setSelectionPaths(paths);
        this.myIgnoreInternalSelectionEvents = false;
    }

    private void fireSelectionChanged(List<TraceElement> selectedItems) {
        this.myIgnoreExternalSelectionEvents = true;
        ((ValuesSelectionListener)this.mySelectionDispatcher.getMulticaster()).selectionChanged(selectedItems);
        this.myIgnoreExternalSelectionEvents = false;
    }

    private void tryScrollTo(@NotNull List<TraceElement> elements2) {
        int[] rows = elements2.stream().map(this.myValue2Path::get).filter(Objects::nonNull).mapToInt(arg_0 -> this.getRowForPath(arg_0)).sorted().toArray();
        if (rows.length == 0) {
            return;
        }
        if (this.isShowing()) {
            Rectangle bestVisibleArea = this.optimizeRowsCountInVisibleRect(rows);
            Rectangle visibleRect = this.getVisibleRect();
            boolean notVisibleHighlightedRowExists = Arrays.stream(rows).anyMatch(x -> !visibleRect.intersects(this.getRowBounds(x)));
            if (notVisibleHighlightedRowExists) {
                this.scrollRectToVisible(bestVisibleArea);
            }
        } else {
            this.scrollPathToVisible(this.getPathForRow(rows[0]));
        }
    }

    @NotNull
    private Rectangle optimizeRowsCountInVisibleRect(@NotNull int[] rows) {
        Rectangle visibleRect = this.getVisibleRect();
        int height = visibleRect.height;
        int topIndex = 0;
        Rectangle rowBounds = this.getRowBounds(rows[topIndex]);
        if (rowBounds == null) {
            return visibleRect;
        }
        int topY = rowBounds.y;
        class Result {
            private int top = 0;
            private int bot = 0;

            Result() {
            }

            @Contract(pure=true)
            private int count() {
                return this.bot - this.top;
            }
        }
        Result result = new Result();
        for (int bottomIndex = 1; bottomIndex < rows.length; ++bottomIndex) {
            int nextY = this.getRowBounds((int)rows[bottomIndex]).y;
            while (nextY - topY > height) {
                if ((rowBounds = this.getRowBounds(rows[++topIndex])) == null) {
                    return visibleRect;
                }
                topY = rowBounds.y;
            }
            if (bottomIndex - topIndex <= result.count()) continue;
            result.top = topIndex;
            result.bot = bottomIndex;
        }
        int y = this.getRowBounds((int)rows[((Result)result).top]).y;
        if (y > visibleRect.y) {
            Rectangle botBounds = this.getRowBounds(rows[result.bot]);
            y = botBounds.y + botBounds.height - visibleRect.height;
        }
        return new Rectangle(visibleRect.x, y, visibleRect.width, height);
    }

    private void highlightValues(@NotNull List<TraceElement> elements2) {
        this.myHighlighted = elements2.stream().map(this.myValue2Path::get).collect(Collectors.toSet());
    }

    private void updatePresentation() {
        this.revalidate();
        this.repaint();
    }

    public boolean isHighlighted(@NotNull TraceElement traceElement) {
        TreePath path = this.myValue2Path.get(traceElement);
        return path != null && this.isPathHighlighted(path);
    }

    private boolean isPathHighlighted(@NotNull TreePath path) {
        return this.myHighlighted.contains(path) || this.isPathSelected(path);
    }

    @NotNull
    private TreePath getTopPath(@NotNull TreePath path) {
        TreePath current;
        for (current = path; current != null && !this.myPath2Value.containsKey(current); current = current.getParentPath()) {
        }
        return current != null ? current : path;
    }

    private static Object extractKey(@NotNull TraceElement element) {
        Value value = element.getValue();
        return value == null ? NULL_MARKER : value;
    }

    private static final class MyNodeManager
    extends NodeManagerImpl {
        MyNodeManager(Project project) {
            super(project, null);
        }

        public DebuggerTreeNodeImpl createNode(NodeDescriptor descriptor, EvaluationContext evaluationContext) {
            return new DebuggerTreeNodeImpl(null, descriptor);
        }

        public DebuggerTreeNodeImpl createMessageNode(MessageDescriptor descriptor) {
            return new DebuggerTreeNodeImpl(null, (NodeDescriptor)descriptor);
        }

        public DebuggerTreeNodeImpl createMessageNode(String message) {
            return new DebuggerTreeNodeImpl(null, (NodeDescriptor)new MessageDescriptor(message));
        }
    }

    private class MyRootValue
    extends XValue {
        private final List<Value> myValues;
        private final EvaluationContextImpl myEvaluationContext;

        MyRootValue(@NotNull List<Value> values, EvaluationContextImpl evaluationContext) {
            this.myValues = values;
            this.myEvaluationContext = evaluationContext;
        }

        public void computeChildren(@NotNull XCompositeNode node) {
            XValueChildrenList children = new XValueChildrenList();
            for (Value value : this.myValues) {
                PrimitiveValueDescriptor valueDescriptor = new PrimitiveValueDescriptor(CollectionTree.this.myProject, value);
                children.add((XNamedValue)new InstanceJavaValue((ValueDescriptorImpl)valueDescriptor, this.myEvaluationContext, CollectionTree.this.myNodeManager));
            }
            node.addChildren(children, true);
        }

        public void computePresentation(@NotNull XValueNode node, @NotNull XValuePlace place) {
            node.setPresentation(null, "", "", true);
        }
    }
}

