/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.TraceContainer;
import com.intellij.debugger.streams.ui.ValuesSelectionListener;
import com.intellij.debugger.streams.ui.impl.CollectionTree;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.intellij.ui.JBColor;
import com.intellij.ui.components.JBLabel;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.util.ui.JBUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.jetbrains.annotations.NotNull;

public class CollectionView
extends JPanel
implements TraceContainer {
    private final CollectionTree myInstancesTree;

    CollectionView(@NotNull JLabel header, @NotNull CollectionTree collectionTree) {
        super(new BorderLayout());
        this.add((Component)header, "North");
        this.myInstancesTree = collectionTree;
        JBScrollPane scroll = new JBScrollPane((Component)((Object)this.myInstancesTree));
        this.add((Component)scroll, "Center");
        Disposer.register((Disposable)this, (Disposable)this.myInstancesTree);
    }

    CollectionView(@NotNull CollectionTree tree) {
        this(CollectionView.createDefaultLabel(tree), tree);
    }

    private static JLabel createDefaultLabel(@NotNull CollectionTree tree) {
        JBLabel label = new JBLabel(String.valueOf(tree.getItemsCount()), 0);
        label.setForeground((Color)JBColor.GRAY);
        Font oldFont = label.getFont();
        label.setFont(oldFont.deriveFont((float)oldFont.getSize() - JBUI.scale((float)1.0f)));
        label.setBorder((Border)JBUI.Borders.empty((int)3, (int)0));
        return label;
    }

    public void dispose() {
    }

    @Override
    public void highlight(@NotNull List<TraceElement> elements2) {
        this.myInstancesTree.highlight(elements2);
    }

    @Override
    public void select(@NotNull List<TraceElement> elements2) {
        this.myInstancesTree.select(elements2);
    }

    @Override
    public void addSelectionListener(@NotNull ValuesSelectionListener listener) {
        this.myInstancesTree.addSelectionListener(listener);
    }

    @Override
    public boolean highlightedExists() {
        return this.myInstancesTree.highlightedExists();
    }

    @NotNull
    protected CollectionTree getInstancesTree() {
        return this.myInstancesTree;
    }
}

