/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.debugger.streams.ui.impl;

import com.intellij.debugger.streams.trace.IntermediateState;
import com.intellij.debugger.streams.trace.NextAwareState;
import com.intellij.debugger.streams.trace.PrevAwareState;
import com.intellij.debugger.streams.trace.TraceElement;
import com.intellij.debugger.streams.ui.PropagationDirection;
import com.intellij.debugger.streams.ui.TraceContainer;
import com.intellij.debugger.streams.ui.TraceController;
import com.intellij.debugger.streams.ui.ValuesSelectionListener;
import com.intellij.debugger.streams.wrapper.StreamCall;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Disposer;
import com.sun.jdi.Value;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.stream.Collectors;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TraceControllerImpl
implements TraceController,
Disposable {
    private final List<TraceContainer> myTraceContainers = new CopyOnWriteArrayList<TraceContainer>();
    private final ValuesSelectionListener mySelectionListener;
    private final IntermediateState myState;
    private final PrevAwareState myToPrev;
    private final NextAwareState myToNext;
    private TraceController myPrevListener = null;
    private TraceController myNextListener = null;

    TraceControllerImpl(@NotNull IntermediateState state) {
        this.myState = state;
        this.myToPrev = state instanceof PrevAwareState ? (PrevAwareState)state : null;
        this.myToNext = state instanceof NextAwareState ? (NextAwareState)state : null;
        this.mySelectionListener = elements2 -> {
            this.selectAll(elements2);
            this.propagateForward(elements2);
            this.propagateBackward(elements2);
        };
    }

    public void dispose() {
    }

    void setPreviousController(@NotNull TraceController listener) {
        this.myPrevListener = listener;
    }

    void setNextController(@NotNull TraceController listener) {
        this.myNextListener = listener;
    }

    @Override
    @NotNull
    public List<Value> getValues() {
        return this.myState.getRawValues();
    }

    @Override
    @NotNull
    public List<TraceElement> getTrace() {
        return this.myState.getTrace();
    }

    @Override
    @Nullable
    public StreamCall getNextCall() {
        return this.myToNext == null ? null : this.myToNext.getNextCall();
    }

    @Override
    @Nullable
    public StreamCall getPrevCall() {
        return this.myToPrev == null ? null : this.myToPrev.getPrevCall();
    }

    @Override
    @NotNull
    public List<TraceElement> getNextValues(@NotNull TraceElement element) {
        return this.myToNext == null ? Collections.emptyList() : this.myToNext.getNextValues(element);
    }

    @Override
    @NotNull
    public List<TraceElement> getPrevValues(@NotNull TraceElement element) {
        return this.myToPrev == null ? Collections.emptyList() : this.myToPrev.getPrevValues(element);
    }

    @Override
    public boolean isSelectionExists(@NotNull PropagationDirection direction) {
        for (TraceContainer container : this.myTraceContainers) {
            if (!container.highlightedExists()) continue;
            return true;
        }
        return PropagationDirection.FORWARD.equals((Object)direction) ? this.selectionExistsForward() : this.selectionExistsBackward();
    }

    @Override
    public void register(@NotNull TraceContainer listener) {
        this.myTraceContainers.add(listener);
        listener.addSelectionListener(this.mySelectionListener);
        Disposer.register((Disposable)this, (Disposable)listener);
    }

    @Override
    public void highlightingChanged(@NotNull List<TraceElement> values, @NotNull PropagationDirection direction) {
        this.highlightAll(values);
        this.propagate(values, direction);
    }

    private void propagate(@NotNull List<TraceElement> values, @NotNull PropagationDirection direction) {
        if (direction.equals((Object)PropagationDirection.BACKWARD)) {
            this.propagateBackward(values);
        } else {
            this.propagateForward(values);
        }
    }

    private void propagateForward(@NotNull List<TraceElement> values) {
        if (this.myNextListener == null) {
            return;
        }
        List<TraceElement> nextValues = values.stream().flatMap(x -> this.getNextValues((TraceElement)x).stream()).collect(Collectors.toList());
        this.myNextListener.highlightingChanged(nextValues, PropagationDirection.FORWARD);
    }

    private void propagateBackward(@NotNull List<TraceElement> values) {
        if (this.myPrevListener == null) {
            return;
        }
        List<TraceElement> prevValues = values.stream().flatMap(x -> this.getPrevValues((TraceElement)x).stream()).collect(Collectors.toList());
        this.myPrevListener.highlightingChanged(prevValues, PropagationDirection.BACKWARD);
    }

    private void highlightAll(@NotNull List<TraceElement> values) {
        for (TraceContainer listener : this.myTraceContainers) {
            listener.highlight(values);
        }
    }

    private void selectAll(@NotNull List<TraceElement> values) {
        for (TraceContainer listener : this.myTraceContainers) {
            listener.select(values);
        }
    }

    private boolean selectionExistsForward() {
        return this.myNextListener != null && this.myNextListener.isSelectionExists(PropagationDirection.FORWARD);
    }

    private boolean selectionExistsBackward() {
        return this.myPrevListener != null && this.myPrevListener.isSelectionExists(PropagationDirection.BACKWARD);
    }
}

