/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Messages;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DialogManager {
    public static void show(@NotNull DialogWrapper dialog) {
        DialogManager.dialogManager().showDialog(dialog);
    }

    public static int showMessage(@NotNull String description, @NotNull String title, @NotNull String[] options, int defaultButtonIndex, int focusedButtonIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption dontAskOption) {
        return DialogManager.dialogManager().showMessageDialog(description, title, options, defaultButtonIndex, focusedButtonIndex, icon, dontAskOption);
    }

    public static int showOkCancelDialog(@NotNull Project project, @NotNull String message, @NotNull String title, @NotNull String okButtonText, @NotNull String cancelButtonText, @Nullable Icon icon) {
        return DialogManager.dialogManager().showMessageDialog(project, message, title, new String[]{okButtonText, cancelButtonText}, 0, icon);
    }

    public static int showYesNoCancelDialog(@NotNull Project project, @NotNull String message, @NotNull String title, @NotNull String yesButtonText, @NotNull String noButtonText, @NotNull String cancelButtonText, @Nullable Icon icon) {
        return DialogManager.dialogManager().showMessageDialog(project, message, title, new String[]{yesButtonText, noButtonText, cancelButtonText}, 0, 1, icon);
    }

    protected void showDialog(@NotNull DialogWrapper dialog) {
        dialog.show();
    }

    protected int showMessageDialog(@NotNull Project project, @NotNull String message, @NotNull String title, @NotNull String[] options, int defaultButtonIndex, @Nullable Icon icon) {
        return Messages.showDialog((Project)project, (String)message, (String)title, (String[])options, (int)defaultButtonIndex, (Icon)icon);
    }

    protected int showMessageDialog(@NotNull Project project, @NotNull String message, @NotNull String title, @NotNull String[] options, int defaultButtonIndex, int focusedButtonIndex, @Nullable Icon icon) {
        return Messages.showDialog((Project)project, (String)message, (String)title, null, (String[])options, (int)defaultButtonIndex, (int)focusedButtonIndex, (Icon)icon);
    }

    protected int showMessageDialog(@NotNull String description, @NotNull String title, @NotNull String[] options, int defaultButtonIndex, int focusedButtonIndex, @Nullable Icon icon, @Nullable DialogWrapper.DoNotAskOption dontAskOption) {
        return Messages.showDialog((String)description, (String)title, (String[])options, (int)defaultButtonIndex, (int)focusedButtonIndex, (Icon)icon, (DialogWrapper.DoNotAskOption)dontAskOption);
    }

    @NotNull
    private static DialogManager dialogManager() {
        return (DialogManager)ServiceManager.getService(DialogManager.class);
    }
}

