/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.vcs.log.Hash;
import com.intellij.vcs.log.VcsUser;
import com.intellij.vcs.log.impl.VcsChangesLazilyParsedDetails;
import com.intellij.vcs.log.impl.VcsFileStatusInfo;
import git4idea.history.GitChangesParser;
import git4idea.history.GitLogUtil;
import java.util.Date;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public final class GitCommit
extends VcsChangesLazilyParsedDetails {
    @NotNull
    private final GitLogUtil.DiffRenameLimit myRenameLimit;

    public GitCommit(Project project, @NotNull Hash hash, @NotNull List<Hash> parents, long commitTime, @NotNull VirtualFile root, @NotNull String subject, @NotNull VcsUser author, @NotNull String message, @NotNull VcsUser committer, long authorTime, @NotNull List<List<VcsFileStatusInfo>> reportedChanges, @NotNull GitLogUtil.DiffRenameLimit renameLimit) {
        super(hash, parents, commitTime, root, subject, author, message, committer, authorTime);
        this.myRenameLimit = renameLimit;
        this.myChanges.set(reportedChanges.isEmpty() ? EMPTY_CHANGES : new UnparsedChanges(project, reportedChanges));
    }

    public boolean hasRenames() {
        switch (this.myRenameLimit) {
            case INFINITY: {
                return true;
            }
            case GIT_CONFIG: {
                return false;
            }
            case NO_RENAMES: {
                return false;
            }
            case REGISTRY: {
                VcsChangesLazilyParsedDetails.Changes changes = (VcsChangesLazilyParsedDetails.Changes)this.myChanges.get();
                int estimate = changes instanceof UnparsedChanges ? ((UnparsedChanges)changes).getRenameLimitEstimate() : this.getRenameLimitEstimate();
                return estimate <= Registry.intValue((String)"git.diff.renameLimit");
            }
        }
        return true;
    }

    private int getRenameLimitEstimate() {
        int size = 0;
        for (int i = 0; i < this.getParents().size(); ++i) {
            int sources = 0;
            int targets = 0;
            for (Change info : this.getChanges(i)) {
                Change.Type type = info.getType();
                if (ContainerUtil.set((Object[])new Change.Type[]{Change.Type.DELETED, Change.Type.MOVED}).contains(type)) {
                    ++sources;
                }
                if (!ContainerUtil.set((Object[])new Change.Type[]{Change.Type.NEW}).contains(type)) continue;
                ++targets;
            }
            size = Math.max(Math.max(sources, targets), size);
        }
        return size;
    }

    private class UnparsedChanges
    extends VcsChangesLazilyParsedDetails.UnparsedChanges {
        private UnparsedChanges(@NotNull Project project, List<List<VcsFileStatusInfo>> changesOutput) {
            super((VcsChangesLazilyParsedDetails)GitCommit.this, project, changesOutput);
        }

        @NotNull
        protected List<Change> parseStatusInfo(@NotNull List<VcsFileStatusInfo> changes, int parentIndex) throws VcsException {
            String parentHash = null;
            if (parentIndex < GitCommit.this.getParents().size()) {
                parentHash = ((Hash)GitCommit.this.getParents().get(parentIndex)).asString();
            }
            return GitChangesParser.parse(this.myProject, GitCommit.this.getRoot(), changes, GitCommit.this.getId().asString(), new Date(GitCommit.this.getCommitTime()), parentHash);
        }

        int getRenameLimitEstimate() {
            int size = 0;
            for (List changesWithParent : this.myChangesOutput) {
                int sources = 0;
                int targets = 0;
                for (VcsFileStatusInfo info : changesWithParent) {
                    Change.Type type = info.getType();
                    if (ContainerUtil.set((Object[])new Change.Type[]{Change.Type.DELETED, Change.Type.MOVED}).contains(type)) {
                        ++sources;
                    }
                    if (!ContainerUtil.set((Object[])new Change.Type[]{Change.Type.NEW}).contains(type)) continue;
                    ++targets;
                }
                size = Math.max(Math.max(sources, targets), size);
            }
            return size;
        }
    }
}

