/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.changes.ByteBackedContentRevision;
import com.intellij.openapi.vcs.changes.ContentRevision;
import com.intellij.openapi.vcs.changes.CurrentContentRevision;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.impl.ContentRevisionCache;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitBinaryContentRevision;
import git4idea.GitRevisionNumber;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.diff.GitSubmoduleContentRevision;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.repo.GitSubmodule;
import git4idea.repo.GitSubmoduleKt;
import git4idea.util.GitFileUtils;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitContentRevision
implements ByteBackedContentRevision {
    @NotNull
    protected final FilePath myFile;
    @NotNull
    private final GitRevisionNumber myRevision;
    @NotNull
    private final Project myProject;
    @Nullable
    private final Charset myCharset;

    protected GitContentRevision(@NotNull FilePath file, @NotNull GitRevisionNumber revision, @NotNull Project project, @Nullable Charset charset) {
        this.myProject = project;
        this.myFile = file;
        this.myRevision = revision;
        this.myCharset = charset;
    }

    @Nullable
    public String getContent() throws VcsException {
        byte[] bytes = this.getContentAsBytes();
        if (bytes == null) {
            return null;
        }
        return ContentRevisionCache.getAsString((byte[])bytes, (FilePath)this.myFile, (Charset)this.myCharset);
    }

    @Nullable
    public byte[] getContentAsBytes() throws VcsException {
        if (this.myFile.isDirectory()) {
            return null;
        }
        try {
            return ContentRevisionCache.getOrLoadAsBytes((Project)this.myProject, (FilePath)this.myFile, (VcsRevisionNumber)this.myRevision, (VcsKey)GitVcs.getKey(), (ContentRevisionCache.UniqueType)ContentRevisionCache.UniqueType.REPOSITORY_CONTENT, this::loadContent);
        }
        catch (IOException e) {
            throw new VcsException((Throwable)e);
        }
    }

    private byte[] loadContent() throws VcsException {
        VirtualFile root = GitUtil.getGitRoot(this.myFile);
        return GitFileUtils.getFileContent(this.myProject, root, this.myRevision.getRev(), VcsFileUtil.relativePath((VirtualFile)root, (FilePath)this.myFile));
    }

    @NotNull
    public FilePath getFile() {
        return this.myFile;
    }

    @NotNull
    public VcsRevisionNumber getRevisionNumber() {
        return this.myRevision;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        GitContentRevision test = (GitContentRevision)obj;
        return this.myFile.equals(test.myFile) && this.myRevision.equals(test.myRevision);
    }

    public int hashCode() {
        return this.myFile.hashCode() + this.myRevision.hashCode();
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull VirtualFile vcsRoot, @NotNull String path, @Nullable VcsRevisionNumber revisionNumber, Project project, boolean unescapePath) throws VcsException {
        FilePath file = GitContentRevision.createPath(vcsRoot, path, unescapePath);
        return GitContentRevision.createRevision(file, revisionNumber, project, null);
    }

    @Nullable
    public static GitSubmodule getRepositoryIfSubmodule(@NotNull Project project, @NotNull FilePath path) {
        VirtualFile file = path.getVirtualFile();
        if (file == null) {
            return null;
        }
        if (!file.isDirectory()) {
            return null;
        }
        GitRepositoryManager repositoryManager = GitRepositoryManager.getInstance(project);
        GitRepository candidate = (GitRepository)repositoryManager.getRepositoryForRoot(file);
        if (candidate == null) {
            return null;
        }
        return GitSubmoduleKt.asSubmodule(candidate);
    }

    @NotNull
    public static ContentRevision createRevisionForTypeChange(@NotNull Project project, @NotNull VirtualFile vcsRoot, @NotNull String path, @Nullable VcsRevisionNumber revisionNumber, boolean unescapePath) throws VcsException {
        FilePath filePath;
        if (revisionNumber == null) {
            File file = new File(GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath));
            VirtualFile virtualFile = LocalFileSystem.getInstance().refreshAndFindFileByIoFile(file);
            filePath = virtualFile == null ? VcsUtil.getFilePath((File)file, (boolean)false) : VcsUtil.getFilePath((VirtualFile)virtualFile);
        } else {
            filePath = GitContentRevision.createPath(vcsRoot, path, unescapePath);
        }
        return GitContentRevision.createRevision(filePath, revisionNumber, project, null);
    }

    @NotNull
    public static FilePath createPath(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean unescapePath) throws VcsException {
        String absolutePath = GitContentRevision.makeAbsolutePath(vcsRoot, path, unescapePath);
        return VcsUtil.getFilePath((String)absolutePath, (boolean)false);
    }

    @NotNull
    private static String makeAbsolutePath(@NotNull VirtualFile vcsRoot, @NotNull String path, boolean unescapePath) throws VcsException {
        String unescapedPath = unescapePath ? GitUtil.unescapePath(path) : path;
        return vcsRoot.getPath() + "/" + unescapedPath;
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull VirtualFile file, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project) {
        FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
        return GitContentRevision.createRevision(filePath, revisionNumber, project, null);
    }

    @NotNull
    public static ContentRevision createRevision(@NotNull FilePath filePath, @Nullable VcsRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        GitSubmodule submodule = GitContentRevision.getRepositoryIfSubmodule(project, filePath);
        if (revisionNumber != null && revisionNumber != VcsRevisionNumber.NULL) {
            if (submodule != null) {
                return GitSubmoduleContentRevision.createRevision(submodule, revisionNumber);
            }
            return GitContentRevision.createRevisionImpl(filePath, (GitRevisionNumber)revisionNumber, project, charset);
        }
        if (submodule != null) {
            return GitSubmoduleContentRevision.createCurrentRevision(submodule.getRepository());
        }
        return CurrentContentRevision.create((FilePath)filePath);
    }

    @NotNull
    private static GitContentRevision createRevisionImpl(@NotNull FilePath path, @NotNull GitRevisionNumber revisionNumber, @NotNull Project project, @Nullable Charset charset) {
        if (path.getFileType().isBinary()) {
            return new GitBinaryContentRevision(path, revisionNumber, project);
        }
        return new GitContentRevision(path, revisionNumber, project, charset);
    }

    public String toString() {
        return this.myFile.getPath();
    }
}

