/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.text.FilePathHashingStrategy;
import gnu.trove.TObjectHashingStrategy;
import org.jetbrains.annotations.NotNull;

public abstract class GitReference
implements Comparable<GitReference> {
    public static final TObjectHashingStrategy<String> BRANCH_NAME_HASHING_STRATEGY = FilePathHashingStrategy.create();
    @NotNull
    protected final String myName;

    public GitReference(@NotNull String name) {
        this.myName = new String(name);
    }

    @NotNull
    public String getName() {
        return this.myName;
    }

    @NotNull
    public abstract String getFullName();

    public String toString() {
        return this.getFullName();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GitReference reference = (GitReference)o;
        return BRANCH_NAME_HASHING_STRATEGY.equals((Object)this.myName, (Object)reference.myName);
    }

    public int hashCode() {
        return BRANCH_NAME_HASHING_STRATEGY.computeHashCode((Object)this.myName);
    }

    @Override
    public int compareTo(GitReference o) {
        return o == null ? 1 : StringUtil.compare((String)this.getFullName(), (String)o.getFullName(), (boolean)SystemInfo.isFileSystemCaseSensitive);
    }
}

