/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.branch.DvcsTaskHandler;
import com.intellij.dvcs.repo.AbstractRepositoryManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.VcsTaskHandler;
import com.intellij.util.containers.ContainerUtil;
import git4idea.branch.GitBranchUtil;
import git4idea.branch.GitBrancher;
import git4idea.branch.GitBranchesCollection;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.validators.GitRefNameValidator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitTaskHandler
extends DvcsTaskHandler<GitRepository> {
    @NotNull
    private final GitBrancher myBrancher;
    @NotNull
    private final GitRefNameValidator myNameValidator;

    public GitTaskHandler(@NotNull GitBrancher brancher, @NotNull GitRepositoryManager repositoryManager, @NotNull Project project) {
        super((AbstractRepositoryManager)repositoryManager, project, "branch");
        this.myBrancher = brancher;
        this.myNameValidator = GitRefNameValidator.getInstance();
    }

    protected void checkout(@NotNull String taskName, @NotNull List<GitRepository> repos, @Nullable Runnable callInAwtLater) {
        this.myBrancher.checkout(taskName, false, repos, callInAwtLater);
    }

    protected void checkoutAsNewBranch(@NotNull String name, @NotNull List<GitRepository> repositories) {
        this.myBrancher.checkoutNewBranch(name, repositories);
    }

    protected String getActiveBranch(GitRepository repository) {
        return repository.getCurrentBranchName();
    }

    protected void mergeAndClose(@NotNull String branch, @NotNull List<GitRepository> repositories) {
        this.myBrancher.merge(branch, GitBrancher.DeleteOnMergeOption.DELETE, repositories);
    }

    protected boolean hasBranch(@NotNull GitRepository repository, @NotNull VcsTaskHandler.TaskInfo info) {
        GitBranchesCollection branches2 = repository.getBranches();
        return info.isRemote() ? branches2.getRemoteBranches().stream().anyMatch(branch -> info.getName().equals(branch.getName())) : branches2.findLocalBranch(info.getName()) != null;
    }

    @NotNull
    protected Iterable<VcsTaskHandler.TaskInfo> getAllBranches(@NotNull GitRepository repository) {
        GitBranchesCollection branches2 = repository.getBranches();
        ArrayList<VcsTaskHandler.TaskInfo> list = new ArrayList<VcsTaskHandler.TaskInfo>(ContainerUtil.map(GitBranchUtil.sortBranchesByName(branches2.getLocalBranches()), branch -> new VcsTaskHandler.TaskInfo(branch.getName(), Collections.singleton(repository.getPresentableUrl()))));
        list.addAll(ContainerUtil.map(GitBranchUtil.sortBranchesByName(branches2.getRemoteBranches()), branch -> new VcsTaskHandler.TaskInfo(branch.getName(), Collections.singleton(repository.getPresentableUrl())){

            public boolean isRemote() {
                return true;
            }
        }));
        return list;
    }

    public boolean isBranchNameValid(@NotNull String branchName) {
        return this.myNameValidator.checkInput(branchName);
    }

    @NotNull
    public String cleanUpBranchName(@NotNull String suggestedName) {
        return this.myNameValidator.cleanUpBranchName(suggestedName);
    }
}

