/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.dvcs.DvcsUtil;
import com.intellij.dvcs.repo.Repository;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogBuilder;
import com.intellij.openapi.ui.ex.MultiLineLabel;
import com.intellij.openapi.util.io.FileAttributes;
import com.intellij.openapi.util.io.FileSystemUtil;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangeListManagerEx;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.update.RefreshVFsSynchronously;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Convertor;
import com.intellij.util.containers.OpenTHashSet;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsImplUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitLocalBranch;
import git4idea.GitRemoteBranch;
import git4idea.GitStandardRemoteBranch;
import git4idea.GitVcs;
import git4idea.branch.GitBranchUtil;
import git4idea.changes.GitChangeUtils;
import git4idea.changes.GitCommittedChangeList;
import git4idea.commands.Git;
import git4idea.commands.GitCommand;
import git4idea.commands.GitCommandResult;
import git4idea.commands.GitHandler;
import git4idea.commands.GitLineHandler;
import git4idea.config.GitConfigUtil;
import git4idea.i18n.GitBundle;
import git4idea.repo.GitBranchTrackInfo;
import git4idea.repo.GitRemote;
import git4idea.repo.GitRepository;
import git4idea.repo.GitRepositoryManager;
import git4idea.util.GitSimplePathsBrowser;
import git4idea.util.GitUIUtil;
import git4idea.util.StringScanner;
import java.io.File;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitUtil {
    public static final String DOT_GIT = ".git";
    public static final String COMMENT_CHAR = "\u0001";
    public static final String ORIGIN_HEAD = "origin/HEAD";
    public static final Function<GitRepository, VirtualFile> REPOSITORY_TO_ROOT = repository -> repository.getRoot();
    public static final String HEAD = "HEAD";
    public static final String CHERRY_PICK_HEAD = "CHERRY_PICK_HEAD";
    public static final String MERGE_HEAD = "MERGE_HEAD";
    private static final String REPO_PATH_LINK_PREFIX = "gitdir:";
    private static final Logger LOG = Logger.getInstance(GitUtil.class);
    private static final String HEAD_FILE = "HEAD";

    private GitUtil() {
    }

    @Nullable
    public static VirtualFile findGitDir(@NotNull VirtualFile rootDir) {
        VirtualFile dotGit = VfsUtil.refreshAndFindChild((VirtualFile)rootDir, (String)DOT_GIT);
        if (dotGit == null) {
            return null;
        }
        if (dotGit.isDirectory()) {
            boolean headExists = VfsUtil.refreshAndFindChild((VirtualFile)dotGit, (String)"HEAD") != null;
            return headExists ? dotGit : null;
        }
        String content = GitUtil.readContent(dotGit);
        if (content == null) {
            return null;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        File file = GitUtil.findRealRepositoryDir(rootDir.getPath(), pathToDir);
        if (file == null) {
            return null;
        }
        return VcsUtil.getVirtualFileWithRefresh((File)file);
    }

    @Nullable
    private static File findRealRepositoryDir(@NotNull String rootPath, @NotNull String path) {
        File file;
        if (!FileUtil.isAbsolute((String)path)) {
            String canonicalPath = FileUtil.toCanonicalPath((String)FileUtil.join((String[])new String[]{rootPath, path}), (boolean)true);
            if (canonicalPath == null) {
                return null;
            }
            path = FileUtil.toSystemIndependentName((String)canonicalPath);
        }
        return (file = new File(path)).isDirectory() ? file : null;
    }

    @NotNull
    private static String parsePathToRepository(@NotNull String content) {
        return (content = content.trim()).startsWith(REPO_PATH_LINK_PREFIX) ? content.substring(REPO_PATH_LINK_PREFIX.length()).trim() : content;
    }

    @Nullable
    private static String readContent(@NotNull VirtualFile dotGit) {
        String content;
        try {
            content = GitUtil.readFile(dotGit);
        }
        catch (IOException e) {
            LOG.error("Couldn't read the content of " + dotGit, (Throwable)e);
            return null;
        }
        return content;
    }

    @NotNull
    public static String readFile(@NotNull VirtualFile file) throws IOException {
        int ATTEMPTS = 3;
        int attempt = 1;
        while (true) {
            try {
                return new String(file.contentsToByteArray(), CharsetToolkit.UTF8_CHARSET);
            }
            catch (IOException e) {
                LOG.info(String.format("IOException while reading %s (attempt #%s)", file, attempt));
                if (attempt++ < 3) continue;
                throw e;
            }
            break;
        }
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(@NotNull Collection<? extends VirtualFile> virtualFiles) throws VcsException {
        return GitUtil.sortFilesByGitRoot(virtualFiles, false);
    }

    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRoot(Collection<? extends VirtualFile> virtualFiles, boolean ignoreNonGit) throws VcsException {
        HashMap<VirtualFile, List<VirtualFile>> result2 = new HashMap<VirtualFile, List<VirtualFile>>();
        for (VirtualFile virtualFile : virtualFiles) {
            VirtualFile vcsRoot = GitUtil.gitRootOrNull(virtualFile.isDirectory() ? virtualFile.getParent() : virtualFile);
            if (vcsRoot == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + virtualFile.getPath() + " is not under Git");
            }
            ArrayList<VirtualFile> files = (ArrayList<VirtualFile>)result2.get(vcsRoot);
            if (files == null) {
                files = new ArrayList<VirtualFile>();
                result2.put(vcsRoot, files);
            }
            files.add(virtualFile);
        }
        return result2;
    }

    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(Collection<? extends FilePath> files) throws VcsException {
        return GitUtil.sortFilePathsByGitRoot(files, false);
    }

    @NotNull
    public static Map<VirtualFile, List<FilePath>> sortFilePathsByGitRoot(@NotNull Collection<? extends FilePath> files, boolean ignoreNonGit) throws VcsException {
        HashMap<VirtualFile, List<FilePath>> rc = new HashMap<VirtualFile, List<FilePath>>();
        for (FilePath filePath : files) {
            VirtualFile root = GitUtil.getGitRootOrNull(filePath);
            if (root == null) {
                if (ignoreNonGit) continue;
                throw new VcsException("The file " + filePath.getPath() + " is not under Git");
            }
            ArrayList<FilePath> l = (ArrayList<FilePath>)rc.get(root);
            if (l == null) {
                l = new ArrayList<FilePath>();
                rc.put(root, l);
            }
            l.add(filePath);
        }
        return rc;
    }

    public static Date parseTimestamp(String value) {
        long parsed = Long.parseLong(value.trim());
        return new Date(parsed * 1000L);
    }

    public static Date parseTimestampWithNFEReport(String value, GitHandler handler, String gitOutput) {
        try {
            return GitUtil.parseTimestamp(value);
        }
        catch (NumberFormatException e) {
            LOG.error("annotate(). NFE. Handler: " + handler + ". Output: " + gitOutput, (Throwable)e);
            return new Date();
        }
    }

    public static Set<VirtualFile> gitRootsForPaths(Collection<? extends VirtualFile> roots) {
        HashSet<VirtualFile> rc = new HashSet<VirtualFile>();
        for (VirtualFile virtualFile : roots) {
            VirtualFile gitRoot = GitUtil.getGitRootOrNull(VcsUtil.getFilePath((VirtualFile)virtualFile));
            if (gitRoot == null) continue;
            rc.add(gitRoot);
        }
        return rc;
    }

    @Deprecated
    public static VirtualFile getGitRoot(@NotNull FilePath filePath) throws VcsException {
        VirtualFile root = GitUtil.getGitRootOrNull(filePath);
        if (root != null) {
            return root;
        }
        throw new VcsException("The file " + filePath + " is not under git.");
    }

    @Deprecated
    @Nullable
    public static VirtualFile getGitRootOrNull(@NotNull FilePath filePath) {
        for (File root = filePath.getIOFile(); root != null; root = root.getParentFile()) {
            if (!GitUtil.isGitRoot(root)) continue;
            return LocalFileSystem.getInstance().findFileByIoFile(root);
        }
        return null;
    }

    public static boolean isGitRoot(@NotNull File folder) {
        return GitUtil.isGitRoot(folder.getPath());
    }

    @Deprecated
    public static VirtualFile getGitRoot(@NotNull VirtualFile file) throws VcsException {
        VirtualFile root = GitUtil.gitRootOrNull(file);
        if (root != null) {
            return root;
        }
        throw new VcsException("The file " + file.getPath() + " is not under git.");
    }

    @Deprecated
    @Nullable
    public static VirtualFile gitRootOrNull(VirtualFile file) {
        return GitUtil.getGitRootOrNull(VcsUtil.getFilePath((String)file.getPath()));
    }

    @Deprecated
    @NotNull
    public static List<VirtualFile> getGitRoots(Project project, GitVcs vcs) throws VcsException {
        VirtualFile[] contentRoots = ProjectLevelVcsManager.getInstance((Project)project).getRootsUnderVcs((AbstractVcs)vcs);
        if (contentRoots == null || contentRoots.length == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.unconfigured.message"));
        }
        List sortedRoots = DvcsUtil.sortVirtualFilesByPresentation(GitUtil.gitRootsForPaths(Arrays.asList(contentRoots)));
        if (sortedRoots.size() == 0) {
            throw new VcsException(GitBundle.getString("repository.action.missing.roots.misconfigured"));
        }
        return sortedRoots;
    }

    public static boolean isUnderGit(VirtualFile vFile) {
        return GitUtil.gitRootOrNull(vFile) != null;
    }

    public static String adjustAuthorName(String authorName, String committerName) {
        if (!authorName.equals(committerName)) {
            committerName = authorName + ", via " + committerName;
        }
        return committerName;
    }

    public static boolean isUnderGit(FilePath path) {
        return GitUtil.getGitRootOrNull(path) != null;
    }

    public static Set<VirtualFile> gitRoots(Collection<? extends FilePath> filePaths) {
        return filePaths.stream().map(GitUtil::getGitRootOrNull).filter(Objects::nonNull).collect(Collectors.toSet());
    }

    public static String gitTime(Date time) {
        long t = time.getTime() / 1000L;
        return Long.toString(t);
    }

    public static String formatLongRev(long rev) {
        return String.format("%015x%x", rev >>> 4, rev & 0xFL);
    }

    public static void getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier, Consumer<? super GitCommittedChangeList> consumer, boolean skipDiffsForMerge) throws VcsException {
        GitLineHandler h = new GitLineHandler(project, root, GitCommand.LOG);
        h.setSilent(true);
        h.addParameters("--pretty=format:%x04%x01%ct%n%H%n%P%n%an%x20%x3C%ae%x3E%n%cn%x20%x3C%ce%x3E%n%s%n%x03%n%b%n%x03", "--name-status");
        parametersSpecifier.consume((Object)h);
        String output = Git.getInstance().runCommand(h).getOutputOrThrow(new int[0]);
        LOG.debug("getLocalCommittedChanges output: '" + output + "'");
        StringScanner s = new StringScanner(output);
        StringBuilder sb = new StringBuilder();
        boolean firstStep = true;
        while (s.hasMoreData()) {
            String line = s.line();
            boolean lineIsAStart = line.startsWith("\u0004\u0001");
            if (!firstStep && lineIsAStart) {
                StringScanner innerScanner = new StringScanner(sb.toString());
                sb.setLength(0);
                consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
            }
            sb.append(lineIsAStart ? line.substring(2) : line).append('\n');
            firstStep = false;
        }
        if (sb.length() > 0) {
            StringScanner innerScanner = new StringScanner(sb.toString());
            sb.setLength(0);
            consumer.consume((Object)GitChangeUtils.parseChangeList(project, root, innerScanner, skipDiffsForMerge, h, false, false));
        }
        if (s.hasMoreData()) {
            throw new IllegalStateException("More input is avaialble: " + s.line());
        }
    }

    public static List<GitCommittedChangeList> getLocalCommittedChanges(Project project, VirtualFile root, Consumer<? super GitHandler> parametersSpecifier) throws VcsException {
        ArrayList<GitCommittedChangeList> rc = new ArrayList<GitCommittedChangeList>();
        GitUtil.getLocalCommittedChanges(project, root, parametersSpecifier, (Consumer<? super GitCommittedChangeList>)((Consumer)committedChangeList -> rc.add((GitCommittedChangeList)((Object)committedChangeList))), false);
        return rc;
    }

    @NotNull
    public static String unescapePath(@NotNull String path) throws VcsException {
        String QUOTE = "\"";
        if (path.startsWith("\"") && path.endsWith("\"")) {
            path = path.substring(1, path.length() - 1);
        }
        int l = path.length();
        StringBuilder rc = new StringBuilder(l);
        for (int i = 0; i < path.length(); ++i) {
            char c = path.charAt(i);
            if (c == '\\') {
                if (++i >= l) {
                    throw new VcsException("Unterminated escape sequence in the path: " + path);
                }
                char e = path.charAt(i);
                switch (e) {
                    case '\\': {
                        rc.append('\\');
                        break;
                    }
                    case 't': {
                        rc.append('\t');
                        break;
                    }
                    case 'n': {
                        rc.append('\n');
                        break;
                    }
                    case 'r': {
                        rc.append('\r');
                        break;
                    }
                    case 'a': {
                        rc.append('\u0007');
                        break;
                    }
                    case 'b': {
                        rc.append('\b');
                        break;
                    }
                    case 'f': {
                        rc.append('\f');
                        break;
                    }
                    case '\"': {
                        rc.append('\"');
                        break;
                    }
                    default: {
                        if (VcsFileUtil.isOctal((char)e)) {
                            int n = 0;
                            for (int j = i; j < l; ++j) {
                                if (VcsFileUtil.isOctal((char)path.charAt(j))) {
                                    ++n;
                                    for (int k = 0; k < 3 && j < l && VcsFileUtil.isOctal((char)path.charAt(j)); ++j, ++k) {
                                    }
                                }
                                if (j + 1 >= l || path.charAt(j) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(j + 1))) break;
                            }
                            byte[] b = new byte[n];
                            n = 0;
                            while (i < l) {
                                if (VcsFileUtil.isOctal((char)path.charAt(i))) {
                                    int code = 0;
                                    for (int k = 0; k < 3 && i < l && VcsFileUtil.isOctal((char)path.charAt(i)); ++i, ++k) {
                                        code = code * 8 + (path.charAt(i) - 48);
                                    }
                                    b[n++] = (byte)code;
                                }
                                if (i + 1 >= l || path.charAt(i) != '\\' || !VcsFileUtil.isOctal((char)path.charAt(i + 1))) break;
                                ++i;
                            }
                            --i;
                            assert (n == b.length);
                            String encoding = GitConfigUtil.getFileNameEncoding();
                            try {
                                rc.append(new String(b, encoding));
                                break;
                            }
                            catch (UnsupportedEncodingException e1) {
                                throw new IllegalStateException("The file name encoding is unsupported: " + encoding);
                            }
                        }
                        throw new VcsException("Unknown escape sequence '\\" + path.charAt(i) + "' in the path: " + path);
                    }
                }
                continue;
            }
            rc.append(c);
        }
        return rc.toString();
    }

    public static boolean justOneGitRepository(Project project) {
        if (project.isDisposed()) {
            return true;
        }
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        return !manager.moreThanOneRoot();
    }

    @Nullable
    public static GitRemote findRemoteByName(@NotNull GitRepository repository, @NotNull String name) {
        return GitUtil.findRemoteByName(repository.getRemotes(), name);
    }

    @Nullable
    public static GitRemote findRemoteByName(Collection<GitRemote> remotes, @NotNull String name) {
        return (GitRemote)ContainerUtil.find(remotes, remote -> remote.getName().equals(name));
    }

    @Nullable
    public static GitRemoteBranch findRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String nameAtRemote) {
        return (GitRemoteBranch)ContainerUtil.find(repository.getBranches().getRemoteBranches(), remoteBranch -> remoteBranch.getRemote().equals(remote) && remoteBranch.getNameForRemoteOperations().equals(GitBranchUtil.stripRefsPrefix(nameAtRemote)));
    }

    @NotNull
    public static GitRemoteBranch findOrCreateRemoteBranch(@NotNull GitRepository repository, @NotNull GitRemote remote, @NotNull String branchName) {
        GitRemoteBranch remoteBranch = GitUtil.findRemoteBranch(repository, remote, branchName);
        return (GitRemoteBranch)ObjectUtils.notNull((Object)remoteBranch, (Object)new GitStandardRemoteBranch(remote, branchName));
    }

    @NotNull
    public static Collection<VirtualFile> getRootsFromRepositories(@NotNull Collection<? extends GitRepository> repositories) {
        return ContainerUtil.map(repositories, REPOSITORY_TO_ROOT);
    }

    @NotNull
    public static Collection<GitRepository> getRepositoriesFromRoots(@NotNull GitRepositoryManager repositoryManager, @NotNull Collection<? extends VirtualFile> roots) {
        ArrayList<GitRepository> repositories = new ArrayList<GitRepository>(roots.size());
        for (VirtualFile virtualFile : roots) {
            GitRepository repo = (GitRepository)repositoryManager.getRepositoryForRoot(virtualFile);
            if (repo == null) {
                LOG.error("Repository not found for root " + virtualFile);
                continue;
            }
            repositories.add(repo);
        }
        return repositories;
    }

    @NotNull
    public static Collection<String> getPathsDiffBetweenRefs(@NotNull Git git, @NotNull GitRepository repository, @NotNull String beforeRef, @NotNull String afterRef) throws VcsException {
        String range;
        List<String> parameters = Arrays.asList("--name-only", "--pretty=format:");
        GitCommandResult result2 = git.diff(repository, parameters, range = beforeRef + ".." + afterRef);
        if (!result2.success()) {
            LOG.info(String.format("Couldn't get diff in range [%s] for repository [%s]", range, repository.toLogString()));
            return Collections.emptyList();
        }
        HashSet<String> remoteChanges = new HashSet<String>();
        StringScanner s = new StringScanner(result2.getOutputAsJoinedString());
        while (s.hasMoreData()) {
            String relative = s.line();
            if (StringUtil.isEmptyOrSpaces((String)relative)) continue;
            String path = repository.getRoot().getPath() + "/" + GitUtil.unescapePath(relative);
            remoteChanges.add(path);
        }
        return remoteChanges;
    }

    @NotNull
    public static GitRepositoryManager getRepositoryManager(@NotNull Project project) {
        return GitRepositoryManager.getInstance(project);
    }

    @Nullable
    public static GitRepository getRepositoryForRootOrLogError(@NotNull Project project, @NotNull VirtualFile root) {
        GitRepositoryManager manager = GitUtil.getRepositoryManager(project);
        GitRepository repository = (GitRepository)manager.getRepositoryForRoot(root);
        if (repository == null) {
            LOG.error("Repository is null for root " + root);
        }
        return repository;
    }

    @NotNull
    public static String getPrintableRemotes(@NotNull Collection<GitRemote> remotes) {
        return StringUtil.join(remotes, remote -> remote.getName() + ": [" + StringUtil.join(remote.getUrls(), (String)", ") + "]", (String)"\n");
    }

    public static void showSubmittedFiles(final Project project, final String revision, final VirtualFile file, final boolean local, final boolean revertable) {
        new Task.Backgroundable(project, GitBundle.message("changes.retrieving", revision)){

            public void run(@NotNull ProgressIndicator indicator) {
                indicator.setIndeterminate(true);
                try {
                    VirtualFile vcsRoot = GitUtil.getGitRoot(file);
                    GitCommittedChangeList changeList = GitChangeUtils.getRevisionChanges(project, vcsRoot, revision, true, local, revertable);
                    if (changeList != null) {
                        UIUtil.invokeLaterIfNeeded(() -> 1.lambda$run$0(project, (CommittedChangeList)changeList, revision));
                    }
                }
                catch (VcsException e) {
                    UIUtil.invokeLaterIfNeeded(() -> GitUIUtil.showOperationError(project, e, "git show"));
                }
            }

            private static /* synthetic */ void lambda$run$0(Project project2, CommittedChangeList changeList, String revision2) {
                AbstractVcsHelper.getInstance((Project)project2).showChangesListBrowser(changeList, GitBundle.message("paths.affected.title", revision2));
            }
        }.queue();
    }

    @Nullable
    public static GitBranchTrackInfo getTrackInfoForCurrentBranch(@NotNull GitRepository repository) {
        GitLocalBranch currentBranch = repository.getCurrentBranch();
        if (currentBranch == null) {
            return null;
        }
        return GitBranchUtil.getTrackInfoForBranch(repository, currentBranch);
    }

    @NotNull
    public static Map<VirtualFile, List<VirtualFile>> sortFilesByGitRootsIgnoringOthers(@NotNull Collection<? extends VirtualFile> files) {
        try {
            return GitUtil.sortFilesByGitRoot(files, true);
        }
        catch (VcsException e) {
            LOG.error("Should never happen, since we passed 'ignore non-git' parameter", (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static boolean hasLocalChanges(boolean staged, Project project, VirtualFile root) throws VcsException {
        GitLineHandler diff = new GitLineHandler(project, root, GitCommand.DIFF);
        diff.addParameters("--name-only");
        diff.addParameters("--no-renames");
        if (staged) {
            diff.addParameters("--cached");
        }
        diff.setStdoutSuppressed(true);
        diff.setStderrSuppressed(true);
        diff.setSilent(true);
        String output = Git.getInstance().runCommand(diff).getOutputOrThrow(new int[0]);
        return !output.trim().isEmpty();
    }

    @Nullable
    public static VirtualFile findRefreshFileOrLog(@NotNull String absolutePath) {
        VirtualFile file = LocalFileSystem.getInstance().findFileByPath(absolutePath);
        if (file == null) {
            file = LocalFileSystem.getInstance().refreshAndFindFileByPath(absolutePath);
        }
        if (file == null) {
            LOG.debug("VirtualFile not found for " + absolutePath);
        }
        return file;
    }

    @NotNull
    public static String toAbsolute(@NotNull VirtualFile root, @NotNull String relativePath) {
        return StringUtil.trimEnd((String)root.getPath(), (String)"/") + "/" + StringUtil.trimStart((String)relativePath, (String)"/");
    }

    @NotNull
    public static Collection<String> toAbsolute(@NotNull VirtualFile root, @NotNull Collection<String> relativePaths) {
        return ContainerUtil.map(relativePaths, s -> GitUtil.toAbsolute(root, s));
    }

    @NotNull
    public static List<Change> findLocalChangesForPaths(@NotNull Project project, @NotNull VirtualFile root, @NotNull Collection<String> affectedPaths, boolean relativePaths) {
        ChangeListManagerEx changeListManager = (ChangeListManagerEx)ChangeListManager.getInstance((Project)project);
        ArrayList<Change> affectedChanges = new ArrayList<Change>();
        for (String path : affectedPaths) {
            String absolutePath = relativePaths ? GitUtil.toAbsolute(root, path) : path;
            VirtualFile file = GitUtil.findRefreshFileOrLog(absolutePath);
            if (file == null) continue;
            Change change = changeListManager.getChange(file);
            if (change != null) {
                affectedChanges.add(change);
                continue;
            }
            String message = "Change is not found for " + file.getPath();
            if (changeListManager.isInUpdate()) {
                message = message + " because ChangeListManager is being updated.";
            }
            LOG.debug(message);
        }
        return affectedChanges;
    }

    public static void showPathsInDialog(@NotNull Project project, @NotNull Collection<String> absolutePaths, @NotNull String title, @Nullable String description) {
        DialogBuilder builder = new DialogBuilder(project);
        builder.setCenterPanel((JComponent)new GitSimplePathsBrowser(project, absolutePaths));
        if (description != null) {
            builder.setNorthPanel((JComponent)new MultiLineLabel(description));
        }
        builder.addOkAction();
        builder.setTitle(title);
        builder.show();
    }

    @NotNull
    public static String cleanupErrorPrefixes(@NotNull String msg) {
        String[] PREFIXES = new String[]{"fatal:", "error:"};
        msg = msg.trim();
        for (String prefix : PREFIXES) {
            if (!msg.startsWith(prefix)) continue;
            msg = msg.substring(prefix.length()).trim();
        }
        return msg;
    }

    @Nullable
    public static GitRemote getDefaultRemote(@NotNull Collection<GitRemote> remotes) {
        return (GitRemote)ContainerUtil.find(remotes, r -> r.getName().equals("origin"));
    }

    @Nullable
    public static GitRemote getDefaultOrFirstRemote(@NotNull Collection<GitRemote> remotes) {
        return (GitRemote)ObjectUtils.chooseNotNull((Object)GitUtil.getDefaultRemote(remotes), (Object)ContainerUtil.getFirstItem(remotes));
    }

    @NotNull
    public static String joinToHtml(@NotNull Collection<? extends GitRepository> repositories) {
        return StringUtil.join(repositories, repository -> repository.getPresentableUrl(), (String)"<br/>");
    }

    @NotNull
    public static String mention(@NotNull GitRepository repository) {
        return GitUtil.getRepositoryManager(repository.getProject()).moreThanOneRoot() ? " in " + DvcsUtil.getShortRepositoryName((Repository)repository) : "";
    }

    @NotNull
    public static String mention(@NotNull Collection<? extends GitRepository> repositories) {
        return GitUtil.mention(repositories, -1);
    }

    @NotNull
    public static String mention(@NotNull Collection<? extends GitRepository> repositories, int limit) {
        if (repositories.isEmpty()) {
            return "";
        }
        return " in " + DvcsUtil.joinShortNames(repositories, (int)limit);
    }

    public static void updateRepositories(@NotNull Collection<? extends GitRepository> repositories) {
        for (GitRepository gitRepository : repositories) {
            gitRepository.update();
        }
    }

    public static boolean hasGitRepositories(@NotNull Project project) {
        return !GitUtil.getRepositories(project).isEmpty();
    }

    @NotNull
    public static Collection<GitRepository> getRepositories(@NotNull Project project) {
        return GitUtil.getRepositoryManager(project).getRepositories();
    }

    public static boolean isCaseOnlyChange(@NotNull String oldPath, @NotNull String newPath) {
        if (oldPath.equalsIgnoreCase(newPath)) {
            if (oldPath.equals(newPath)) {
                LOG.info("Comparing perfectly equal paths: " + newPath);
            }
            return true;
        }
        return false;
    }

    @NotNull
    public static String getLogString(@NotNull String root, @NotNull Collection<? extends Change> changes) {
        return GitUtil.getLogString(root, changes, ChangesUtil::getBeforePath, ChangesUtil::getAfterPath);
    }

    @NotNull
    public static <T> String getLogString(@NotNull String root, @NotNull Collection<T> changes, @NotNull Convertor<? super T, ? extends FilePath> beforePathGetter, @NotNull Convertor<? super T, ? extends FilePath> afterPathGetter) {
        return StringUtil.join(changes, change -> {
            FilePath after = (FilePath)afterPathGetter.convert(change);
            FilePath before = (FilePath)beforePathGetter.convert(change);
            if (before == null) {
                return "A: " + GitUtil.getRelativePath(root, after);
            }
            if (after == null) {
                return "D: " + GitUtil.getRelativePath(root, before);
            }
            if (ChangesUtil.CASE_SENSITIVE_FILE_PATH_HASHING_STRATEGY.equals((Object)before, (Object)after)) {
                return "M: " + GitUtil.getRelativePath(root, after);
            }
            return "R: " + GitUtil.getRelativePath(root, before) + " -> " + GitUtil.getRelativePath(root, after);
        }, (String)", ");
    }

    @Nullable
    public static String getRelativePath(@NotNull String root, @NotNull FilePath after) {
        return FileUtil.getRelativePath((String)root, (String)after.getPath(), (char)File.separatorChar);
    }

    @NotNull
    public static Collection<Change> findCorrespondentLocalChanges(@NotNull ChangeListManager changeListManager, @NotNull Collection<? extends Change> originalChanges) {
        OpenTHashSet allChanges = new OpenTHashSet(changeListManager.getAllChanges());
        return ContainerUtil.mapNotNull(originalChanges, arg_0 -> ((OpenTHashSet)allChanges).get(arg_0));
    }

    public static void refreshVfs(@NotNull VirtualFile root, @Nullable Collection<Change> changes) {
        if (changes == null || Registry.is((String)"git.refresh.vfs.total")) {
            VfsUtil.markDirtyAndRefresh((boolean)false, (boolean)true, (boolean)false, (VirtualFile[])new VirtualFile[]{root});
        } else {
            RefreshVFsSynchronously.updateChanges(changes);
        }
    }

    public static void updateAndRefreshVfs(@NotNull GitRepository repository, @Nullable Collection<Change> changes) {
        repository.update();
        GitUtil.refreshVfs(repository.getRoot(), changes);
    }

    public static void updateAndRefreshVfs(GitRepository ... repositories) {
        Arrays.stream(repositories).forEach(Repository::update);
        for (GitRepository repository : repositories) {
            GitUtil.refreshVfs(repository.getRoot(), null);
        }
    }

    public static boolean isGitRoot(@NotNull String rootDir) {
        String dotGit = rootDir + File.separatorChar + DOT_GIT;
        FileAttributes attributes = FileSystemUtil.getAttributes((String)dotGit);
        if (attributes == null) {
            return false;
        }
        if (attributes.isDirectory()) {
            FileAttributes headExists = FileSystemUtil.getAttributes((String)(dotGit + File.separatorChar + "HEAD"));
            return headExists != null && headExists.isFile();
        }
        if (!attributes.isFile()) {
            return false;
        }
        String content = DvcsUtil.tryLoadFileOrReturn((File)new File(dotGit), null, (String)"UTF-8");
        if (content == null) {
            return false;
        }
        String pathToDir = GitUtil.parsePathToRepository(content);
        return GitUtil.findRealRepositoryDir(rootDir, pathToDir) != null;
    }

    public static void generateGitignoreFileIfNeeded(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        VcsImplUtil.generateIgnoreFileIfNeeded((Project)project, (AbstractVcs)GitVcs.getInstance(project), (VirtualFile)ignoreFileRoot);
    }

    public static void proposeUpdateGitignore(@NotNull Project project, @NotNull VirtualFile ignoreFileRoot) {
        VcsImplUtil.proposeUpdateIgnoreFile((Project)project, (AbstractVcs)GitVcs.getInstance(project), (VirtualFile)ignoreFileRoot);
    }
}

