/*
 * Decompiled with CFR 0.152.
 */
package git4idea;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.diff.impl.patch.formove.FilePathComparator;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.progress.util.BackgroundTaskUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.CheckoutProvider;
import com.intellij.openapi.vcs.CommittedChangesProvider;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.RemoteDifferenceStrategy;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.VcsKey;
import com.intellij.openapi.vcs.VcsOutgoingChangesProvider;
import com.intellij.openapi.vcs.VcsType;
import com.intellij.openapi.vcs.changes.ChangeProvider;
import com.intellij.openapi.vcs.changes.CommitExecutor;
import com.intellij.openapi.vcs.checkin.CheckinEnvironment;
import com.intellij.openapi.vcs.diff.DiffProvider;
import com.intellij.openapi.vcs.diff.RevisionSelector;
import com.intellij.openapi.vcs.history.VcsRevisionNumber;
import com.intellij.openapi.vcs.merge.MergeProvider;
import com.intellij.openapi.vcs.rollback.RollbackEnvironment;
import com.intellij.openapi.vcs.roots.VcsRootDetector;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.versionBrowser.CommittedChangeList;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ui.UIUtil;
import com.intellij.vcs.AnnotationProviderEx;
import com.intellij.vcs.log.VcsUserRegistry;
import git4idea.GitRevisionNumber;
import git4idea.GitRevisionSelector;
import git4idea.GitRootConverter;
import git4idea.GitUserRegistry;
import git4idea.GitUtil;
import git4idea.annotate.GitAnnotationProvider;
import git4idea.annotate.GitRepositoryForAnnotationsListener;
import git4idea.branch.GitBranchIncomingOutgoingManager;
import git4idea.changes.GitCommittedChangeListProvider;
import git4idea.changes.GitOutgoingChangesProvider;
import git4idea.checkin.GitCheckinEnvironment;
import git4idea.checkin.GitCommitAndPushExecutor;
import git4idea.checkout.GitCheckoutProvider;
import git4idea.commands.Git;
import git4idea.config.GitExecutableManager;
import git4idea.config.GitExecutableValidator;
import git4idea.config.GitSharedSettings;
import git4idea.config.GitVcsApplicationSettings;
import git4idea.config.GitVcsConfigurable;
import git4idea.config.GitVcsSettings;
import git4idea.config.GitVersion;
import git4idea.diff.GitDiffProvider;
import git4idea.history.GitHistoryProvider;
import git4idea.i18n.GitBundle;
import git4idea.merge.GitMergeProvider;
import git4idea.rollback.GitRollbackEnvironment;
import git4idea.roots.GitIntegrationEnabler;
import git4idea.status.GitChangeProvider;
import git4idea.ui.branch.GitBranchWidget;
import git4idea.update.GitUpdateEnvironment;
import git4idea.util.GitVcsConsoleWriter;
import git4idea.vfs.GitVFSListener;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.Function;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GitVcs
extends AbstractVcs<CommittedChangeList> {
    public static final String NAME = "Git";
    public static final String ID = "git";
    private static final Logger LOG = Logger.getInstance((String)GitVcs.class.getName());
    private static final VcsKey ourKey = GitVcs.createKey((String)"Git");
    @Nullable
    private final ChangeProvider myChangeProvider;
    @Nullable
    private final GitCheckinEnvironment myCheckinEnvironment;
    private final RollbackEnvironment myRollbackEnvironment;
    @NotNull
    private final GitExecutableManager myExecutableManager;
    private final GitUpdateEnvironment myUpdateEnvironment;
    private final GitAnnotationProvider myAnnotationProvider;
    private final DiffProvider myDiffProvider;
    private final GitHistoryProvider myHistoryProvider;
    @NotNull
    private final Git myGit;
    private final GitVcsConsoleWriter myVcsConsoleWriter;
    private final Configurable myConfigurable;
    private final RevisionSelector myRevSelector;
    private final GitCommittedChangeListProvider myCommittedChangeListProvider;
    private GitVFSListener myVFSListener;
    private final ReadWriteLock myCommandLock = new ReentrantReadWriteLock(true);
    @Nullable
    private final GitCommitAndPushExecutor myCommitAndPushExecutor;
    private final GitExecutableValidator myExecutableValidator;
    private GitBranchWidget myBranchWidget;
    private GitRepositoryForAnnotationsListener myRepositoryForAnnotationsListener;
    private final VcsOutgoingChangesProvider<CommittedChangeList> myOutgoingChangesProvider;

    @NotNull
    public static GitVcs getInstance(@NotNull Project project) {
        return (GitVcs)((Object)ObjectUtils.notNull((Object)((Object)((GitVcs)ProjectLevelVcsManager.getInstance((Project)project).findVcsByName(NAME)))));
    }

    public GitVcs(@NotNull Project project, @NotNull Git git, @NotNull GitVcsConsoleWriter vcsConsoleWriter, @NotNull GitAnnotationProvider gitAnnotationProvider, @NotNull GitDiffProvider gitDiffProvider, @NotNull GitHistoryProvider gitHistoryProvider, @NotNull GitRollbackEnvironment gitRollbackEnvironment, @NotNull GitVcsApplicationSettings gitSettings, @NotNull GitVcsSettings gitProjectSettings, @NotNull GitExecutableManager executableManager, @NotNull GitSharedSettings sharedSettings) {
        super(project, NAME);
        this.myGit = git;
        this.myVcsConsoleWriter = vcsConsoleWriter;
        this.myChangeProvider = project.isDefault() ? null : (ChangeProvider)ServiceManager.getService((Project)project, GitChangeProvider.class);
        this.myCheckinEnvironment = project.isDefault() ? null : (GitCheckinEnvironment)ServiceManager.getService((Project)project, GitCheckinEnvironment.class);
        this.myAnnotationProvider = gitAnnotationProvider;
        this.myDiffProvider = gitDiffProvider;
        this.myHistoryProvider = gitHistoryProvider;
        this.myRollbackEnvironment = gitRollbackEnvironment;
        this.myExecutableManager = executableManager;
        this.myRevSelector = new GitRevisionSelector();
        this.myConfigurable = new GitVcsConfigurable(gitSettings, this.myProject, gitProjectSettings, sharedSettings, executableManager);
        this.myUpdateEnvironment = new GitUpdateEnvironment(this.myProject, gitProjectSettings);
        this.myCommittedChangeListProvider = new GitCommittedChangeListProvider(this.myProject);
        this.myOutgoingChangesProvider = new GitOutgoingChangesProvider(this.myProject);
        this.myCommitAndPushExecutor = this.myCheckinEnvironment != null ? new GitCommitAndPushExecutor(this.myCheckinEnvironment) : null;
        this.myExecutableValidator = new GitExecutableValidator(this.myProject);
    }

    public ReadWriteLock getCommandLock() {
        return this.myCommandLock;
    }

    public static void runInBackground(Task.Backgroundable task) {
        task.queue();
    }

    public CommittedChangesProvider getCommittedChangesProvider() {
        return this.myCommittedChangeListProvider;
    }

    public String getRevisionPattern() {
        return "[0-9a-fA-F]+";
    }

    @Nullable
    public CheckinEnvironment createCheckinEnvironment() {
        return this.myCheckinEnvironment;
    }

    @NotNull
    public MergeProvider getMergeProvider() {
        return GitMergeProvider.detect(this.myProject);
    }

    @NotNull
    public RollbackEnvironment createRollbackEnvironment() {
        return this.myRollbackEnvironment;
    }

    @NotNull
    public GitHistoryProvider getVcsHistoryProvider() {
        return this.myHistoryProvider;
    }

    public GitHistoryProvider getVcsBlockHistoryProvider() {
        return this.myHistoryProvider;
    }

    @NotNull
    public String getDisplayName() {
        return NAME;
    }

    @Nullable
    public UpdateEnvironment createUpdateEnvironment() {
        return this.myUpdateEnvironment;
    }

    @NotNull
    public AnnotationProviderEx getAnnotationProvider() {
        return this.myAnnotationProvider;
    }

    @NotNull
    public DiffProvider getDiffProvider() {
        return this.myDiffProvider;
    }

    @Nullable
    public RevisionSelector getRevisionSelector() {
        return this.myRevSelector;
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision, @Nullable FilePath path) throws VcsException {
        if (revision == null || revision.length() == 0) {
            return null;
        }
        if (revision.length() > 40) {
            String dateString = revision.substring(0, revision.indexOf("["));
            String rev = revision.substring(revision.indexOf("[") + 1, 40);
            Date d = new Date(Date.parse(dateString));
            return new GitRevisionNumber(rev, d);
        }
        if (path != null) {
            try {
                VirtualFile root = GitUtil.getGitRoot(path);
                return GitRevisionNumber.resolve(this.myProject, root, revision);
            }
            catch (VcsException e) {
                LOG.info("Unexpected problem with resolving the git revision number: ", (Throwable)e);
                throw e;
            }
        }
        return new GitRevisionNumber(revision);
    }

    @Nullable
    public VcsRevisionNumber parseRevisionNumber(@Nullable String revision) throws VcsException {
        return this.parseRevisionNumber(revision, null);
    }

    public boolean isVersionedDirectory(VirtualFile dir) {
        return dir.isDirectory() && GitUtil.gitRootOrNull(dir) != null;
    }

    protected void activate() {
        this.myExecutableManager.testGitExecutableVersionValid(this.myProject);
        if (this.myVFSListener == null) {
            this.myVFSListener = new GitVFSListener(this.myProject, this, this.myGit, this.myVcsConsoleWriter);
        }
        ServiceManager.getService((Project)this.myProject, VcsUserRegistry.class);
        if (!ApplicationManager.getApplication().isHeadlessEnvironment()) {
            this.myBranchWidget = new GitBranchWidget(this.myProject);
            this.myBranchWidget.activate();
        }
        if (this.myRepositoryForAnnotationsListener == null) {
            this.myRepositoryForAnnotationsListener = new GitRepositoryForAnnotationsListener(this.myProject);
        }
        GitUserRegistry.getInstance(this.myProject).activate();
        if (GitVcsSettings.getInstance(this.myProject).shouldUpdateBranchInfo()) {
            GitBranchIncomingOutgoingManager.getInstance(this.myProject).startScheduling();
        }
    }

    protected void deactivate() {
        if (this.myVFSListener != null) {
            Disposer.dispose((Disposable)this.myVFSListener);
            this.myVFSListener = null;
        }
        if (this.myBranchWidget != null) {
            this.myBranchWidget.deactivate();
            this.myBranchWidget = null;
        }
    }

    @NotNull
    public synchronized Configurable getConfigurable() {
        return this.myConfigurable;
    }

    @Nullable
    public ChangeProvider getChangeProvider() {
        return this.myChangeProvider;
    }

    public void showErrors(@NotNull List<VcsException> list, @NotNull String action) {
        if (list.size() > 0) {
            StringBuilder buffer = new StringBuilder();
            buffer.append("\n");
            buffer.append(GitBundle.message("error.list.title", action));
            for (VcsException exception : list) {
                buffer.append("\n");
                buffer.append(exception.getMessage());
            }
            String msg = buffer.toString();
            UIUtil.invokeLaterIfNeeded(() -> Messages.showErrorDialog((Project)this.myProject, (String)msg, (String)GitBundle.getString("error.dialog.title")));
        }
    }

    @NotNull
    public GitVersion getVersion() {
        return this.myExecutableManager.getVersion(this.myProject);
    }

    @Deprecated
    public void showCommandLine(String cmdLine) {
        this.myVcsConsoleWriter.showCommandLine(cmdLine);
    }

    public boolean allowsNestedRoots() {
        return true;
    }

    @NotNull
    public <S> List<S> filterUniqueRoots(@NotNull List<S> in, @NotNull Function<S, VirtualFile> convertor) {
        Collections.sort(in, Comparator.comparing(convertor, FilePathComparator.getInstance()));
        block0: for (int i = 1; i < in.size(); ++i) {
            S sChild = in.get(i);
            VirtualFile child = convertor.apply(sChild);
            VirtualFile childRoot = GitUtil.gitRootOrNull(child);
            if (childRoot == null) continue;
            for (int j = i - 1; j >= 0; --j) {
                S sParent = in.get(j);
                VirtualFile parent = convertor.apply(sParent);
                if (!VfsUtilCore.isAncestor((VirtualFile)parent, (VirtualFile)child, (boolean)false) || !VfsUtilCore.isAncestor((VirtualFile)childRoot, (VirtualFile)parent, (boolean)false)) continue;
                in.remove(i);
                --i;
                continue block0;
            }
        }
        return in;
    }

    public AbstractVcs.RootsConvertor getCustomConvertor() {
        return GitRootConverter.INSTANCE;
    }

    public static VcsKey getKey() {
        return ourKey;
    }

    public VcsType getType() {
        return VcsType.distributed;
    }

    protected VcsOutgoingChangesProvider<CommittedChangeList> getOutgoingProviderImpl() {
        return this.myOutgoingChangesProvider;
    }

    public RemoteDifferenceStrategy getRemoteDifferenceStrategy() {
        return RemoteDifferenceStrategy.ASK_TREE_PROVIDER;
    }

    public List<CommitExecutor> getCommitExecutors() {
        return this.myCommitAndPushExecutor != null ? Collections.singletonList(this.myCommitAndPushExecutor) : Collections.emptyList();
    }

    @Deprecated
    @NotNull
    public GitExecutableValidator getExecutableValidator() {
        return this.myExecutableValidator;
    }

    public boolean fileListenerIsSynchronous() {
        return false;
    }

    public void enableIntegration() {
        Runnable task = () -> {
            Collection roots = ((VcsRootDetector)ServiceManager.getService((Project)this.myProject, VcsRootDetector.class)).detect();
            new GitIntegrationEnabler(this, this.myGit).enable(roots);
        };
        BackgroundTaskUtil.executeOnPooledThread((Disposable)this.myProject, (Runnable)task);
    }

    public CheckoutProvider getCheckoutProvider() {
        return new GitCheckoutProvider(Git.getInstance());
    }

    public boolean arePartialChangelistsSupported() {
        return true;
    }

    public GitVFSListener getVFSListener() {
        return this.myVFSListener;
    }
}

