/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsDataKeys;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.changes.Change;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.ChangesUtil;
import com.intellij.openapi.vcs.changes.actions.ScheduleForAdditionAction;
import com.intellij.openapi.vcs.changes.ui.ChangesBrowserBase;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Function;
import com.intellij.util.Functions;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.UtilKt;
import com.intellij.vcsUtil.VcsFileUtil;
import com.intellij.vcsUtil.VcsUtil;
import git4idea.GitVcs;
import git4idea.util.GitFileUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jetbrains.annotations.NotNull;

public class GitAdd
extends ScheduleForAdditionAction {
    protected boolean isEnabled(@NotNull AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        if (project == null) {
            return false;
        }
        if (!UtilKt.isEmpty((Stream)GitAdd.getUnversionedFiles((AnActionEvent)e, (Project)project))) {
            return true;
        }
        Stream changeStream = UtilKt.stream((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        if (!UtilKt.isEmpty(GitAdd.collectPathsFromChanges(project, changeStream))) {
            return true;
        }
        Stream filesStream = UtilKt.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
        return !UtilKt.isEmpty(GitAdd.collectPathsFromFiles(project, filesStream));
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        HashSet toAdd = new HashSet();
        Stream changeStream = UtilKt.stream((Object[])((Object[])e.getData(VcsDataKeys.CHANGES)));
        ContainerUtil.addAll(toAdd, GitAdd.collectPathsFromChanges(project, changeStream).iterator());
        Stream filesStream = UtilKt.notNullize((Stream)((Stream)e.getData(VcsDataKeys.VIRTUAL_FILE_STREAM)));
        ContainerUtil.addAll(toAdd, GitAdd.collectPathsFromFiles(project, filesStream).iterator());
        List unversionedFiles = GitAdd.getUnversionedFiles((AnActionEvent)e, (Project)project).collect(Collectors.toList());
        GitAdd.addUnversioned((Project)project, unversionedFiles, (ChangesBrowserBase)((ChangesBrowserBase)e.getData(ChangesBrowserBase.DATA_KEY)), !toAdd.isEmpty() ? (indicator, exceptions) -> GitAdd.addPathsToVcs(project, toAdd, exceptions) : null);
    }

    private static void addPathsToVcs(@NotNull Project project, @NotNull Collection<FilePath> toAdd, @NotNull List<VcsException> exceptions) {
        VcsUtil.groupByRoots((Project)project, toAdd, (Function)Functions.identity()).forEach((vcsRoot, paths) -> {
            try {
                if (!(vcsRoot.getVcs() instanceof GitVcs)) {
                    return;
                }
                VirtualFile root = vcsRoot.getPath();
                if (root == null) {
                    return;
                }
                GitFileUtils.addPaths(project, root, paths);
                VcsFileUtil.markFilesDirty((Project)project, (List)paths);
            }
            catch (VcsException ex) {
                exceptions.add(ex);
            }
        });
    }

    @NotNull
    private static Stream<FilePath> collectPathsFromChanges(@NotNull Project project, @NotNull Stream<Change> allChanges) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        return allChanges.filter(change -> {
            FilePath filePath = ChangesUtil.getFilePath((Change)change);
            return vcsManager.getVcsFor(filePath) instanceof GitVcs && GitAdd.isStatusForAddition(change.getFileStatus());
        }).map(ChangesUtil::getFilePath);
    }

    @NotNull
    private static Stream<FilePath> collectPathsFromFiles(@NotNull Project project, @NotNull Stream<VirtualFile> allFiles) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.getInstance((Project)project);
        ChangeListManager changeListManager = ChangeListManager.getInstance((Project)project);
        return allFiles.filter(file -> vcsManager.getVcsFor(file) instanceof GitVcs && (file.isDirectory() || GitAdd.isStatusForAddition(changeListManager.getStatus(file)))).map(VcsUtil::getFilePath);
    }

    private static boolean isStatusForAddition(FileStatus status) {
        return status == FileStatus.MODIFIED || status == FileStatus.MERGED_WITH_CONFLICTS || status == FileStatus.ADDED || status == FileStatus.DELETED;
    }
}

