/*
 * Decompiled with CFR 0.152.
 */
package git4idea.actions;

import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import git4idea.GitUtil;
import git4idea.GitVcs;
import git4idea.fetch.GitFetchSupport;
import org.jetbrains.annotations.NotNull;

public class GitFetch
extends DumbAwareAction {
    public void update(@NotNull AnActionEvent e) {
        super.update(e);
        Project project = e.getProject();
        if (project == null) {
            e.getPresentation().setEnabledAndVisible(false);
        } else {
            boolean hasRemotes = GitUtil.getRepositories(project).stream().anyMatch(repository -> !repository.getRemotes().isEmpty());
            e.getPresentation().setEnabledAndVisible(hasRemotes);
        }
    }

    public void actionPerformed(@NotNull AnActionEvent e) {
        final Project project = (Project)e.getRequiredData(CommonDataKeys.PROJECT);
        GitVcs.runInBackground(new Task.Backgroundable(project, "Fetching...", true){

            public void run(@NotNull ProgressIndicator indicator) {
                GitFetchSupport.fetchSupport(project).fetchAllRemotes(GitUtil.getRepositories(project)).showNotification();
            }
        });
    }
}

